/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.cloner;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.optaplanner.core.api.domain.solution.cloner.DeepPlanningClone;
import org.optaplanner.core.api.domain.variable.PlanningListVariable;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.solution.cloner.ConcurrentMemoization;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.util.Pair;

public final class DeepCloningUtils {
    public static final Set<Class<?>> IMMUTABLE_CLASSES = Set.of(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class, Optional.class, OptionalInt.class, OptionalLong.class, OptionalDouble.class, Duration.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, Period.class, Year.class, YearMonth.class, ZonedDateTime.class, ZoneId.class, ZoneOffset.class, Boolean.class, Character.class, String.class, UUID.class, SimpleScore.class, SimpleLongScore.class, SimpleBigDecimalScore.class, HardSoftScore.class, HardSoftLongScore.class, HardSoftBigDecimalScore.class, HardMediumSoftScore.class, HardMediumSoftLongScore.class, HardMediumSoftBigDecimalScore.class, BendableScore.class, BendableLongScore.class, BendableBigDecimalScore.class);
    private final SolutionDescriptor<?> solutionDescriptor;
    private final ConcurrentMap<Pair<Field, Class<?>>, Boolean> fieldDeepClonedMemoization;
    private final ConcurrentMap<Class<?>, Boolean> actualValueClassDeepClonedMemoization;

    public DeepCloningUtils(SolutionDescriptor<?> solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
        this.fieldDeepClonedMemoization = new ConcurrentMemoization();
        this.actualValueClassDeepClonedMemoization = new ConcurrentMemoization();
    }

    public boolean getDeepCloneDecision(Field field, Class<?> owningClass, Class<?> actualValueClass) {
        Pair<Field, Class<?>> pair = Pair.of(field, owningClass);
        Boolean deepCloneDecision = this.fieldDeepClonedMemoization.computeIfAbsent(pair, key -> this.isFieldDeepCloned(field, owningClass));
        return deepCloneDecision != false || this.actualValueClassDeepClonedMemoization.computeIfAbsent(actualValueClass, key -> this.isClassDeepCloned(actualValueClass)) != false;
    }

    public boolean retrieveDeepCloneDecisionForActualValueClass(Class<?> actualValueClass) {
        return this.actualValueClassDeepClonedMemoization.computeIfAbsent(actualValueClass, key -> this.isClassDeepCloned(actualValueClass));
    }

    public boolean isFieldDeepCloned(Field field, Class<?> owningClass) {
        Class<?> fieldType = field.getType();
        if (fieldType.isPrimitive() || fieldType.isEnum()) {
            return false;
        }
        if (IMMUTABLE_CLASSES.contains(fieldType)) {
            return false;
        }
        return this.isFieldAnEntityPropertyOnSolution(field, owningClass) || this.isFieldAnEntityOrSolution(field) || this.isFieldAPlanningListVariable(field, owningClass) || this.isFieldADeepCloneProperty(field, owningClass);
    }

    public boolean isFieldAnEntityPropertyOnSolution(Field field, Class<?> owningClass) {
        if (!this.solutionDescriptor.getSolutionClass().isAssignableFrom(owningClass)) {
            return false;
        }
        String fieldName = field.getName();
        if (this.solutionDescriptor.getEntityMemberAccessorMap().get(fieldName) != null) {
            return true;
        }
        return this.solutionDescriptor.getEntityCollectionMemberAccessorMap().get(fieldName) != null;
    }

    public boolean isFieldAnEntityOrSolution(Field field) {
        Class<?> type = field.getType();
        if (this.isClassDeepCloned(type)) {
            return true;
        }
        return Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) ? this.isTypeArgumentDeepCloned(field.getGenericType()) : type.isArray() && this.isClassDeepCloned(type.getComponentType());
    }

    public boolean isClassDeepCloned(Class<?> type) {
        if (IMMUTABLE_CLASSES.contains(type)) {
            return false;
        }
        return this.solutionDescriptor.hasEntityDescriptor(type) || this.solutionDescriptor.getSolutionClass().isAssignableFrom(type) || type.isAnnotationPresent(DeepPlanningClone.class);
    }

    public boolean isTypeArgumentDeepCloned(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
                if (actualTypeArgument instanceof Class && this.isClassDeepCloned((Class)actualTypeArgument)) {
                    return true;
                }
                if (!this.isTypeArgumentDeepCloned(actualTypeArgument)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFieldADeepCloneProperty(Field field, Class<?> owningClass) {
        if (field.isAnnotationPresent(DeepPlanningClone.class)) {
            return true;
        }
        Method getterMethod = ReflectionHelper.getGetterMethod(owningClass, field.getName());
        return getterMethod != null && getterMethod.isAnnotationPresent(DeepPlanningClone.class);
    }

    public boolean isFieldAPlanningListVariable(Field field, Class<?> owningClass) {
        if (field.isAnnotationPresent(PlanningListVariable.class)) {
            return true;
        }
        Method getterMethod = ReflectionHelper.getGetterMethod(owningClass, field.getName());
        return getterMethod != null && getterMethod.isAnnotationPresent(PlanningListVariable.class);
    }

    public Set<Class<?>> getDeepClonedTypeArguments(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return Collections.emptySet();
        }
        HashSet deepClonedTypeArguments = new HashSet();
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
            if (actualTypeArgument instanceof Class && this.isClassDeepCloned((Class)actualTypeArgument)) {
                deepClonedTypeArguments.add((Class)actualTypeArgument);
            }
            deepClonedTypeArguments.addAll(this.getDeepClonedTypeArguments(actualTypeArgument));
        }
        return deepClonedTypeArguments;
    }

    public Set<Class<?>> getDeepClonedClasses(Collection<Class<?>> entitySubclasses) {
        HashSet deepClonedClassSet = new HashSet();
        Stream.of(Stream.of(this.solutionDescriptor.getSolutionClass()), this.solutionDescriptor.getEntityClassSet().stream(), entitySubclasses.stream()).flatMap(classStream -> classStream).forEach(clazz -> {
            deepClonedClassSet.add((Class<?>)clazz);
            for (Field field : DeepCloningUtils.getAllFields(clazz)) {
                deepClonedClassSet.addAll(this.getDeepClonedTypeArguments(field.getGenericType()));
                if (!this.isFieldDeepCloned(field, (Class<?>)clazz)) continue;
                deepClonedClassSet.add(field.getType());
            }
        });
        return deepClonedClassSet;
    }

    private static List<Field> getAllFields(Class<?> baseClass) {
        Stream<Object> memberStream = Stream.empty();
        for (Class<?> clazz = baseClass; clazz != null; clazz = clazz.getSuperclass()) {
            Stream<Field> fieldStream = Stream.of(clazz.getDeclaredFields());
            memberStream = Stream.concat(memberStream, fieldStream);
        }
        return memberStream.collect(Collectors.toList());
    }
}

