/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.nearby;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;

public final class NearbyDistanceMatrix<Origin, Destination> {
    private final NearbyDistanceMeter<Origin, Destination> nearbyDistanceMeter;
    private final Map<Origin, Destination[]> originToDestinationsMap;
    private final Function<Origin, Iterator<Destination>> destinationIteratorProvider;
    private final ToIntFunction<Origin> destinationSizeFunction;

    public <Solution_> NearbyDistanceMatrix(NearbyDistanceMeter<Origin, Destination> nearbyDistanceMeter, int originSize, ValueSelector<Solution_> destinationSelector, ToIntFunction<Origin> destinationSizeFunction) {
        this(nearbyDistanceMeter, originSize, (Origin origin) -> destinationSelector.endingIterator(origin), destinationSizeFunction);
    }

    public <Solution_> NearbyDistanceMatrix(NearbyDistanceMeter<Origin, Destination> nearbyDistanceMeter, int originSize, EntitySelector<Solution_> destinationSelector, ToIntFunction<Origin> destinationSizeFunction) {
        this(nearbyDistanceMeter, originSize, (Origin origin) -> destinationSelector.endingIterator(), destinationSizeFunction);
    }

    NearbyDistanceMatrix(NearbyDistanceMeter<Origin, Destination> nearbyDistanceMeter, int originSize, List<Destination> destinationSelector, ToIntFunction<Origin> destinationSizeFunction) {
        this(nearbyDistanceMeter, originSize, (Origin origin) -> destinationSelector.iterator(), destinationSizeFunction);
    }

    private NearbyDistanceMatrix(NearbyDistanceMeter<Origin, Destination> nearbyDistanceMeter, int originSize, Function<Origin, Iterator<Destination>> destinationIteratorProvider, ToIntFunction<Origin> destinationSizeFunction) {
        this.nearbyDistanceMeter = nearbyDistanceMeter;
        this.originToDestinationsMap = new HashMap<Origin, Destination[]>(originSize, 1.0f);
        this.destinationIteratorProvider = destinationIteratorProvider;
        this.destinationSizeFunction = destinationSizeFunction;
    }

    public void addAllDestinations(Origin origin) {
        int destinationSize = this.destinationSizeFunction.applyAsInt(origin);
        Object[] destinations = new Object[destinationSize];
        double[] distances = new double[destinationSize];
        Iterator<Destination> destinationIterator = this.destinationIteratorProvider.apply(origin);
        int size = 0;
        double highestDistance = Double.MAX_VALUE;
        while (destinationIterator.hasNext()) {
            Destination destination = destinationIterator.next();
            double distance = this.nearbyDistanceMeter.getNearbyDistance(origin, destination);
            if (!(distance < highestDistance) && size >= destinationSize) continue;
            int insertIndex = Arrays.binarySearch(distances, 0, size, distance);
            if (insertIndex < 0) {
                insertIndex = -insertIndex - 1;
            } else {
                while (insertIndex < size && distances[insertIndex] == distance) {
                    ++insertIndex;
                }
            }
            if (size < destinationSize) {
                ++size;
            }
            System.arraycopy(destinations, insertIndex, destinations, insertIndex + 1, size - insertIndex - 1);
            System.arraycopy(distances, insertIndex, distances, insertIndex + 1, size - insertIndex - 1);
            destinations[insertIndex] = destination;
            distances[insertIndex] = distance;
            highestDistance = distances[size - 1];
        }
        if (size != destinationSize) {
            throw new IllegalStateException("The destinationIterator's size (" + size + ") differs from the expected destinationSize (" + destinationSize + ").");
        }
        this.originToDestinationsMap.put(origin, destinations);
    }

    public Object getDestination(Origin origin, int nearbyIndex) {
        Destination[] destinations = this.originToDestinationsMap.get(origin);
        if (destinations == null) {
            this.addAllDestinations(origin);
            destinations = this.originToDestinationsMap.get(origin);
        }
        return destinations[nearbyIndex];
    }
}

