/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.ElementDestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.RandomSubListChangeMoveIterator;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.RandomSubListSelector;

public class RandomSubListChangeMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final RandomSubListSelector<Solution_> subListSelector;
    private final ElementDestinationSelector<Solution_> destinationSelector;
    private final boolean selectReversingMoveToo;

    public RandomSubListChangeMoveSelector(ListVariableDescriptor<Solution_> listVariableDescriptor, RandomSubListSelector<Solution_> subListSelector, ElementDestinationSelector<Solution_> destinationSelector, boolean selectReversingMoveToo) {
        this.listVariableDescriptor = listVariableDescriptor;
        this.subListSelector = subListSelector;
        this.destinationSelector = destinationSelector;
        this.selectReversingMoveToo = selectReversingMoveToo;
        this.phaseLifecycleSupport.addEventListener(subListSelector);
        this.phaseLifecycleSupport.addEventListener(destinationSelector);
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        return new RandomSubListChangeMoveIterator<Solution_>(this.listVariableDescriptor, this.subListSelector, this.destinationSelector, this.workingRandom, this.selectReversingMoveToo);
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return true;
    }

    @Override
    public long getSize() {
        long destinationCount = this.destinationSelector.getSize();
        long subListCount = this.subListSelector.getSize();
        return subListCount * destinationCount * (long)(this.selectReversingMoveToo ? 2 : 1);
    }

    boolean isSelectReversingMoveToo() {
        return this.selectReversingMoveToo;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.subListSelector + ", " + this.destinationSelector + ")";
    }
}

