/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CollectionUtils {
    public static <E> List<E> copy(List<E> originalList, boolean reverse) {
        if (!reverse) {
            return new ArrayList<E>(originalList);
        }
        switch (originalList.size()) {
            case 0: {
                return new ArrayList(0);
            }
            case 1: {
                ArrayList<E> singletonList = new ArrayList<E>(1);
                singletonList.add(originalList.get(0));
                return singletonList;
            }
            case 2: {
                ArrayList<E> smallList = new ArrayList<E>(2);
                smallList.add(originalList.get(1));
                smallList.add(originalList.get(0));
                return smallList;
            }
        }
        ArrayList<E> largeList = new ArrayList<E>(originalList);
        Collections.reverse(largeList);
        return largeList;
    }

    public static <T> List<T> concat(List<T> left, List<T> right) {
        ArrayList<T> result = new ArrayList<T>(left.size() + right.size());
        result.addAll(left);
        result.addAll(right);
        return result;
    }

    private CollectionUtils() {
    }
}

