/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.optaweb.vehiclerouting.domain.Distance;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceCrudRepository;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceEntity;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceKey;
import org.optaweb.vehiclerouting.service.distance.DistanceRepository;

@ApplicationScoped
class DistanceRepositoryImpl
implements DistanceRepository {
    private final DistanceCrudRepository distanceRepository;

    public /* synthetic */ DistanceRepositoryImpl() {
    }

    @Inject
    DistanceRepositoryImpl(DistanceCrudRepository distanceRepository) {
        this.distanceRepository = distanceRepository;
    }

    public void saveDistance(Location from, Location to, Distance distance) {
        DistanceEntity distanceEntity = new DistanceEntity(new DistanceKey(from.id(), to.id()), distance.millis());
        this.distanceRepository.persist(distanceEntity);
    }

    public Optional<Distance> getDistance(Location from, Location to) {
        return this.distanceRepository.findByIdOptional((Object)new DistanceKey(from.id(), to.id())).map(DistanceEntity::getDistance).map(Distance::ofMillis);
    }

    public void deleteDistances(Location location) {
        this.distanceRepository.deleteByFromIdOrToId(location.id());
    }

    public void deleteAll() {
        this.distanceRepository.deleteAll();
    }
}

