/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleData;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.plugin.persistence.VehicleCrudRepository;
import org.optaweb.vehiclerouting.plugin.persistence.VehicleEntity;
import org.optaweb.vehiclerouting.service.vehicle.VehicleRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class VehicleRepositoryImpl
implements VehicleRepository {
    private static final Logger logger = LoggerFactory.getLogger(VehicleRepositoryImpl.class);
    private final VehicleCrudRepository repository;

    public /* synthetic */ VehicleRepositoryImpl() {
    }

    @Inject
    public VehicleRepositoryImpl(VehicleCrudRepository repository) {
        this.repository = repository;
    }

    public Vehicle createVehicle(int capacity) {
        VehicleEntity vehicleEntity = new VehicleEntity(0L, null, capacity);
        this.repository.persist(vehicleEntity);
        vehicleEntity.setName("Vehicle " + vehicleEntity.getId());
        Vehicle vehicle = VehicleRepositoryImpl.toDomain(vehicleEntity);
        logger.info("Created vehicle {}.", (Object)vehicle);
        return vehicle;
    }

    public Vehicle createVehicle(VehicleData vehicleData) {
        VehicleEntity vehicleEntity = new VehicleEntity(0L, vehicleData.name(), vehicleData.capacity());
        this.repository.persist(vehicleEntity);
        Vehicle vehicle = VehicleRepositoryImpl.toDomain(vehicleEntity);
        logger.info("Created vehicle {}.", (Object)vehicle);
        return vehicle;
    }

    public List<Vehicle> vehicles() {
        return this.repository.streamAll().map(VehicleRepositoryImpl::toDomain).collect(Collectors.toList());
    }

    public Vehicle removeVehicle(long id) {
        Optional optionalVehicleEntity = this.repository.findByIdOptional((Object)id);
        VehicleEntity vehicleEntity = (VehicleEntity)optionalVehicleEntity.orElseThrow(() -> new IllegalArgumentException("Vehicle{id=" + id + "} doesn't exist"));
        this.repository.deleteById((Object)id);
        Vehicle vehicle = VehicleRepositoryImpl.toDomain(vehicleEntity);
        logger.info("Deleted vehicle {}.", (Object)vehicle);
        return vehicle;
    }

    public void removeAll() {
        this.repository.deleteAll();
    }

    public Optional<Vehicle> find(long vehicleId) {
        return this.repository.findByIdOptional((Object)vehicleId).map(VehicleRepositoryImpl::toDomain);
    }

    public Vehicle changeCapacity(long vehicleId, int capacity) {
        VehicleEntity vehicleEntity = (VehicleEntity)this.repository.findByIdOptional((Object)vehicleId).orElseThrow(() -> new IllegalArgumentException("Can't change Vehicle{id=" + vehicleId + "} because it doesn't exist"));
        vehicleEntity.setCapacity(capacity);
        this.repository.flush();
        return VehicleFactory.createVehicle((long)vehicleEntity.getId(), (String)vehicleEntity.getName(), (int)vehicleEntity.getCapacity());
    }

    private static Vehicle toDomain(VehicleEntity vehicleEntity) {
        return VehicleFactory.createVehicle((long)vehicleEntity.getId(), (String)vehicleEntity.getName(), (int)vehicleEntity.getCapacity());
    }
}

