/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.plugin.planner.DistanceMapImpl;
import org.optaweb.vehiclerouting.plugin.planner.RouteChangedEventPublisher;
import org.optaweb.vehiclerouting.plugin.planner.SolverManager;
import org.optaweb.vehiclerouting.plugin.planner.domain.DistanceMap;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocationFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.service.location.DistanceMatrixRow;
import org.optaweb.vehiclerouting.service.location.LocationPlanner;
import org.optaweb.vehiclerouting.service.vehicle.VehiclePlanner;

@ApplicationScoped
class RouteOptimizerImpl
implements LocationPlanner,
VehiclePlanner {
    private final SolverManager solverManager;
    private final RouteChangedEventPublisher routeChangedEventPublisher;
    private final List<PlanningVehicle> vehicles;
    private final List<PlanningVisit> visits;
    private PlanningDepot depot;

    public /* synthetic */ RouteOptimizerImpl() {
    }

    @Inject
    RouteOptimizerImpl(SolverManager solverManager, RouteChangedEventPublisher routeChangedEventPublisher) {
        this.vehicles = new ArrayList<PlanningVehicle>();
        this.visits = new ArrayList<PlanningVisit>();
        this.solverManager = solverManager;
        this.routeChangedEventPublisher = routeChangedEventPublisher;
    }

    public void addLocation(Location domainLocation, DistanceMatrixRow distanceMatrixRow) {
        PlanningLocation location = PlanningLocationFactory.fromDomain((Location)domainLocation, (DistanceMap)new DistanceMapImpl(distanceMatrixRow));
        if (this.depot == null) {
            this.depot = new PlanningDepot(location);
            this.publishSolution();
        } else {
            PlanningVisit visit = PlanningVisitFactory.fromLocation((PlanningLocation)location);
            this.visits.add(visit);
            if (this.vehicles.isEmpty()) {
                this.publishSolution();
            } else if (this.visits.size() == 1) {
                this.solverManager.startSolver(SolutionFactory.solutionFromVisits(this.vehicles, (PlanningDepot)this.depot, this.visits));
            } else {
                this.solverManager.addVisit(visit);
            }
        }
    }

    public void removeLocation(Location domainLocation) {
        if (this.visits.isEmpty()) {
            if (this.depot == null) {
                throw new IllegalArgumentException("Cannot remove " + domainLocation + " because there are no locations");
            }
            if (this.depot.getId() != domainLocation.id()) {
                throw new IllegalArgumentException("Cannot remove " + domainLocation + " because it doesn't exist");
            }
            this.depot = null;
            this.publishSolution();
        } else {
            if (this.depot.getId() == domainLocation.id()) {
                throw new IllegalStateException("You can only remove depot if there are no visits");
            }
            if (!this.visits.removeIf(item -> item.getId() == domainLocation.id())) {
                throw new IllegalArgumentException("Cannot remove " + domainLocation + " because it doesn't exist");
            }
            if (this.vehicles.isEmpty()) {
                this.publishSolution();
            } else if (this.visits.isEmpty()) {
                this.solverManager.stopSolver();
                this.publishSolution();
            } else {
                this.solverManager.removeVisit(PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.fromDomain((Location)domainLocation)));
            }
        }
    }

    public void addVehicle(Vehicle domainVehicle) {
        PlanningVehicle vehicle = PlanningVehicleFactory.fromDomain((Vehicle)domainVehicle);
        vehicle.setDepot(this.depot);
        this.vehicles.add(vehicle);
        if (this.visits.isEmpty()) {
            this.publishSolution();
        } else if (this.vehicles.size() == 1) {
            this.solverManager.startSolver(SolutionFactory.solutionFromVisits(this.vehicles, (PlanningDepot)this.depot, this.visits));
        } else {
            this.solverManager.addVehicle(vehicle);
        }
    }

    public void removeVehicle(Vehicle domainVehicle) {
        if (!this.vehicles.removeIf(vehicle -> vehicle.getId() == domainVehicle.id())) {
            throw new IllegalArgumentException("Cannot remove " + domainVehicle + " because it doesn't exist");
        }
        if (this.visits.isEmpty()) {
            this.publishSolution();
        } else if (this.vehicles.isEmpty()) {
            this.solverManager.stopSolver();
            this.publishSolution();
        } else {
            this.solverManager.removeVehicle(PlanningVehicleFactory.fromDomain((Vehicle)domainVehicle));
        }
    }

    public void changeCapacity(Vehicle domainVehicle) {
        PlanningVehicle vehicle = this.vehicles.stream().filter(item -> item.getId() == domainVehicle.id()).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot change capacity of " + domainVehicle + " because it doesn't exist"));
        vehicle.setCapacity(domainVehicle.capacity());
        if (!this.visits.isEmpty()) {
            this.solverManager.changeCapacity(vehicle);
        } else {
            this.publishSolution();
        }
    }

    public void removeAllLocations() {
        this.solverManager.stopSolver();
        this.depot = null;
        this.visits.clear();
        this.publishSolution();
    }

    public void removeAllVehicles() {
        this.solverManager.stopSolver();
        this.vehicles.clear();
        this.publishSolution();
    }

    private void publishSolution() {
        this.routeChangedEventPublisher.publishSolution(SolutionFactory.solutionFromVisits(this.vehicles, (PlanningDepot)this.depot, this.visits));
    }
}

