/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.rest;

import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseBroadcaster;
import javax.ws.rs.sse.SseEventSink;
import org.optaweb.vehiclerouting.domain.RoutingPlan;
import org.optaweb.vehiclerouting.plugin.rest.model.PortableErrorMessage;
import org.optaweb.vehiclerouting.plugin.rest.model.PortableRoutingPlanFactory;
import org.optaweb.vehiclerouting.service.error.ErrorMessage;
import org.optaweb.vehiclerouting.service.route.RouteListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Path(value="api/events")
public class RouteEventResource {
    private static final Logger logger = LoggerFactory.getLogger(RouteEventResource.class);
    private final RouteListener routeListener;
    private SseBroadcaster sseBroadcaster;
    private OutboundSseEvent.Builder eventBuilder;

    public /* synthetic */ RouteEventResource() {
    }

    @Inject
    public RouteEventResource(RouteListener routeListener) {
        this.routeListener = routeListener;
    }

    @PreDestroy
    public void closeBroadcaster() {
        if (this.sseBroadcaster != null) {
            logger.debug("Closing Server-Sent Events broadcaster.");
            this.sseBroadcaster.close();
        }
    }

    public void observeRoute(@Observes RoutingPlan event) {
        if (this.sseBroadcaster != null) {
            this.sseBroadcaster.broadcast(this.eventBuilder.data((Object)PortableRoutingPlanFactory.fromRoutingPlan((RoutingPlan)event)).name("route").comment("route update").build());
        }
    }

    public void observeError(@Observes ErrorMessage event) {
        if (this.sseBroadcaster != null) {
            this.sseBroadcaster.broadcast(this.eventBuilder.data((Object)PortableErrorMessage.fromMessage((ErrorMessage)event)).name("errorMessage").comment("error message").build());
        }
    }

    @GET
    @Produces(value={"text/event-stream"})
    public void sse(@Context Sse sse, @Context SseEventSink eventSink) {
        if (this.sseBroadcaster == null) {
            this.sseBroadcaster = sse.newBroadcaster();
            this.eventBuilder = sse.newEventBuilder().mediaType(MediaType.APPLICATION_JSON_TYPE).reconnectDelay(3000L);
        }
        OutboundSseEvent sseEvent = this.eventBuilder.data((Object)PortableRoutingPlanFactory.fromRoutingPlan((RoutingPlan)this.routeListener.getBestRoutingPlan())).comment("best route").build();
        eventSink.send(sseEvent);
        this.sseBroadcaster.register(eventSink);
    }
}

