/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.routing;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.ResponsePath;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import io.quarkus.arc.properties.IfBuildProperty;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.service.distance.DistanceCalculator;
import org.optaweb.vehiclerouting.service.distance.RoutingException;
import org.optaweb.vehiclerouting.service.region.BoundingBox;
import org.optaweb.vehiclerouting.service.region.Region;
import org.optaweb.vehiclerouting.service.route.Router;

@ApplicationScoped
@IfBuildProperty(name="app.routing.engine", stringValue="GRAPHHOPPER", enableIfMissing=true)
class GraphHopperRouter
implements Router,
DistanceCalculator,
Region {
    private final GraphHopper graphHopper;

    public /* synthetic */ GraphHopperRouter() {
    }

    @Inject
    GraphHopperRouter(GraphHopper graphHopper) {
        this.graphHopper = graphHopper;
    }

    public List<Coordinates> getPath(Coordinates from, Coordinates to) {
        PointList points = this.getBestRoute(from, to).getPoints();
        return StreamSupport.stream(points.spliterator(), false).map(ghPoint3D -> Coordinates.of((double)ghPoint3D.lat, (double)ghPoint3D.lon)).collect(Collectors.toList());
    }

    public long travelTimeMillis(Coordinates from, Coordinates to) {
        return this.getBestRoute(from, to).getTime();
    }

    private ResponsePath getBestRoute(Coordinates from, Coordinates to) {
        GHRequest request = new GHRequest(from.latitude().doubleValue(), from.longitude().doubleValue(), to.latitude().doubleValue(), to.longitude().doubleValue()).setProfile("optaweb_car");
        GHResponse response = this.graphHopper.route(request);
        if (response.hasErrors()) {
            throw new RoutingException("No route from (" + from + ") to (" + to + ")", (Throwable)response.getErrors().get(0));
        }
        return response.getBest();
    }

    public BoundingBox getBounds() {
        BBox bounds = this.graphHopper.getBaseGraph().getBounds();
        return new BoundingBox(Coordinates.of((double)bounds.minLat, (double)bounds.minLon), Coordinates.of((double)bounds.maxLat, (double)bounds.maxLon));
    }
}

