/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.demo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.LocationData;
import org.optaweb.vehiclerouting.domain.RoutingProblem;
import org.optaweb.vehiclerouting.service.demo.RoutingProblemList;
import org.optaweb.vehiclerouting.service.demo.dataset.DataSetMarshaller;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.optaweb.vehiclerouting.service.location.LocationService;
import org.optaweb.vehiclerouting.service.vehicle.VehicleRepository;
import org.optaweb.vehiclerouting.service.vehicle.VehicleService;

@ApplicationScoped
public class DemoService {
    static final int MAX_TRIES = 10;
    private final RoutingProblemList routingProblems;
    private final LocationService locationService;
    private final LocationRepository locationRepository;
    private final VehicleService vehicleService;
    private final VehicleRepository vehicleRepository;
    private final DataSetMarshaller dataSetMarshaller;

    public /* synthetic */ DemoService() {
    }

    @Inject
    public DemoService(RoutingProblemList routingProblems, LocationService locationService, LocationRepository locationRepository, VehicleService vehicleService, VehicleRepository vehicleRepository, DataSetMarshaller dataSetMarshaller) {
        this.routingProblems = routingProblems;
        this.locationService = locationService;
        this.locationRepository = locationRepository;
        this.vehicleService = vehicleService;
        this.vehicleRepository = vehicleRepository;
        this.dataSetMarshaller = dataSetMarshaller;
    }

    public Collection<RoutingProblem> demos() {
        return this.routingProblems.all();
    }

    public void loadDemo(String name) {
        RoutingProblem routingProblem = this.routingProblems.byName(name);
        routingProblem.depot().ifPresent(depot -> this.addWithRetry(depot.coordinates(), depot.description()));
        routingProblem.visits().forEach(visit -> this.addWithRetry(visit.coordinates(), visit.description()));
        routingProblem.vehicles().forEach(this.vehicleService::createVehicle);
    }

    private void addWithRetry(Coordinates coordinates, String description) {
        int tries;
        for (tries = 0; tries < 10 && !this.locationService.createLocation(coordinates, description).isPresent(); ++tries) {
        }
        if (tries == 10) {
            throw new RuntimeException("Impossible to create a new location near " + coordinates + " after " + tries + " attempts");
        }
    }

    public String exportDataSet() {
        ArrayList visits = new ArrayList(this.locationRepository.locations());
        Location depot = visits.isEmpty() ? null : (Location)visits.remove(0);
        List vehicles = this.vehicleRepository.vehicles();
        return this.dataSetMarshaller.marshal(new RoutingProblem("Custom Vehicle Routing instance", vehicles, (LocationData)depot, visits));
    }
}

