/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.distance;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.optaweb.vehiclerouting.domain.Distance;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.service.distance.DistanceCalculator;
import org.optaweb.vehiclerouting.service.location.DistanceMatrix;
import org.optaweb.vehiclerouting.service.location.DistanceMatrixRow;

@ApplicationScoped
class DistanceMatrixImpl
implements DistanceMatrix {
    private final DistanceCalculator distanceCalculator;
    private final Map<Location, Map<Long, Distance>> matrix = new HashMap<Location, Map<Long, Distance>>();

    @Inject
    DistanceMatrixImpl(DistanceCalculator distanceCalculator) {
        this.distanceCalculator = distanceCalculator;
    }

    @Override
    public DistanceMatrixRow addLocation(Location newLocation) {
        Map<Long, Distance> distancesToOthers = this.updateMatrixLazily(newLocation);
        return locationId -> distancesToOthers.computeIfAbsent(locationId, wrongId -> {
            throw new IllegalArgumentException("Distance from " + newLocation + " to " + wrongId + " hasn't been recorded.\nWe only know distances to " + distancesToOthers.keySet());
        });
    }

    private Map<Long, Distance> updateMatrixLazily(Location location) {
        return this.matrix.computeIfAbsent(location, newLocation -> {
            ConcurrentHashMap<Long, Distance> distancesToOthers = new ConcurrentHashMap<Long, Distance>();
            distancesToOthers.put(newLocation.id(), Distance.ZERO);
            ((Stream)this.matrix.entrySet().stream().parallel()).forEach(distanceRow -> {
                Location other = (Location)distanceRow.getKey();
                Map distancesFromOther = (Map)distanceRow.getValue();
                distancesFromOther.put(newLocation.id(), this.calculateDistance(other, (Location)newLocation));
                distancesToOthers.put(other.id(), this.calculateDistance((Location)newLocation, other));
            });
            return distancesToOthers;
        });
    }

    private Distance calculateDistance(Location from, Location to) {
        return Distance.ofMillis(this.distanceCalculator.travelTimeMillis(from.coordinates(), to.coordinates()));
    }

    @Override
    public Distance distance(Location from, Location to) {
        if (!this.matrix.containsKey(from)) {
            throw new IllegalArgumentException("Unknown 'from' location (" + from + ")");
        }
        Map<Long, Distance> distanceRow = this.matrix.get(from);
        if (!distanceRow.containsKey(to.id())) {
            throw new IllegalArgumentException("Unknown 'to' location (" + to + ")");
        }
        return distanceRow.get(to.id());
    }

    @Override
    public void put(Location from, Location to, Distance distance) {
        this.matrix.computeIfAbsent(from, location -> new ConcurrentHashMap()).put(to.id(), distance);
    }

    @Override
    public void removeLocation(Location location) {
        this.matrix.remove(location);
    }

    @Override
    public void clear() {
        this.matrix.clear();
    }

    public int dimension() {
        return this.matrix.size();
    }
}

