/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.util.Nonbinding;
import javax.inject.Qualifier;

public final class Qualifiers {
    public static final Set<Annotation> DEFAULT_QUALIFIERS = Qualifiers.initDefaultQualifiers();
    public static final Set<Annotation> IP_DEFAULT_QUALIFIERS = Collections.singleton(Default.Literal.INSTANCE);

    private Qualifiers() {
    }

    static void verify(Iterable<Annotation> qualifiers) {
        for (Annotation qualifier : qualifiers) {
            Qualifiers.verifyQualifier(qualifier.annotationType());
        }
    }

    static void verify(Annotation ... qualifiers) {
        for (Annotation qualifier : qualifiers) {
            Qualifiers.verifyQualifier(qualifier.annotationType());
        }
    }

    static boolean hasQualifiers(Set<Annotation> beanQualifiers, Map<String, Set<String>> qualifierNonbindingMembers, Annotation ... requiredQualifiers) {
        for (Annotation qualifier : requiredQualifiers) {
            if (Qualifiers.hasQualifier(beanQualifiers, qualifier, qualifierNonbindingMembers)) continue;
            return false;
        }
        return true;
    }

    static boolean hasQualifier(Iterable<Annotation> qualifiers, Annotation requiredQualifier, Map<String, Set<String>> qualifierNonbindingMembers) {
        Class<? extends Annotation> requiredQualifierClass = requiredQualifier.annotationType();
        Method[] members = requiredQualifierClass.getDeclaredMethods();
        for (Annotation qualifier : qualifiers) {
            Class<? extends Annotation> qualifierClass = qualifier.annotationType();
            if (!qualifierClass.equals(requiredQualifierClass)) continue;
            boolean matches = true;
            for (Method value : members) {
                Set<String> nonbindingMembers;
                if (value.isAnnotationPresent(Nonbinding.class) || !qualifierNonbindingMembers.isEmpty() && (nonbindingMembers = qualifierNonbindingMembers.get(qualifierClass.getName())) != null && nonbindingMembers.contains(value.getName())) continue;
                Object val1 = Qualifiers.invoke(value, requiredQualifier);
                Object val2 = Qualifiers.invoke(value, qualifier);
                if (val1.getClass().isArray()) {
                    if (val2.getClass().isArray() && Arrays.equals((Object[])val1, (Object[])val2)) continue;
                    matches = false;
                    break;
                }
                if (val1.equals(val2)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }

    static boolean isSubset(Set<Annotation> observedQualifiers, Set<Annotation> eventQualifiers, Map<String, Set<String>> qualifierNonbindingMembers) {
        for (Annotation required : observedQualifiers) {
            if (Qualifiers.hasQualifier(eventQualifiers, required, qualifierNonbindingMembers)) continue;
            return false;
        }
        return true;
    }

    private static Set<Annotation> initDefaultQualifiers() {
        HashSet<Object> qualifiers = new HashSet<Object>();
        qualifiers.add(Default.Literal.INSTANCE);
        qualifiers.add(Any.Literal.INSTANCE);
        return Collections.unmodifiableSet(qualifiers);
    }

    private static Object invoke(Method method, Object instance) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Error checking value of member method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
    }

    private static void verifyQualifier(Class<? extends Annotation> annotationType) {
        if (!annotationType.isAnnotationPresent(Qualifier.class)) {
            throw new IllegalArgumentException("Annotation is not a qualifier: " + annotationType);
        }
    }
}

