/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.Helper;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.PointList;
import com.graphhopper.util.Translation;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class InstructionList
extends AbstractList<Instruction> {
    private final List<Instruction> instructions;
    private final Translation tr;

    public InstructionList(Translation tr) {
        this(10, tr);
    }

    public InstructionList(int cap, Translation tr) {
        this.instructions = new ArrayList<Instruction>(cap);
        this.tr = tr;
    }

    @Override
    public int size() {
        return this.instructions.size();
    }

    @Override
    public Instruction get(int index) {
        return this.instructions.get(index);
    }

    @Override
    public Instruction set(int index, Instruction element) {
        return this.instructions.set(index, element);
    }

    @Override
    public void add(int index, Instruction element) {
        this.instructions.add(index, element);
    }

    @Override
    public Instruction remove(int index) {
        return this.instructions.remove(index);
    }

    public Instruction find(double lat, double lon, double maxDistance) {
        if (this.size() == 0) {
            return null;
        }
        PointList points = this.get(0).getPoints();
        double prevLat = points.getLatitude(0);
        double prevLon = points.getLongitude(0);
        DistanceCalc distCalc = Helper.DIST_EARTH;
        double foundMinDistance = distCalc.calcNormalizedDist(lat, lon, prevLat, prevLon);
        int foundInstruction = 0;
        if (this.size() > 1) {
            for (int instructionIndex = 0; instructionIndex < this.size(); ++instructionIndex) {
                points = this.get(instructionIndex).getPoints();
                for (int pointIndex = 0; pointIndex < points.size(); ++pointIndex) {
                    double currLat = points.getLatitude(pointIndex);
                    double currLon = points.getLongitude(pointIndex);
                    if (instructionIndex != 0 || pointIndex != 0) {
                        double distance;
                        int index = instructionIndex;
                        if (distCalc.validEdgeDistance(lat, lon, currLat, currLon, prevLat, prevLon)) {
                            distance = distCalc.calcNormalizedEdgeDistance(lat, lon, currLat, currLon, prevLat, prevLon);
                            if (pointIndex > 0) {
                                ++index;
                            }
                        } else {
                            distance = distCalc.calcNormalizedDist(lat, lon, currLat, currLon);
                            if (pointIndex > 0) {
                                ++index;
                            }
                        }
                        if (distance < foundMinDistance) {
                            foundMinDistance = distance;
                            foundInstruction = index;
                        }
                    }
                    prevLat = currLat;
                    prevLon = currLon;
                }
            }
        }
        if (distCalc.calcDenormalizedDist(foundMinDistance) > maxDistance) {
            return null;
        }
        if (foundInstruction == this.size()) {
            --foundInstruction;
        }
        return this.get(foundInstruction);
    }

    public Translation getTr() {
        return this.tr;
    }
}

