/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.ApplicationPropertiesConfigSourceLoader;
import io.quarkus.runtime.configuration.ProfileManager;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.DotEnvConfigSourceProvider;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.Expressions;
import io.smallrye.config.PropertiesConfigSourceProvider;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SysPropConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.logging.Logger;

public final class ConfigUtils {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.config");

    private ConfigUtils() {
    }

    public static <T> IntFunction<List<T>> listFactory() {
        return ArrayList::new;
    }

    public static <T> IntFunction<Set<T>> setFactory() {
        return LinkedHashSet::new;
    }

    public static <T> IntFunction<SortedSet<T>> sortedSetFactory() {
        return size -> new TreeSet();
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime) {
        return ConfigUtils.configBuilder(runTime, true);
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime, boolean addDiscovered) {
        SmallRyeConfigBuilder builder = new SmallRyeConfigBuilder();
        builder.withDefaultValue("smallrye.config.profile", ProfileManager.getActiveProfile());
        final HashMap<String, String> relocations = new HashMap<String, String>();
        relocations.put("smallrye.config.locations", "quarkus.config.locations");
        relocations.put("smallrye.config.profile.parent", "quarkus.config.profile.parent");
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new RelocateConfigSourceInterceptor(relocations);
            }

            public OptionalInt getPriority() {
                return OptionalInt.of(3595);
            }
        }});
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        builder.withSources((Collection)new ApplicationPropertiesConfigSourceLoader.InFileSystem().getConfigSources(classLoader));
        builder.withSources((Collection)new ApplicationPropertiesConfigSourceLoader.InClassPath().getConfigSources(classLoader));
        builder.addDefaultInterceptors();
        if (runTime) {
            builder.addDefaultSources();
            builder.withSources((Collection)DotEnvConfigSourceProvider.dotEnvSources((ClassLoader)classLoader));
        } else {
            ArrayList<Object> sources = new ArrayList<Object>();
            sources.addAll(PropertiesConfigSourceProvider.classPathSources((String)"META-INF/microprofile-config.properties", (ClassLoader)classLoader));
            sources.addAll(PropertiesConfigSourceProvider.classPathSources((String)"WEB-INF/classes/META-INF/microprofile-config.properties", (ClassLoader)classLoader));
            sources.addAll(new BuildTimeDotEnvConfigSourceProvider().getConfigSources(classLoader));
            sources.add((Object)new BuildTimeEnvConfigSource());
            sources.add((Object)new BuildTimeSysPropConfigSource());
            builder.withSources(sources);
        }
        if (addDiscovered) {
            builder.addDiscoveredSources();
            builder.addDiscoveredInterceptors();
            builder.addDiscoveredConverters();
        }
        return builder;
    }

    public static void addSourceProvider(SmallRyeConfigBuilder builder, ConfigSourceProvider provider) {
        Iterable sources = provider.getConfigSources(Thread.currentThread().getContextClassLoader());
        for (ConfigSource source : sources) {
            builder.withSources(new ConfigSource[]{source});
        }
    }

    public static void addSourceProviders(SmallRyeConfigBuilder builder, Collection<ConfigSourceProvider> providers) {
        for (ConfigSourceProvider provider : providers) {
            ConfigUtils.addSourceProvider(builder, provider);
        }
    }

    public static boolean isPropertyPresent(String propertyName) {
        Config config = ConfigProvider.getConfig();
        return ((Optional)Expressions.withoutExpansion(() -> config.getOptionalValue(propertyName, String.class))).isPresent();
    }

    static class BuildTimeSysPropConfigSource
    extends SysPropConfigSource {
        BuildTimeSysPropConfigSource() {
        }

        public Map<String, String> getProperties() {
            TreeMap<String, String> output = new TreeMap<String, String>();
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("quarkus.")) continue;
                output.put(key, entry.getValue().toString());
            }
            return output;
        }

        public String getName() {
            return "System properties";
        }
    }

    static class BuildTimeDotEnvConfigSourceProvider
    extends DotEnvConfigSourceProvider {
        public BuildTimeDotEnvConfigSourceProvider() {
        }

        public BuildTimeDotEnvConfigSourceProvider(String location) {
            super(location);
        }

        protected ConfigSource loadConfigSource(final URL url, int ordinal) throws IOException {
            return new BuildTimeEnvConfigSource(ConfigSourceUtil.urlToMap((URL)url), ordinal){

                @Override
                public String getName() {
                    return super.getName() + "[source=" + url + "]";
                }
            };
        }
    }

    static class BuildTimeEnvConfigSource
    extends EnvConfigSource {
        BuildTimeEnvConfigSource() {
        }

        BuildTimeEnvConfigSource(Map<String, String> propertyMap, int ordinal) {
            super(propertyMap, ordinal);
        }

        public Set<String> getPropertyNames() {
            return new HashSet<String>();
        }

        public String getName() {
            return "System environment";
        }
    }
}

