/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.EncodedValueLookup;
import com.graphhopper.routing.profiles.MaxWidth;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMMaxWidthParser
implements TagParser {
    private static Logger LOG = LoggerFactory.getLogger(OSMMaxWidthParser.class);
    private final DecimalEncodedValue widthEncoder;
    private final boolean enableLog;

    public OSMMaxWidthParser() {
        this(MaxWidth.create(), false);
    }

    public OSMMaxWidthParser(DecimalEncodedValue widthEncoder, boolean enableLog) {
        this.widthEncoder = widthEncoder;
        this.enableLog = enableLog;
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> registerNewEncodedValue) {
        registerNewEncodedValue.add(this.widthEncoder);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, EncodingManager.Access access, long relationFlags) {
        List<String> widthTags = Arrays.asList("maxwidth", "maxwidth:physical", "width");
        OSMMaxWidthParser.extractMeter(edgeFlags, way, this.widthEncoder, widthTags, this.enableLog);
        return edgeFlags;
    }

    static void extractMeter(IntsRef edgeFlags, ReaderWay way, DecimalEncodedValue valueEncoder, List<String> keys, boolean enableLog) {
        block4: {
            String value = way.getFirstPriorityTag(keys);
            if (Helper.isEmpty((String)value)) {
                return;
            }
            try {
                double val = OSMMaxWidthParser.stringToMeter(value);
                if (val > valueEncoder.getMaxDecimal()) {
                    val = valueEncoder.getMaxDecimal();
                }
                valueEncoder.setDecimal(false, edgeFlags, val);
            }
            catch (Exception ex) {
                if (!enableLog) break block4;
                LOG.warn("Unable to extract meter from malformed road attribute '{}' for way (OSM_ID = {}).", (Object)value, (Object)way.getId());
            }
        }
    }

    public static double stringToMeter(String value) {
        value = Helper.toLowerCase((String)value).replaceAll(" ", "").replaceAll("(meters|meter|mtrs|mtr|mt|m\\.)", "m");
        double factor = 1.0;
        double offset = 0.0;
        if ((value = value.replaceAll("(\\\"|'')", "in").replaceAll("('|feet)", "ft")).startsWith("~") || value.contains("approx")) {
            value = value.replaceAll("(\\~|approx)", "").trim();
            factor = 0.8;
        }
        if (value.equals("default") || value.equals("none") || value.equals("unsigned")) {
            return -1.0;
        }
        if (value.endsWith("in")) {
            int startIndex = value.indexOf("ft");
            startIndex = startIndex < 0 ? 0 : (startIndex += 2);
            String inchValue = value.substring(startIndex, value.length() - 2);
            value = value.substring(0, startIndex);
            offset = Double.parseDouble(inchValue) * 0.0254;
        }
        if (value.endsWith("ft")) {
            value = value.substring(0, value.length() - 2);
            factor *= 0.3048;
        } else if (value.endsWith("m")) {
            value = value.substring(0, value.length() - 1);
        }
        if (value.isEmpty()) {
            return offset;
        }
        return Double.parseDouble(value) * factor + offset;
    }
}

