import _pt from "prop-types";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { css } from '@patternfly/react-styles';
import styles from "../../@patternfly/patternfly/components/Backdrop/backdrop.css.js";
import { canUseDOM } from 'exenv';
import { KEY_CODES } from '../../helpers/constants';
import { AboutModalContainer } from './AboutModalContainer';
;
export var AboutModal =
/*#__PURE__*/
function (_React$Component) {
  _inherits(AboutModal, _React$Component);

  function AboutModal(props) {
    var _this;

    _classCallCheck(this, AboutModal);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(AboutModal).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "id", AboutModal.currentId++);

    _defineProperty(_assertThisInitialized(_this), "ariaLabelledBy", "pf-about-modal-title-".concat(_this.id));

    _defineProperty(_assertThisInitialized(_this), "ariaDescribedBy", "pf-about-modal-content-".concat(_this.id));

    _defineProperty(_assertThisInitialized(_this), "handleEscKeyClick", function (event) {
      if (event.keyCode === KEY_CODES.ESCAPE_KEY && _this.props.isOpen) {
        _this.props.onClose();
      }
    });

    if (props.brandImageSrc && !props.brandImageAlt) {
      // tslint:disable-next-line:no-console
      console.error('AboutModal:', 'brandImageAlt is required when a brandImageSrc is specified');
    }

    return _this;
  }

  _createClass(AboutModal, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (!this.container) {
        this.container = document.createElement('div');
        document.body.appendChild(this.container);
        document.addEventListener('keydown', this.handleEscKeyClick, false);
      }

      if (this.props.isOpen) {
        document.body.classList.add(css(styles.backdropOpen));
      } else {
        document.body.classList.remove(css(styles.backdropOpen));
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      if (this.props.isOpen) {
        document.body.classList.add(css(styles.backdropOpen));
      } else {
        document.body.classList.remove(css(styles.backdropOpen));
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.container) {
        document.body.removeChild(this.container);
      }

      document.removeEventListener('keydown', this.handleEscKeyClick, false);
    }
  }, {
    key: "render",
    value: function render() {
      if (!canUseDOM || !this.container) {
        return null;
      }

      return ReactDOM.createPortal(React.createElement(AboutModalContainer, _extends({
        ariaLabelledbyId: this.ariaLabelledBy,
        ariaDescribedById: this.ariaDescribedBy
      }, this.props)), this.container);
    }
  }]);

  return AboutModal;
}(React.Component);

_defineProperty(AboutModal, "propTypes", {
  children: _pt.node.isRequired,
  className: _pt.string,
  isOpen: _pt.bool,
  onClose: _pt.func,
  productName: _pt.string,
  trademark: _pt.string,
  brandImageSrc: _pt.string.isRequired,
  brandImageAlt: _pt.string.isRequired,
  backgroundImageSrc: _pt.string,
  noAboutModalBoxContentContainer: _pt.bool
});

_defineProperty(AboutModal, "currentId", 0);

_defineProperty(AboutModal, "defaultProps", {
  className: '',
  isOpen: false,
  onClose: function onClose() {
    return undefined;
  },
  productName: '',
  trademark: '',
  backgroundImageSrc: '',
  noAboutModalBoxContentContainer: false
});