"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModalContent = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var React = _interopRequireWildcard(require("react"));

var _bullseyeCss = _interopRequireDefault(require("../../@patternfly/patternfly/layouts/Bullseye/bullseye.css.js"));

var _reactStyles = require("@patternfly/react-styles");

var _Backdrop = _interopRequireDefault(require("../Backdrop/Backdrop"));

var _ModalBoxBody = require("./ModalBoxBody");

var _ModalBoxHeader = require("./ModalBoxHeader");

var _ModalBoxCloseButton = require("./ModalBoxCloseButton");

var _ModalBox = require("./ModalBox");

var _ModalBoxFooter = require("./ModalBoxFooter");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

// Can't use ES6 imports :(
// The types for it are also wrong, we should probably ditch this dependency.
var FocusTrap = require('focus-trap-react');

var ModalContent = function ModalContent(_ref) {
  var children = _ref.children,
      _ref$className = _ref.className,
      className = _ref$className === void 0 ? '' : _ref$className,
      _ref$isOpen = _ref.isOpen,
      isOpen = _ref$isOpen === void 0 ? false : _ref$isOpen,
      title = _ref.title,
      _ref$hideTitle = _ref.hideTitle,
      hideTitle = _ref$hideTitle === void 0 ? false : _ref$hideTitle,
      _ref$actions = _ref.actions,
      actions = _ref$actions === void 0 ? [] : _ref$actions,
      _ref$onClose = _ref.onClose,
      onClose = _ref$onClose === void 0 ? function () {
    return undefined;
  } : _ref$onClose,
      _ref$isLarge = _ref.isLarge,
      isLarge = _ref$isLarge === void 0 ? false : _ref$isLarge,
      _ref$isSmall = _ref.isSmall,
      isSmall = _ref$isSmall === void 0 ? false : _ref$isSmall,
      _ref$width = _ref.width,
      width = _ref$width === void 0 ? -1 : _ref$width,
      _ref$ariaDescribedByI = _ref.ariaDescribedById,
      ariaDescribedById = _ref$ariaDescribedByI === void 0 ? '' : _ref$ariaDescribedByI,
      _ref$id = _ref.id,
      id = _ref$id === void 0 ? '' : _ref$id,
      props = _objectWithoutProperties(_ref, ["children", "className", "isOpen", "title", "hideTitle", "actions", "onClose", "isLarge", "isSmall", "width", "ariaDescribedById", "id"]);

  var modalBoxHeader = React.createElement(_ModalBoxHeader.ModalBoxHeader, {
    hideTitle: hideTitle
  }, " ", title, " ");
  var modalBoxFooter = actions.length > 0 && React.createElement(_ModalBoxFooter.ModalBoxFooter, null, " ", actions, " ");

  if (!isOpen) {
    return null;
  }

  var boxStyle = width === -1 ? {} : {
    width: width
  };
  return React.createElement(_Backdrop["default"], null, React.createElement(FocusTrap, {
    focusTrapOptions: {
      clickOutsideDeactivates: true
    },
    className: (0, _reactStyles.css)(_bullseyeCss["default"].bullseye)
  }, React.createElement(_ModalBox.ModalBox, {
    style: boxStyle,
    className: className,
    isLarge: isLarge,
    isSmall: isSmall,
    title: title,
    id: ariaDescribedById || id
  }, React.createElement(_ModalBoxCloseButton.ModalBoxCloseButton, {
    onClose: onClose
  }), modalBoxHeader, React.createElement(_ModalBoxBody.ModalBoxBody, _extends({}, props, {
    id: id
  }), children), modalBoxFooter)));
};

exports.ModalContent = ModalContent;
ModalContent.propTypes = {
  children: _propTypes["default"].node.isRequired,
  className: _propTypes["default"].string,
  isLarge: _propTypes["default"].bool,
  isSmall: _propTypes["default"].bool,
  isOpen: _propTypes["default"].bool,
  title: _propTypes["default"].string.isRequired,
  hideTitle: _propTypes["default"].bool,
  width: _propTypes["default"].oneOfType([_propTypes["default"].number, _propTypes["default"].string]),
  actions: _propTypes["default"].any,
  onClose: _propTypes["default"].func,
  ariaDescribedById: _propTypes["default"].string,
  id: _propTypes["default"].string.isRequired
};