"use strict";

(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "react", "../../@patternfly/patternfly/components/Nav/nav.css.js", "../../@patternfly/patternfly/utilities/Accessibility/accessibility.css.js", "@patternfly/react-styles", "prop-types", "./NavToggle", "@patternfly/react-icons", "./Nav", "../../helpers/util"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("react"), require("../../@patternfly/patternfly/components/Nav/nav.css.js"), require("../../@patternfly/patternfly/utilities/Accessibility/accessibility.css.js"), require("@patternfly/react-styles"), require("prop-types"), require("./NavToggle"), require("@patternfly/react-icons"), require("./Nav"), require("../../helpers/util"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.react, global.navCss, global.accessibilityCss, global.reactStyles, global.propTypes, global.NavToggle, global.reactIcons, global.Nav, global.util);
    global.undefined = mod.exports;
  }
})(void 0, function (exports, _react, _navCss, _accessibilityCss, _reactStyles, _propTypes, _NavToggle, _reactIcons, _Nav, _util) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _react2 = _interopRequireDefault(_react);

  var _navCss2 = _interopRequireDefault(_navCss);

  var _accessibilityCss2 = _interopRequireDefault(_accessibilityCss);

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var _NavToggle2 = _interopRequireDefault(_NavToggle);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _typeof2(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof2 = function _typeof2(obj) {
        return typeof obj;
      };
    } else {
      _typeof2 = function _typeof2(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof2(obj);
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol") {
      _typeof = function _typeof(obj) {
        return _typeof2(obj);
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof2(obj);
      };
    }

    return _typeof(obj);
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized(self);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  var propTypes = {
    /** Title shown for the expandable list */
    title: _propTypes2["default"].string.isRequired,

    /** If defined, screen readers will read this text instead of the list title */
    srText: _propTypes2["default"].string,

    /** Boolean to programatically expand or collapse section */
    isExpanded: _propTypes2["default"].bool,

    /** Anything that can be rendered inside of the expandable list */
    children: _propTypes2["default"].node,

    /** Additional classes added to the container */
    className: _propTypes2["default"].string,

    /** Group identifier, will be returned with the onToggle and onSelect callback passed to the Nav component */
    groupId: _propTypes2["default"].oneOfType([_propTypes2["default"].string, _propTypes2["default"].number]),

    /** If true makes the expandable list title active */
    isActive: _propTypes2["default"].bool,

    /** Identifier to use for the section aria label */
    id: _propTypes2["default"].string,

    /** Additional props are spread to the container <li> */
    '': _propTypes2["default"].any,

    /** allow consumer to optionally override this callback and manage expand state externally */
    onExpand: _propTypes2["default"].func
  };
  var defaultProps = {
    srText: '',
    isExpanded: false,
    children: null,
    className: '',
    groupId: null,
    isActive: false,
    id: '',
    onExpand: undefined
  };

  var NavExpandable =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(NavExpandable, _React$Component);

    function NavExpandable() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, NavExpandable);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(NavExpandable)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "id", _this.props.id || (0, _util.getUniqueId)());

      _defineProperty(_assertThisInitialized(_this), "state", {
        expandedState: false
      });

      _defineProperty(_assertThisInitialized(_this), "onExpand", function (e, val) {
        if (_this.props.onExpand) {
          _this.props.onExpand(e, val);
        } else {
          _this.setState({
            expandedState: val
          });
        }
      });

      return _this;
    }

    _createClass(NavExpandable, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.setState({
          expandedState: this.props.isExpanded
        });
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        if (this.props.isExpanded !== prevProps.isExpanded) {
          this.setState({
            expandedState: this.props.isExpanded
          });
        }
      }
    }, {
      key: "render",
      value: function render() {
        var _this2 = this;

        var _this$props = this.props,
            id = _this$props.id,
            title = _this$props.title,
            srText = _this$props.srText,
            isExpanded = _this$props.isExpanded,
            children = _this$props.children,
            className = _this$props.className,
            groupId = _this$props.groupId,
            isActive = _this$props.isActive,
            onExpand = _this$props.onExpand,
            props = _objectWithoutProperties(_this$props, ["id", "title", "srText", "isExpanded", "children", "className", "groupId", "isActive", "onExpand"]);

        var expandedState = this.state.expandedState;
        return _react2["default"].createElement(_Nav.NavContext.Consumer, null, function (context) {
          return _react2["default"].createElement(_NavToggle2["default"], {
            groupId: groupId,
            onToggle: context.onToggle,
            onExpand: _this2.onExpand,
            isExpanded: expandedState
          }, function (_ref) {
            var toggleValue = _ref.toggleValue,
                toggle = _ref.toggle;
            return _react2["default"].createElement("li", _extends({
              className: (0, _reactStyles.css)(_navCss2["default"].navItem, toggleValue && _navCss2["default"].modifiers.expanded, isActive && _navCss2["default"].modifiers.current, className),
              onClick: toggle
            }, props), _react2["default"].createElement("a", {
              "data-component": "pf-nav-expandable",
              className: (0, _reactStyles.css)(_navCss2["default"].navLink),
              id: srText ? null : _this2.id,
              href: "#",
              onClick: function onClick(e) {
                return e.preventDefault();
              },
              onMouseDown: function onMouseDown(e) {
                return e.preventDefault();
              },
              "aria-expanded": toggleValue
            }, title, _react2["default"].createElement("span", {
              className: (0, _reactStyles.css)(_navCss2["default"].navToggle)
            }, _react2["default"].createElement(_reactIcons.AngleRightIcon, {
              "aria-hidden": "true"
            }))), _react2["default"].createElement("section", {
              className: (0, _reactStyles.css)(_navCss2["default"].navSubnav),
              "aria-labelledby": _this2.id,
              hidden: toggleValue ? null : true
            }, srText && _react2["default"].createElement("h2", {
              className: (0, _reactStyles.css)(_accessibilityCss2["default"].screenReader),
              id: _this2.id
            }, srText), _react2["default"].createElement("ul", {
              className: (0, _reactStyles.css)(_navCss2["default"].navSimpleList)
            }, children)));
          });
        });
      }
    }]);

    return NavExpandable;
  }(_react2["default"].Component);

  NavExpandable.propTypes = propTypes;
  NavExpandable.defaultProps = defaultProps;
  NavExpandable.componentType = 'NavExpandable';
  exports["default"] = NavExpandable;
});