"use strict";

(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "react", "@patternfly/react-core"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("react"), require("@patternfly/react-core"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.react, global.reactCore);
    global.undefined = mod.exports;
  }
})(void 0, function (exports, _react, _reactCore) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _react2 = _interopRequireDefault(_react);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _typeof2(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof2 = function _typeof2(obj) {
        return typeof obj;
      };
    } else {
      _typeof2 = function _typeof2(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof2(obj);
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol") {
      _typeof = function _typeof(obj) {
        return _typeof2(obj);
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof2(obj);
      };
    }

    return _typeof(obj);
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }

      return arr2;
    }
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized(self);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  var CheckboxSelectInput =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(CheckboxSelectInput, _React$Component);

    function CheckboxSelectInput() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, CheckboxSelectInput);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(CheckboxSelectInput)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "state", {
        isExpanded: false,
        selected: []
      });

      _defineProperty(_assertThisInitialized(_this), "onToggle", function (isExpanded) {
        _this.setState({
          isExpanded: isExpanded
        });
      });

      _defineProperty(_assertThisInitialized(_this), "onSelect", function (event, selection) {
        var selected = _this.state.selected;

        if (selected.includes(selection)) {
          _this.setState(function (prevState) {
            return {
              selected: prevState.selected.filter(function (item) {
                return item !== selection;
              })
            };
          }, function () {
            return console.log('selections: ', _this.state.selected);
          });
        } else {
          _this.setState(function (prevState) {
            return {
              selected: [].concat(_toConsumableArray(prevState.selected), [selection])
            };
          }, function () {
            return console.log('selections: ', _this.state.selected);
          });
        }
      });

      _defineProperty(_assertThisInitialized(_this), "clearSelection", function () {
        _this.setState({
          selected: []
        });
      });

      _defineProperty(_assertThisInitialized(_this), "options", [_react2["default"].createElement(_reactCore.CheckboxSelectOption, {
        key: 0,
        value: "Active"
      }), _react2["default"].createElement(_reactCore.CheckboxSelectOption, {
        key: 1,
        value: "Cancelled"
      }), _react2["default"].createElement(_reactCore.CheckboxSelectOption, {
        key: 2,
        value: "Paused"
      }), _react2["default"].createElement(_reactCore.CheckboxSelectOption, {
        key: 3,
        value: "Warning"
      }), _react2["default"].createElement(_reactCore.CheckboxSelectOption, {
        key: 4,
        value: "Restarted"
      })]);

      return _this;
    }

    _createClass(CheckboxSelectInput, [{
      key: "render",
      value: function render() {
        var _this$state = this.state,
            isExpanded = _this$state.isExpanded,
            selected = _this$state.selected;
        var titleId = 'checkbox-select-id';
        return _react2["default"].createElement("div", null, _react2["default"].createElement("span", {
          id: titleId,
          hidden: true
        }, "Checkbox Title"), _react2["default"].createElement(_reactCore.Select, {
          variant: _reactCore.SelectVariant.checkbox,
          "aria-label": "Select Input",
          onToggle: this.onToggle,
          onSelect: this.onSelect,
          selections: selected,
          isExpanded: isExpanded,
          placeholderText: "Filter by status",
          ariaLabelledBy: titleId
        }, this.options));
      }
    }]);

    return CheckboxSelectInput;
  }(_react2["default"].Component);

  exports["default"] = CheckboxSelectInput;
});