var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { CSSStyleDeclaration } from 'cssstyle';
import camelcase from 'camel-case';

var properties = ['grid', 'grid-area', 'grid-auto-columns', 'grid-auto-flow', 'grid-auto-rows', 'grid-column', 'grid-column-end', 'grid-column-gap', 'grid-column-start', 'grid-gap', 'grid-row', 'grid-row-end', 'grid-row-gap', 'grid-row-start', 'grid-template', 'grid-template-areas', 'grid-template-columns', 'grid-template-rows'];

function createOverride(key) {
  return {
    set: function set(v) {
      this._setProperty(key, v);
    },
    get: function get() {
      return this.getPropertyValue(key);
    },

    enumerable: true,
    configurable: true
  };
}

export function addOverrides() {
  var overrides = properties.reduce(function (acc, property) {
    var _extends2;

    return _extends({}, acc, (_extends2 = {}, _defineProperty(_extends2, property, createOverride(property)), _defineProperty(_extends2, camelcase(property), createOverride(property)), _extends2));
  }, {});
  Object.defineProperties(CSSStyleDeclaration.prototype, overrides);
}