import path from 'path';
import { readFileSync } from 'fs';
import css from 'css';
import { outputFileSync, copyFileSync, ensureDir } from 'fs-extra';
import relative from 'relative';

export var packageName = '@patternfly/react-styles';
export var styleSheetToken = 'StyleSheet';

export function cssToJS(cssString) {
  var cssOutputPath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  var useModules = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

  var cssRequire = '';
  var cssImport = '';
  if (cssOutputPath) {
    cssRequire = 'require(\'' + cssOutputPath + '\');';
    cssImport = 'import \'' + cssOutputPath + '\';';
  }
  if (useModules) {
    return 'import { ' + styleSheetToken + ' } from \'' + packageName + '\';\n' + cssImport + '\n\nexport default ' + styleSheetToken + '.parse(`' + cssString + '`);\n';
  }

  return 'const { ' + styleSheetToken + ' } = require(\'' + packageName + '\');\n' + cssRequire + '\n\nmodule.exports = ' + styleSheetToken + '.parse(`' + cssString + '`);\n';
}

export function getFullCSS(pathToCSSFile) {
  var rawCss = readFileSync(pathToCSSFile, 'utf8').replace('@charset "UTF-8";', '');
  return rawCss;
}

export function getCSS(pathToCSSFile) {
  var rawCss = readFileSync(pathToCSSFile, 'utf8').replace('@charset "UTF-8";', '');
  return minifyCSS(rawCss);
}

export function minifyCSS(cssString) {
  return css.stringify(css.parse(cssString.replace('@charset "UTF-8";', '')), {
    compress: true
  });
}

export function writeCSSFile(destinationPath, contents) {
  ensureDir(path.dirname(destinationPath)).then(function () {
    var replacementString = contents.replace(/..\/..\/assets/g, '../../../../../styles/assets');
    outputFileSync(destinationPath, replacementString);
  });
}

export function writeCSSJSFile(rootPath, originalPath, destinationPath, contents) {
  outputFileSync(destinationPath, contents);
  var removeRE = new RegExp(rootPath + '/?');
  var inFormatted = originalPath.replace(removeRE, '');
  var outFormatted = destinationPath.replace(removeRE, '');
}

export function getRelativeImportPath(from, to) {
  var parsedTo = path.parse(to);
  var newImportPath = path.normalize(path.join(relative(from, parsedTo.dir), parsedTo.base));
  return newImportPath.startsWith('.') ? newImportPath : './' + newImportPath;
}

export function getCSSOutputPath(outDir, rootPath, pathToCSSFile) {
  return path.join(path.resolve(rootPath, outDir), getFormattedCSSOutputPath(pathToCSSFile));
}

function getFormattedCSSOutputPath(pathToCSSFile) {
  var _path$parse = path.parse(pathToCSSFile),
      dir = _path$parse.dir,
      name = _path$parse.name;

  var formattedDir = dir;
  var nodeText = 'node_modules';
  var nodeIndex = formattedDir.lastIndexOf(nodeText);
  if (nodeIndex !== -1) {
    formattedDir = formattedDir.substring(nodeIndex + nodeText.length);
  }
  return path.join(formattedDir, name + '.css');
}