(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(['exports', 'emotion', './utils'], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require('emotion'), require('./utils'));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.emotion, global.utils);
    global.StyleSheet = mod.exports;
  }
})(this, function (exports, _emotion, _utils) {
  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.StyleSheet = undefined;
  exports.css = css;
  var _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }return target;
  };

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var StyleSheet = exports.StyleSheet = {
    create: function create(styleObj) {
      var keys = Object.keys(styleObj);
      if (keys.length > 0) {
        return keys.reduce(function (prev, key) {
          return _extends({}, prev, _defineProperty({}, key, (0, _emotion.css)(styleObj[key])));
        }, {});
      }
      return (0, _emotion.css)(styleObj);
    },
    parse: function parse(input) {
      var classes = (0, _utils.getCSSClasses)(input);
      if (!classes) {
        return {};
      }

      return classes.reduce(function (map, className) {
        var key = (0, _utils.formatClassName)(className);
        if (map[key]) {
          return map;
        }

        var value = (0, _utils.createStyleDeclaration)(className, input);

        if ((0, _utils.isModifier)(className)) {
          map.modifiers[key] = value;
        } else {
          map[key] = value;
        }

        return map;
      }, {
        modifiers: {},
        inject: function inject() {
          return (0, _emotion.injectGlobal)(input);
        },
        raw: input
      });
    }
  };

  function css() {
    var filteredStyles = [];

    for (var _len = arguments.length, styles = Array(_len), _key = 0; _key < _len; _key++) {
      styles[_key] = arguments[_key];
    }

    styles.forEach(function (style) {
      if ((0, _utils.isValidStyleDeclaration)(style)) {
        // remove global injection of styles in favor of require(css) in the component
        // style.__inject();
        filteredStyles.push((0, _utils.getClassName)(style));
        return;
      }
      filteredStyles.push(style);
    });

    return _emotion.cx.apply(undefined, filteredStyles);
  }
});