(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(['exports', '@babel/helper-plugin-utils', 'path', 'resolve-from', '../util', '../../StyleSheet'], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require('@babel/helper-plugin-utils'), require('path'), require('resolve-from'), require('../util'), require('../../StyleSheet'));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.helperPluginUtils, global.path, global.resolveFrom, global.util, global.StyleSheet);
    global.plugin = mod.exports;
  }
})(this, function (exports, _helperPluginUtils, _path, _resolveFrom, _util, _StyleSheet) {
  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _resolveFrom2 = _interopRequireDefault(_resolveFrom);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  var _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }return target;
  };

  /* eslint-disable no-case-declarations */


  var defaultOptions = {
    extensions: ['.css'],
    srcDir: './src',
    useModules: false
  };

  exports.default = (0, _helperPluginUtils.declare)(function (_ref) {
    var t = _ref.types;

    var outputFiles = new Set();

    function getVariableName(path) {
      if (path.node.specifiers && path.node.specifiers[0] && path.node.specifiers[0].local) {
        return path.node.specifiers[0].local.name;
      }
      return null;
    }

    function getLastImportIndex(path) {
      var lastImportIndex = 0;
      path.container.forEach(function (p, i) {
        if (t.isImportDeclaration(p)) {
          lastImportIndex = i;
        }
      });
      return lastImportIndex;
    }

    function getPackageImportIndex(path) {
      return path.container.findIndex(function (p) {
        return t.isImportDeclaration(p) && p.source.value === _util.packageName;
      });
    }

    function createStyleSheetImport(path) {
      return t.importDeclaration([t.importSpecifier(t.identifier('__PF__' + _util.styleSheetToken), t.identifier(_util.styleSheetToken))], t.stringLiteral(_util.packageName));
    }

    function validateReferences(referencePaths, styleObject) {
      var nestedProperties = {
        modifier: 'modifiers'
      };
      referencePaths.forEach(function (rp) {
        if (!t.isMemberExpression(rp.parentPath.node)) {
          return;
        }
        var propName = rp.parentPath.node.property.name;
        if (Object.values(nestedProperties).includes(propName)) {
          var nestedNode = rp.parentPath.parentPath.node;
          if (!t.isMemberExpression(nestedNode)) {
            return;
          }
          var nestedPropertyName = nestedNode.property.name;
          if (!styleObject[propName][nestedPropertyName]) {
            throw rp.buildCodeFrameError(nestedPropertyName + ' is not a valid ' + (propName === nestedProperties.modifier ? 'modifier' : 'property'));
          }
        } else if (!styleObject[propName]) {
          throw rp.buildCodeFrameError(propName + ' does not exist');
        }
      });
    }

    return {
      visitor: {
        ImportDeclaration: function ImportDeclaration(path, _ref2) {
          var file = _ref2.file,
              _ref2$opts = _ref2.opts,
              opts = _ref2$opts === undefined ? {} : _ref2$opts;

          var options = _extends({}, defaultOptions, opts);
          var value = path.node.source.value;

          var ext = (0, _path.extname)(value);
          if (options.extensions.includes(ext) && getVariableName(path)) {
            var rootPath = file.opts.sourceRoot || process.cwd();
            var scriptDirectory = (0, _path.dirname)((0, _path.resolve)(file.opts.filename));
            var cssfilePath = (0, _resolveFrom2.default)(scriptDirectory, value);
            var cssString = (0, _util.getCSS)(cssfilePath);
            var fullCssString = (0, _util.getFullCSS)(cssfilePath);
            var varName = getVariableName(path);
            var bindings = path.scope.bindings;

            var styleObject = _StyleSheet.StyleSheet.parse(cssString);

            validateReferences(bindings[varName].referencePaths, styleObject);

            if (!options.outDir) {
              var lastImportIndex = getLastImportIndex(path);
              var pfStylesImportIndex = getPackageImportIndex(path);

              if (pfStylesImportIndex === -1) {
                path.getSibling(lastImportIndex).insertAfter(createStyleSheetImport());
                lastImportIndex++;
                pfStylesImportIndex = lastImportIndex;
              }

              var pfStylesImportPath = path.getSibling(pfStylesImportIndex);
              var styleSheetSpecifier = pfStylesImportPath.node.specifiers.find(function (s) {
                return t.isImportSpecifier(s) && s.imported.name === _util.styleSheetToken;
              });
              if (!styleSheetSpecifier) {
                styleSheetSpecifier = t.importSpecifier(t.identifier('__PF__' + _util.styleSheetToken), t.identifier(_util.styleSheetToken));
                pfStylesImportPath.node.specifiers.push(styleSheetSpecifier);
              }
              var varDeclaration = t.variableDeclaration('const', [t.variableDeclarator(t.identifier(varName), t.callExpression(t.memberExpression(t.identifier(styleSheetSpecifier.local.name), t.identifier('parse')), [t.stringLiteral(cssString)]))]);
              path.getSibling(lastImportIndex).insertAfter(varDeclaration);
              path.remove();
            } else {
              var srcDir = options.srcDir,
                  outDir = options.outDir;

              var cssOutputPath = (0, _util.getCSSOutputPath)(outDir, rootPath, cssfilePath);
              var cssJsOutputPath = cssOutputPath + '.js';
              var cssFileName = './' + (0, _path.basename)(cssfilePath);
              var scriptOutputPath = (0, _path.resolve)(file.opts.filename).replace((0, _path.resolve)(srcDir), outDir);

              if (!outputFiles.has(cssOutputPath)) {
                (0, _util.writeCSSFile)(cssOutputPath, fullCssString);
                (0, _util.writeCSSJSFile)(rootPath, cssfilePath, cssJsOutputPath, (0, _util.cssToJS)(cssString, cssFileName, options.useModules));
                outputFiles.add(cssOutputPath);
              }
              path.node.source.value = (0, _util.getRelativeImportPath)(scriptOutputPath, cssJsOutputPath);
            }
          }
        }
      }
    };
  });
});