(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports);
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports);
    global.reactUtils = mod.exports;
  }
})(this, function (exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _typeof2 = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
  };

  var _typeof = typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol" ? function (obj) {
    return typeof obj === "undefined" ? "undefined" : _typeof2(obj);
  } : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof2(obj);
  };

  function getNodes(node) {
    var nodes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

    if (node.children) {
      var children = typeof node.children === 'function' ? node.children() : node.children;

      children.forEach(function (child) {
        return getNodes(child, nodes);
      });
    }

    if ((typeof node === 'undefined' ? 'undefined' : _typeof(node)) === 'object') {
      nodes.push(node);
    }

    return nodes;
  }

  exports.getNodes = getNodes;
});