(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(['exports', 'path', 'fs', 'css', 'fs-extra', 'relative'], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require('path'), require('fs'), require('css'), require('fs-extra'), require('relative'));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.path, global.fs, global.css, global.fsExtra, global.relative);
    global.util = mod.exports;
  }
})(this, function (exports, _path, _fs, _css, _fsExtra, _relative) {
  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.styleSheetToken = exports.packageName = undefined;
  exports.cssToJS = cssToJS;
  exports.getFullCSS = getFullCSS;
  exports.getCSS = getCSS;
  exports.minifyCSS = minifyCSS;
  exports.writeCSSFile = writeCSSFile;
  exports.writeCSSJSFile = writeCSSJSFile;
  exports.getRelativeImportPath = getRelativeImportPath;
  exports.getCSSOutputPath = getCSSOutputPath;

  var _path2 = _interopRequireDefault(_path);

  var _css2 = _interopRequireDefault(_css);

  var _relative2 = _interopRequireDefault(_relative);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  var packageName = exports.packageName = '@patternfly/react-styles';
  var styleSheetToken = exports.styleSheetToken = 'StyleSheet';

  function cssToJS(cssString) {
    var cssOutputPath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
    var useModules = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

    var cssRequire = '';
    var cssImport = '';
    if (cssOutputPath) {
      cssRequire = 'require(\'' + cssOutputPath + '\');';
      cssImport = 'import \'' + cssOutputPath + '\';';
    }
    if (useModules) {
      return 'import { ' + styleSheetToken + ' } from \'' + packageName + '\';\n' + cssImport + '\n\nexport default ' + styleSheetToken + '.parse(`' + cssString + '`);\n';
    }

    return 'const { ' + styleSheetToken + ' } = require(\'' + packageName + '\');\n' + cssRequire + '\n\nmodule.exports = ' + styleSheetToken + '.parse(`' + cssString + '`);\n';
  }

  function getFullCSS(pathToCSSFile) {
    var rawCss = (0, _fs.readFileSync)(pathToCSSFile, 'utf8').replace('@charset "UTF-8";', '');
    return rawCss;
  }

  function getCSS(pathToCSSFile) {
    var rawCss = (0, _fs.readFileSync)(pathToCSSFile, 'utf8').replace('@charset "UTF-8";', '');
    return minifyCSS(rawCss);
  }

  function minifyCSS(cssString) {
    return _css2.default.stringify(_css2.default.parse(cssString.replace('@charset "UTF-8";', '')), {
      compress: true
    });
  }

  function writeCSSFile(destinationPath, contents) {
    (0, _fsExtra.ensureDir)(_path2.default.dirname(destinationPath)).then(function () {
      var replacementString = contents.replace(/..\/..\/assets/g, '../../../../../styles/assets');
      (0, _fsExtra.outputFileSync)(destinationPath, replacementString);
    });
  }

  function writeCSSJSFile(rootPath, originalPath, destinationPath, contents) {
    (0, _fsExtra.outputFileSync)(destinationPath, contents);
    var removeRE = new RegExp(rootPath + '/?');
    var inFormatted = originalPath.replace(removeRE, '');
    var outFormatted = destinationPath.replace(removeRE, '');
  }

  function getRelativeImportPath(from, to) {
    var parsedTo = _path2.default.parse(to);
    var newImportPath = _path2.default.normalize(_path2.default.join((0, _relative2.default)(from, parsedTo.dir), parsedTo.base));
    return newImportPath.startsWith('.') ? newImportPath : './' + newImportPath;
  }

  function getCSSOutputPath(outDir, rootPath, pathToCSSFile) {
    return _path2.default.join(_path2.default.resolve(rootPath, outDir), getFormattedCSSOutputPath(pathToCSSFile));
  }

  function getFormattedCSSOutputPath(pathToCSSFile) {
    var _path$parse = _path2.default.parse(pathToCSSFile),
        dir = _path$parse.dir,
        name = _path$parse.name;

    var formattedDir = dir;
    var nodeText = 'node_modules';
    var nodeIndex = formattedDir.lastIndexOf(nodeText);
    if (nodeIndex !== -1) {
      formattedDir = formattedDir.substring(nodeIndex + nodeText.length);
    }
    return _path2.default.join(formattedDir, name + '.css');
  }
});