(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(['exports', 'camel-case', 'emotion'], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require('camel-case'), require('emotion'));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.camelCase, global.emotion);
    global.utils = mod.exports;
  }
})(this, function (exports, _camelCase, _emotion) {
  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.isValidStyleDeclaration = isValidStyleDeclaration;
  exports.createStyleDeclaration = createStyleDeclaration;
  exports.isModifier = isModifier;
  exports.getModifier = getModifier;
  exports.formatClassName = formatClassName;
  exports.getCSSClasses = getCSSClasses;
  exports.getClassName = getClassName;
  exports.getInsertedStyles = getInsertedStyles;

  var _camelCase2 = _interopRequireDefault(_camelCase);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function isValidStyleDeclaration(styleObj) {
    return Boolean(styleObj) && typeof styleObj.__className === 'string' && typeof styleObj.__inject === 'function';
  }

  function createStyleDeclaration(className, rawCss) {
    return {
      __className: className.replace('.', '').trim(),
      __inject: function __inject() {
        (0, _emotion.injectGlobal)(rawCss);
      }
    };
  }

  function isModifier(className) {
    return Boolean(className && className.startsWith) && className.startsWith('.pf-m-');
  }

  function getModifier(styleObj, modifier, defaultModifier) {
    if (!styleObj) {
      return null;
    }

    var modifiers = styleObj.modifiers || styleObj;
    return modifiers[modifier] || modifiers[(0, _camelCase2.default)(modifier)] || defaultModifier;
  }

  function formatClassName(className) {
    return (0, _camelCase2.default)(className.replace(/pf-((c|l|m|u|is|has)-)?/g, ''));
  }

  function getCSSClasses(cssString) {
    return cssString.match(/(\.)(?!\d)([^\s\.,{\[>+~#:)]*)(?![^{]*})/g); //eslint-disable-line
  }

  function getClassName() {
    var styleObj = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    if (typeof styleObj === 'string') {
      return styleObj;
    }

    return isValidStyleDeclaration(styleObj) ? styleObj.__className : '';
  }

  function getInsertedStyles() {
    return Object.values(_emotion.caches.inserted);
  }
});