var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import React from 'react';
import { getSize, propTypes, defaultProps } from './common';

var currentId = 0;

var createIcon = function createIcon(iconDefinition) {
  var viewBox = [iconDefinition.xOffset || 0, iconDefinition.yOffset || 0, iconDefinition.width, iconDefinition.height].join(' ');
  var transform = iconDefinition.transform;

  var Icon = function (_React$Component) {
    _inherits(Icon, _React$Component);

    function Icon() {
      var _ref;

      var _temp, _this, _ret;

      _classCallCheck(this, Icon);

      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Icon.__proto__ || Object.getPrototypeOf(Icon)).call.apply(_ref, [this].concat(args))), _this), _this.id = 'icon-title-' + currentId++, _temp), _possibleConstructorReturn(_this, _ret);
    }

    _createClass(Icon, [{
      key: 'render',
      value: function render() {
        var _props = this.props,
            size = _props.size,
            color = _props.color,
            title = _props.title,
            noStyle = _props.noStyle,
            noVerticalAlign = _props.noVerticalAlign,
            props = _objectWithoutProperties(_props, ['size', 'color', 'title', 'noStyle', 'noVerticalAlign']);

        var hasTitle = Boolean(title);
        var heightWidth = getSize(size);
        var baseAlign = -.125 * Number.parseFloat(heightWidth);
        var style = noVerticalAlign ? null : { verticalAlign: baseAlign + 'em' };

        return React.createElement(
          'svg',
          _extends({
            style: style,
            fill: color,
            height: heightWidth,
            width: heightWidth,
            viewBox: viewBox,
            'aria-labelledby': hasTitle ? this.id : null,
            'aria-hidden': hasTitle ? null : true,
            role: 'img'
          }, props),
          hasTitle && React.createElement(
            'title',
            { id: this.id },
            title
          ),
          React.createElement('path', { d: iconDefinition.svgPath, transform: transform })
        );
      }
    }]);

    return Icon;
  }(React.Component);

  Icon.displayName = iconDefinition.name;
  Icon.propTypes = propTypes;
  Icon.defaultProps = defaultProps;


  return Icon;
};

export default createIcon;