'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _object = require('object.assign');

var _object2 = _interopRequireDefault(_object);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _server = require('react-dom/server');

var _server2 = _interopRequireDefault(_server);

var _shallow = require('react-test-renderer/shallow');

var _shallow2 = _interopRequireDefault(_shallow);

var _package = require('react-test-renderer/package.json');

var _testUtils = require('react-dom/test-utils');

var _testUtils2 = _interopRequireDefault(_testUtils);

var _semver = require('semver');

var _semver2 = _interopRequireDefault(_semver);

var _checkPropTypes2 = require('prop-types/checkPropTypes');

var _checkPropTypes3 = _interopRequireDefault(_checkPropTypes2);

var _has = require('has');

var _has2 = _interopRequireDefault(_has);

var _reactIs = require('react-is');

var _enzyme = require('enzyme');

var _Utils = require('enzyme/build/Utils');

var _enzymeAdapterUtils = require('enzyme-adapter-utils');

var _findCurrentFiberUsingSlowPath = require('./findCurrentFiberUsingSlowPath');

var _findCurrentFiberUsingSlowPath2 = _interopRequireDefault(_findCurrentFiberUsingSlowPath);

var _detectFiberTags = require('./detectFiberTags');

var _detectFiberTags2 = _interopRequireDefault(_detectFiberTags);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* eslint no-use-before-define: 0 */

// eslint-disable-next-line import/no-unresolved

// eslint-disable-next-line import/no-unresolved

// eslint-disable-next-line import/no-unresolved


var is164 = !!_testUtils2['default'].Simulate.touchStart; // 16.4+
var is165 = !!_testUtils2['default'].Simulate.auxClick; // 16.5+
var is166 = is165 && !_react2['default'].unstable_AsyncMode; // 16.6+
var is168 = is166 && typeof _testUtils2['default'].act === 'function';

var hasShouldComponentUpdateBug = _semver2['default'].satisfies(_package.version, '< 16.8');

// Lazily populated if DOM is available.
var FiberTags = null;

function nodeAndSiblingsArray(nodeWithSibling) {
  var array = [];
  var node = nodeWithSibling;
  while (node != null) {
    array.push(node);
    node = node.sibling;
  }
  return array;
}

function flatten(arr) {
  var result = [];
  var stack = [{ i: 0, array: arr }];
  while (stack.length) {
    var n = stack.pop();
    while (n.i < n.array.length) {
      var el = n.array[n.i];
      n.i += 1;
      if (Array.isArray(el)) {
        stack.push(n);
        stack.push({ i: 0, array: el });
        break;
      }
      result.push(el);
    }
  }
  return result;
}

function nodeTypeFromType(type) {
  if (type === _reactIs.Portal) {
    return 'portal';
  }

  return (0, _enzymeAdapterUtils.nodeTypeFromType)(type);
}

function elementToTree(el) {
  if (!(0, _reactIs.isPortal)(el)) {
    return (0, _enzymeAdapterUtils.elementToTree)(el, elementToTree);
  }

  var children = el.children,
      containerInfo = el.containerInfo;

  var props = { children: children, containerInfo: containerInfo };

  return {
    nodeType: 'portal',
    type: _reactIs.Portal,
    props: props,
    key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(el.key),
    ref: el.ref || null,
    instance: null,
    rendered: elementToTree(el.children)
  };
}

function _toTree(vnode) {
  if (vnode == null) {
    return null;
  }
  // TODO(lmr): I'm not really sure I understand whether or not this is what
  // i should be doing, or if this is a hack for something i'm doing wrong
  // somewhere else. Should talk to sebastian about this perhaps
  var node = (0, _findCurrentFiberUsingSlowPath2['default'])(vnode);
  switch (node.tag) {
    case FiberTags.HostRoot:
      return childrenToTree(node.child);
    case FiberTags.HostPortal:
      {
        var containerInfo = node.stateNode.containerInfo,
            children = node.memoizedProps;

        var props = { containerInfo: containerInfo, children: children };
        return {
          nodeType: 'portal',
          type: _reactIs.Portal,
          props: props,
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: null,
          rendered: childrenToTree(node.child)
        };
      }
    case FiberTags.ClassComponent:
      return {
        nodeType: 'class',
        type: node.type,
        props: (0, _object2['default'])({}, node.memoizedProps),
        key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
        ref: node.ref,
        instance: node.stateNode,
        rendered: childrenToTree(node.child)
      };
    case FiberTags.FunctionalComponent:
      return {
        nodeType: 'function',
        type: node.type,
        props: (0, _object2['default'])({}, node.memoizedProps),
        key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
        ref: node.ref,
        instance: null,
        rendered: childrenToTree(node.child)
      };
    case FiberTags.MemoClass:
      return {
        nodeType: 'class',
        type: node.elementType.type,
        props: (0, _object2['default'])({}, node.memoizedProps),
        key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
        ref: node.ref,
        instance: node.stateNode,
        rendered: childrenToTree(node.child.child)
      };
    case FiberTags.MemoSFC:
      {
        var renderedNodes = flatten(nodeAndSiblingsArray(node.child).map(_toTree));
        if (renderedNodes.length === 0) {
          renderedNodes = [node.memoizedProps.children];
        }
        return {
          nodeType: 'function',
          type: node.elementType,
          props: (0, _object2['default'])({}, node.memoizedProps),
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: null,
          rendered: renderedNodes
        };
      }
    case FiberTags.HostComponent:
      {
        var _renderedNodes = flatten(nodeAndSiblingsArray(node.child).map(_toTree));
        if (_renderedNodes.length === 0) {
          _renderedNodes = [node.memoizedProps.children];
        }
        return {
          nodeType: 'host',
          type: node.type,
          props: (0, _object2['default'])({}, node.memoizedProps),
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: node.stateNode,
          rendered: _renderedNodes
        };
      }
    case FiberTags.HostText:
      return node.memoizedProps;
    case FiberTags.Fragment:
    case FiberTags.Mode:
    case FiberTags.ContextProvider:
    case FiberTags.ContextConsumer:
      return childrenToTree(node.child);
    case FiberTags.Profiler:
    case FiberTags.ForwardRef:
      {
        return {
          nodeType: 'function',
          type: node.type,
          props: (0, _object2['default'])({}, node.pendingProps),
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: null,
          rendered: childrenToTree(node.child)
        };
      }
    case FiberTags.Suspense:
      {
        return {
          nodeType: 'function',
          type: _reactIs.Suspense,
          props: (0, _object2['default'])({}, node.memoizedProps),
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: null,
          rendered: childrenToTree(node.child)
        };
      }
    case FiberTags.Lazy:
      return childrenToTree(node.child);
    default:
      throw new Error('Enzyme Internal Error: unknown node with tag ' + String(node.tag));
  }
}

function childrenToTree(node) {
  if (!node) {
    return null;
  }
  var children = nodeAndSiblingsArray(node);
  if (children.length === 0) {
    return null;
  }
  if (children.length === 1) {
    return _toTree(children[0]);
  }
  return flatten(children.map(_toTree));
}

function _nodeToHostNode(_node) {
  // NOTE(lmr): node could be a function component
  // which wont have an instance prop, but we can get the
  // host node associated with its return value at that point.
  // Although this breaks down if the return value is an array,
  // as is possible with React 16.
  var node = _node;
  while (node && !Array.isArray(node) && node.instance === null) {
    node = node.rendered;
  }
  // if the SFC returned null effectively, there is no host node.
  if (!node) {
    return null;
  }

  var mapper = function mapper(item) {
    if (item && item.instance) return _reactDom2['default'].findDOMNode(item.instance);
    return null;
  };
  if (Array.isArray(node)) {
    return node.map(mapper);
  }
  if (Array.isArray(node.rendered) && node.nodeType === 'class') {
    return node.rendered.map(mapper);
  }
  return mapper(node);
}

function replaceLazyWithFallback(node, fallback) {
  if (!node) {
    return null;
  }
  if (Array.isArray(node)) {
    return node.map(function (el) {
      return replaceLazyWithFallback(el, fallback);
    });
  }
  if ((0, _reactIs.isLazy)(node.type)) {
    return fallback;
  }
  return (0, _object2['default'])({}, node, {
    props: (0, _object2['default'])({}, node.props, {
      children: replaceLazyWithFallback(node.props.children, fallback)
    })
  });
}

var eventOptions = {
  animation: true,
  pointerEvents: is164,
  auxClick: is165
};

function getEmptyStateValue() {
  // this handles a bug in React 16.0 - 16.2
  // see https://github.com/facebook/react/commit/39be83565c65f9c522150e52375167568a2a1459
  // also see https://github.com/facebook/react/pull/11965

  // eslint-disable-next-line react/prefer-stateless-function
  var EmptyState = function (_React$Component) {
    _inherits(EmptyState, _React$Component);

    function EmptyState() {
      _classCallCheck(this, EmptyState);

      return _possibleConstructorReturn(this, (EmptyState.__proto__ || Object.getPrototypeOf(EmptyState)).apply(this, arguments));
    }

    _createClass(EmptyState, [{
      key: 'render',
      value: function () {
        function render() {
          return null;
        }

        return render;
      }()
    }]);

    return EmptyState;
  }(_react2['default'].Component);

  var testRenderer = new _shallow2['default']();
  testRenderer.render(_react2['default'].createElement(EmptyState));
  return testRenderer._instance.state;
}

function wrapAct(fn) {
  if (!is168) {
    return fn();
  }
  var returnVal = void 0;
  _testUtils2['default'].act(function () {
    returnVal = fn();
  });
  return returnVal;
}

function getProviderDefaultValue(Provider) {
  // React stores references to the Provider's defaultValue differently across versions.
  if ('_defaultValue' in Provider._context) {
    return Provider._context._defaultValue;
  }
  if ('_currentValue' in Provider._context) {
    return Provider._context._currentValue;
  }
  throw new Error('Enzyme Internal Error: can’t figure out how to get Provider’s default value');
}

function makeFakeElement(type) {
  return { $$typeof: _reactIs.Element, type: type };
}

function isStateful(Component) {
  return Component.prototype && (Component.prototype.isReactComponent || Array.isArray(Component.__reactAutoBindPairs) // fallback for createClass components
  );
}

var ReactSixteenAdapter = function (_EnzymeAdapter) {
  _inherits(ReactSixteenAdapter, _EnzymeAdapter);

  function ReactSixteenAdapter() {
    _classCallCheck(this, ReactSixteenAdapter);

    var _this2 = _possibleConstructorReturn(this, (ReactSixteenAdapter.__proto__ || Object.getPrototypeOf(ReactSixteenAdapter)).call(this));

    var lifecycles = _this2.options.lifecycles;

    _this2.options = (0, _object2['default'])({}, _this2.options, {
      enableComponentDidUpdateOnSetState: true, // TODO: remove, semver-major
      legacyContextMode: 'parent',
      lifecycles: (0, _object2['default'])({}, lifecycles, {
        componentDidUpdate: {
          onSetState: true
        },
        getDerivedStateFromProps: {
          hasShouldComponentUpdateBug: hasShouldComponentUpdateBug
        },
        getSnapshotBeforeUpdate: true,
        setState: {
          skipsComponentDidUpdateOnNullish: true
        },
        getChildContext: {
          calledByRenderer: false
        },
        getDerivedStateFromError: is166
      })
    });
    return _this2;
  }

  _createClass(ReactSixteenAdapter, [{
    key: 'createMountRenderer',
    value: function () {
      function createMountRenderer(options) {
        (0, _enzymeAdapterUtils.assertDomAvailable)('mount');
        if ((0, _has2['default'])(options, 'suspenseFallback')) {
          throw new TypeError('`suspenseFallback` is not supported by the `mount` renderer');
        }
        if (FiberTags === null) {
          // Requires DOM.
          FiberTags = (0, _detectFiberTags2['default'])();
        }
        var attachTo = options.attachTo,
            hydrateIn = options.hydrateIn,
            wrappingComponentProps = options.wrappingComponentProps;

        var domNode = hydrateIn || attachTo || global.document.createElement('div');
        var instance = null;
        var adapter = this;
        return {
          render: function () {
            function render(el, context, callback) {
              return wrapAct(function () {
                if (instance === null) {
                  var type = el.type,
                      props = el.props,
                      ref = el.ref;

                  var wrapperProps = (0, _object2['default'])({
                    Component: type,
                    props: props,
                    wrappingComponentProps: wrappingComponentProps,
                    context: context
                  }, ref && { ref: ref });
                  var ReactWrapperComponent = (0, _enzymeAdapterUtils.createMountWrapper)(el, (0, _object2['default'])({}, options, { adapter: adapter }));
                  var wrappedEl = _react2['default'].createElement(ReactWrapperComponent, wrapperProps);
                  instance = hydrateIn ? _reactDom2['default'].hydrate(wrappedEl, domNode) : _reactDom2['default'].render(wrappedEl, domNode);
                  if (typeof callback === 'function') {
                    callback();
                  }
                } else {
                  instance.setChildProps(el.props, context, callback);
                }
              });
            }

            return render;
          }(),
          unmount: function () {
            function unmount() {
              _reactDom2['default'].unmountComponentAtNode(domNode);
              instance = null;
            }

            return unmount;
          }(),
          getNode: function () {
            function getNode() {
              if (!instance) {
                return null;
              }
              return (0, _enzymeAdapterUtils.getNodeFromRootFinder)(adapter.isCustomComponent, _toTree(instance._reactInternalFiber), options);
            }

            return getNode;
          }(),
          simulateError: function () {
            function simulateError(nodeHierarchy, rootNode, error) {
              var isErrorBoundary = function () {
                function isErrorBoundary(_ref) {
                  var elInstance = _ref.instance,
                      type = _ref.type;

                  if (is166 && type && type.getDerivedStateFromError) {
                    return true;
                  }
                  return elInstance && elInstance.componentDidCatch;
                }

                return isErrorBoundary;
              }();

              var _ref2 = nodeHierarchy.find(isErrorBoundary) || {},
                  catchingInstance = _ref2.instance,
                  catchingType = _ref2.type;

              (0, _enzymeAdapterUtils.simulateError)(error, catchingInstance, rootNode, nodeHierarchy, nodeTypeFromType, adapter.displayNameOfNode, is166 ? catchingType : undefined);
            }

            return simulateError;
          }(),
          simulateEvent: function () {
            function simulateEvent(node, event, mock) {
              var mappedEvent = (0, _enzymeAdapterUtils.mapNativeEventNames)(event, eventOptions);
              var eventFn = _testUtils2['default'].Simulate[mappedEvent];
              if (!eventFn) {
                throw new TypeError('ReactWrapper::simulate() event \'' + String(event) + '\' does not exist');
              }
              wrapAct(function () {
                eventFn(adapter.nodeToHostNode(node), mock);
              });
            }

            return simulateEvent;
          }(),
          batchedUpdates: function () {
            function batchedUpdates(fn) {
              return fn();
              // return ReactDOM.unstable_batchedUpdates(fn);
            }

            return batchedUpdates;
          }(),
          getWrappingComponentRenderer: function () {
            function getWrappingComponentRenderer() {
              return (0, _object2['default'])({}, this, (0, _enzymeAdapterUtils.getWrappingComponentMountRenderer)({
                toTree: function () {
                  function toTree(inst) {
                    return _toTree(inst._reactInternalFiber);
                  }

                  return toTree;
                }(),
                getMountWrapperInstance: function () {
                  function getMountWrapperInstance() {
                    return instance;
                  }

                  return getMountWrapperInstance;
                }()
              }));
            }

            return getWrappingComponentRenderer;
          }()
        };
      }

      return createMountRenderer;
    }()
  }, {
    key: 'createShallowRenderer',
    value: function () {
      function createShallowRenderer() {
        var _this4 = this;

        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        var adapter = this;
        var renderer = new _shallow2['default']();
        var suspenseFallback = options.suspenseFallback;

        if (typeof suspenseFallback !== 'undefined' && typeof suspenseFallback !== 'boolean') {
          throw TypeError('`options.suspenseFallback` should be boolean or undefined');
        }
        var isDOM = false;
        var cachedNode = null;

        var lastComponent = null;
        var wrappedComponent = null;
        var sentinel = {};

        // wrap memo components with a PureComponent, or a class component with sCU
        var wrapPureComponent = function () {
          function wrapPureComponent(Component, compare) {
            if (!is166) {
              throw new RangeError('this function should not be called in React < 16.6. Please report this!');
            }
            if (lastComponent !== Component) {
              if (isStateful(Component)) {
                wrappedComponent = function (_Component) {
                  _inherits(wrappedComponent, _Component);

                  function wrappedComponent() {
                    _classCallCheck(this, wrappedComponent);

                    return _possibleConstructorReturn(this, (wrappedComponent.__proto__ || Object.getPrototypeOf(wrappedComponent)).apply(this, arguments));
                  }

                  return wrappedComponent;
                }(Component); // eslint-disable-line react/prefer-stateless-function
                if (compare) {
                  wrappedComponent.prototype.shouldComponentUpdate = function (nextProps) {
                    return !compare(_this4.props, nextProps);
                  };
                } else {
                  wrappedComponent.prototype.isPureReactComponent = true;
                }
              } else {
                var memoized = sentinel;
                var prevProps = void 0;
                wrappedComponent = function () {
                  function wrappedComponent(props) {
                    var shouldUpdate = memoized === sentinel || (compare ? !compare(prevProps, props) : !(0, _Utils.shallowEqual)(prevProps, props));
                    if (shouldUpdate) {
                      for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                        args[_key - 1] = arguments[_key];
                      }

                      memoized = Component.apply(undefined, [(0, _object2['default'])({}, Component.defaultProps, props)].concat(args));
                      prevProps = props;
                    }
                    return memoized;
                  }

                  return wrappedComponent;
                }();
              }
              (0, _object2['default'])(wrappedComponent, Component, { displayName: adapter.displayNameOfNode({ type: Component }) });
              lastComponent = Component;
            }
            return wrappedComponent;
          }

          return wrapPureComponent;
        }();

        // Wrap functional components on versions prior to 16.5,
        // to avoid inadvertently pass a `this` instance to it.
        var wrapFunctionalComponent = function () {
          function wrapFunctionalComponent(Component) {
            if (is166 && (0, _has2['default'])(Component, 'defaultProps')) {
              if (lastComponent !== Component) {
                wrappedComponent = (0, _object2['default'])(
                // eslint-disable-next-line new-cap
                function (props) {
                  for (var _len2 = arguments.length, args = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
                    args[_key2 - 1] = arguments[_key2];
                  }

                  return Component.apply(undefined, [(0, _object2['default'])({}, Component.defaultProps, props)].concat(args));
                }, Component, { displayName: adapter.displayNameOfNode({ type: Component }) });
                lastComponent = Component;
              }
              return wrappedComponent;
            }
            if (is165) {
              return Component;
            }

            if (lastComponent !== Component) {
              wrappedComponent = (0, _object2['default'])(function () {
                return Component.apply(undefined, arguments);
              }, // eslint-disable-line new-cap
              Component);
              lastComponent = Component;
            }
            return wrappedComponent;
          }

          return wrapFunctionalComponent;
        }();

        return {
          render: function () {
            function render(el, unmaskedContext) {
              var _ref3 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
                  _ref3$providerValues = _ref3.providerValues,
                  providerValues = _ref3$providerValues === undefined ? new Map() : _ref3$providerValues;

              cachedNode = el;
              /* eslint consistent-return: 0 */
              if (typeof el.type === 'string') {
                isDOM = true;
              } else if ((0, _reactIs.isContextProvider)(el)) {
                providerValues.set(el.type, el.props.value);
                var MockProvider = (0, _object2['default'])(function (props) {
                  return props.children;
                }, el.type);
                return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
                  return renderer.render((0, _object2['default'])({}, el, { type: MockProvider }));
                });
              } else if ((0, _reactIs.isContextConsumer)(el)) {
                var Provider = adapter.getProviderFromConsumer(el.type);
                var value = providerValues.has(Provider) ? providerValues.get(Provider) : getProviderDefaultValue(Provider);
                var MockConsumer = (0, _object2['default'])(function (props) {
                  return props.children(value);
                }, el.type);
                return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
                  return renderer.render((0, _object2['default'])({}, el, { type: MockConsumer }));
                });
              } else {
                isDOM = false;
                var renderedEl = el;
                if ((0, _reactIs.isLazy)(renderedEl)) {
                  throw TypeError('`React.lazy` is not supported by shallow rendering.');
                }
                if ((0, _reactIs.isSuspense)(renderedEl)) {
                  var children = renderedEl.props.children;

                  if (suspenseFallback) {
                    var fallback = renderedEl.props.fallback;

                    children = replaceLazyWithFallback(children, fallback);
                  }
                  var FakeSuspenseWrapper = function () {
                    function FakeSuspenseWrapper() {
                      return children;
                    }

                    return FakeSuspenseWrapper;
                  }();
                  renderedEl = _react2['default'].createElement(FakeSuspenseWrapper, null, children);
                }
                var _renderedEl = renderedEl,
                    Component = _renderedEl.type;


                var context = (0, _enzymeAdapterUtils.getMaskedContext)(Component.contextTypes, unmaskedContext);

                if ((0, _reactIs.isMemo)(el.type)) {
                  var _el$type = el.type,
                      InnerComp = _el$type.type,
                      compare = _el$type.compare;


                  return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
                    return renderer.render((0, _object2['default'])({}, el, { type: wrapPureComponent(InnerComp, compare) }), context);
                  });
                }

                if (!isStateful(Component) && typeof Component === 'function') {
                  return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
                    return renderer.render((0, _object2['default'])({}, renderedEl, { type: wrapFunctionalComponent(Component) }), context);
                  });
                }

                if (isStateful) {
                  // fix react bug; see implementation of `getEmptyStateValue`
                  var emptyStateValue = getEmptyStateValue();
                  if (emptyStateValue) {
                    Object.defineProperty(Component.prototype, 'state', {
                      configurable: true,
                      enumerable: true,
                      get: function () {
                        function get() {
                          return null;
                        }

                        return get;
                      }(),
                      set: function () {
                        function set(value) {
                          if (value !== emptyStateValue) {
                            Object.defineProperty(this, 'state', {
                              configurable: true,
                              enumerable: true,
                              value: value,
                              writable: true
                            });
                          }
                          return true;
                        }

                        return set;
                      }()
                    });
                  }
                }
                return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
                  return renderer.render(renderedEl, context);
                });
              }
            }

            return render;
          }(),
          unmount: function () {
            function unmount() {
              renderer.unmount();
            }

            return unmount;
          }(),
          getNode: function () {
            function getNode() {
              if (isDOM) {
                return elementToTree(cachedNode);
              }
              var output = renderer.getRenderOutput();
              return {
                nodeType: nodeTypeFromType(cachedNode.type),
                type: cachedNode.type,
                props: cachedNode.props,
                key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(cachedNode.key),
                ref: cachedNode.ref,
                instance: renderer._instance,
                rendered: Array.isArray(output) ? flatten(output).map(function (el) {
                  return elementToTree(el);
                }) : elementToTree(output)
              };
            }

            return getNode;
          }(),
          simulateError: function () {
            function simulateError(nodeHierarchy, rootNode, error) {
              (0, _enzymeAdapterUtils.simulateError)(error, renderer._instance, cachedNode, nodeHierarchy.concat(cachedNode), nodeTypeFromType, adapter.displayNameOfNode, is166 ? cachedNode.type : undefined);
            }

            return simulateError;
          }(),
          simulateEvent: function () {
            function simulateEvent(node, event) {
              for (var _len3 = arguments.length, args = Array(_len3 > 2 ? _len3 - 2 : 0), _key3 = 2; _key3 < _len3; _key3++) {
                args[_key3 - 2] = arguments[_key3];
              }

              var handler = node.props[(0, _enzymeAdapterUtils.propFromEvent)(event, eventOptions)];
              if (handler) {
                (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
                  // TODO(lmr): create/use synthetic events
                  // TODO(lmr): emulate React's event propagation
                  // ReactDOM.unstable_batchedUpdates(() => {
                  handler.apply(undefined, _toConsumableArray(args));
                  // });
                });
              }
            }

            return simulateEvent;
          }(),
          batchedUpdates: function () {
            function batchedUpdates(fn) {
              return fn();
              // return ReactDOM.unstable_batchedUpdates(fn);
            }

            return batchedUpdates;
          }(),
          checkPropTypes: function () {
            function checkPropTypes(typeSpecs, values, location, hierarchy) {
              return (0, _checkPropTypes3['default'])(typeSpecs, values, location, (0, _enzymeAdapterUtils.displayNameOfNode)(cachedNode), function () {
                return (0, _enzymeAdapterUtils.getComponentStack)(hierarchy.concat([cachedNode]));
              });
            }

            return checkPropTypes;
          }()
        };
      }

      return createShallowRenderer;
    }()
  }, {
    key: 'createStringRenderer',
    value: function () {
      function createStringRenderer(options) {
        if ((0, _has2['default'])(options, 'suspenseFallback')) {
          throw new TypeError('`suspenseFallback` should not be specified in options of string renderer');
        }
        return {
          render: function () {
            function render(el, context) {
              if (options.context && (el.type.contextTypes || options.childContextTypes)) {
                var childContextTypes = (0, _object2['default'])({}, el.type.contextTypes || {}, options.childContextTypes);
                var ContextWrapper = (0, _enzymeAdapterUtils.createRenderWrapper)(el, context, childContextTypes);
                return _server2['default'].renderToStaticMarkup(_react2['default'].createElement(ContextWrapper));
              }
              return _server2['default'].renderToStaticMarkup(el);
            }

            return render;
          }()
        };
      }

      return createStringRenderer;
    }()

    // Provided a bag of options, return an `EnzymeRenderer`. Some options can be implementation
    // specific, like `attach` etc. for React, but not part of this interface explicitly.
    // eslint-disable-next-line class-methods-use-this

  }, {
    key: 'createRenderer',
    value: function () {
      function createRenderer(options) {
        switch (options.mode) {
          case _enzyme.EnzymeAdapter.MODES.MOUNT:
            return this.createMountRenderer(options);
          case _enzyme.EnzymeAdapter.MODES.SHALLOW:
            return this.createShallowRenderer(options);
          case _enzyme.EnzymeAdapter.MODES.STRING:
            return this.createStringRenderer(options);
          default:
            throw new Error('Enzyme Internal Error: Unrecognized mode: ' + String(options.mode));
        }
      }

      return createRenderer;
    }()
  }, {
    key: 'wrap',
    value: function () {
      function wrap(element) {
        return (0, _enzymeAdapterUtils.wrap)(element);
      }

      return wrap;
    }()

    // converts an RSTNode to the corresponding JSX Pragma Element. This will be needed
    // in order to implement the `Wrapper.mount()` and `Wrapper.shallow()` methods, but should
    // be pretty straightforward for people to implement.
    // eslint-disable-next-line class-methods-use-this

  }, {
    key: 'nodeToElement',
    value: function () {
      function nodeToElement(node) {
        if (!node || (typeof node === 'undefined' ? 'undefined' : _typeof(node)) !== 'object') return null;
        var type = node.type;

        return _react2['default'].createElement((0, _reactIs.isMemo)(type) ? type.type : type, (0, _enzymeAdapterUtils.propsWithKeysAndRef)(node));
      }

      return nodeToElement;
    }()
  }, {
    key: 'elementToNode',
    value: function () {
      function elementToNode(element) {
        return elementToTree(element);
      }

      return elementToNode;
    }()
  }, {
    key: 'nodeToHostNode',
    value: function () {
      function nodeToHostNode(node) {
        var supportsArray = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

        var nodes = _nodeToHostNode(node);
        if (Array.isArray(nodes) && !supportsArray) {
          return nodes[0];
        }
        return nodes;
      }

      return nodeToHostNode;
    }()
  }, {
    key: 'displayNameOfNode',
    value: function () {
      function displayNameOfNode(node) {
        if (!node) return null;
        var type = node.type,
            $$typeof = node.$$typeof;


        var nodeType = type || $$typeof;

        // newer node types may be undefined, so only test if the nodeType exists
        if (nodeType) {
          switch (nodeType) {
            case (is166 ? _reactIs.ConcurrentMode : _reactIs.AsyncMode) || NaN:
              return is166 ? 'ConcurrentMode' : 'AsyncMode';
            case _reactIs.Fragment || NaN:
              return 'Fragment';
            case _reactIs.StrictMode || NaN:
              return 'StrictMode';
            case _reactIs.Profiler || NaN:
              return 'Profiler';
            case _reactIs.Portal || NaN:
              return 'Portal';
            case _reactIs.Suspense || NaN:
              return 'Suspense';
            default:
          }
        }

        var $$typeofType = type && type.$$typeof;

        switch ($$typeofType) {
          case _reactIs.ContextConsumer || NaN:
            return 'ContextConsumer';
          case _reactIs.ContextProvider || NaN:
            return 'ContextProvider';
          case _reactIs.Memo || NaN:
            {
              var nodeName = (0, _enzymeAdapterUtils.displayNameOfNode)(node);
              return typeof nodeName === 'string' ? nodeName : 'Memo(' + String((0, _enzymeAdapterUtils.displayNameOfNode)(type)) + ')';
            }
          case _reactIs.ForwardRef || NaN:
            {
              if (type.displayName) {
                return type.displayName;
              }
              var name = (0, _enzymeAdapterUtils.displayNameOfNode)({ type: type.render });
              return name ? 'ForwardRef(' + String(name) + ')' : 'ForwardRef';
            }
          case _reactIs.Lazy || NaN:
            {
              return 'lazy';
            }
          default:
            return (0, _enzymeAdapterUtils.displayNameOfNode)(node);
        }
      }

      return displayNameOfNode;
    }()
  }, {
    key: 'isValidElement',
    value: function () {
      function isValidElement(element) {
        return (0, _reactIs.isElement)(element);
      }

      return isValidElement;
    }()
  }, {
    key: 'isValidElementType',
    value: function () {
      function isValidElementType(object) {
        return !!object && (0, _reactIs.isValidElementType)(object);
      }

      return isValidElementType;
    }()
  }, {
    key: 'isFragment',
    value: function () {
      function isFragment(fragment) {
        return (0, _Utils.typeOfNode)(fragment) === _reactIs.Fragment;
      }

      return isFragment;
    }()
  }, {
    key: 'isCustomComponent',
    value: function () {
      function isCustomComponent(type) {
        var fakeElement = makeFakeElement(type);
        return !!type && (typeof type === 'function' || (0, _reactIs.isForwardRef)(fakeElement) || (0, _reactIs.isContextProvider)(fakeElement) || (0, _reactIs.isContextConsumer)(fakeElement) || (0, _reactIs.isSuspense)(fakeElement));
      }

      return isCustomComponent;
    }()
  }, {
    key: 'isContextConsumer',
    value: function () {
      function isContextConsumer(type) {
        return !!type && (0, _reactIs.isContextConsumer)(makeFakeElement(type));
      }

      return isContextConsumer;
    }()
  }, {
    key: 'isCustomComponentElement',
    value: function () {
      function isCustomComponentElement(inst) {
        if (!inst || !this.isValidElement(inst)) {
          return false;
        }
        return this.isCustomComponent(inst.type);
      }

      return isCustomComponentElement;
    }()
  }, {
    key: 'getProviderFromConsumer',
    value: function () {
      function getProviderFromConsumer(Consumer) {
        // React stores references to the Provider on a Consumer differently across versions.
        if (Consumer) {
          var Provider = void 0;
          if (Consumer._context) {
            Provider = Consumer._context.Provider; // check this first, to avoid a deprecation warning
          } else if (Consumer.Provider) {
            Provider = Consumer.Provider;
          }
          if (Provider) {
            return Provider;
          }
        }
        throw new Error('Enzyme Internal Error: can’t figure out how to get Provider from Consumer');
      }

      return getProviderFromConsumer;
    }()
  }, {
    key: 'createElement',
    value: function () {
      function createElement() {
        return _react2['default'].createElement.apply(_react2['default'], arguments);
      }

      return createElement;
    }()
  }, {
    key: 'wrapWithWrappingComponent',
    value: function () {
      function wrapWithWrappingComponent(node, options) {
        return {
          RootFinder: _enzymeAdapterUtils.RootFinder,
          node: (0, _enzymeAdapterUtils.wrapWithWrappingComponent)(_react2['default'].createElement, node, options)
        };
      }

      return wrapWithWrappingComponent;
    }()
  }]);

  return ReactSixteenAdapter;
}(_enzyme.EnzymeAdapter);

module.exports = ReactSixteenAdapter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//# sourceMappingURL=ReactSixteenAdapter.js.map