/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jboss.auth;

import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.Certificate;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.jboss.security.plugins.JaasSecurityDomain;
import org.picketlink.identity.federation.bindings.jboss.auth.SAML2STSCommonLoginModule;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.w3c.dom.Element;

public class SAML2STSLoginModule
extends SAML2STSCommonLoginModule {
    protected static Logger log = Logger.getLogger(SAML2STSCommonLoginModule.class);
    protected boolean trace = log.isTraceEnabled();

    protected boolean localValidation(Element assertionElement) throws Exception {
        if (this.localTestingOnly) {
            return true;
        }
        try {
            InitialContext ctx = new InitialContext();
            JaasSecurityDomain sd = (JaasSecurityDomain)ctx.lookup(this.localValidationSecurityDomain);
            KeyStore ts = sd.getTrustStore();
            if (ts == null) {
                throw new LoginException("PL00092: Null Value:SAML2STSLoginModule: null truststore for " + sd.getName());
            }
            String alias = sd.getKeyStoreAlias();
            if (alias == null) {
                throw new LoginException("PL00092: Null Value:SAML2STSLoginModule: null KeyStoreAlias for " + sd.getName() + "; set 'KeyStoreAlias' in '" + sd.getName() + "' security domain configuration");
            }
            Certificate cert = ts.getCertificate(alias);
            if (cert == null) {
                throw new LoginException("PL00092: Null Value:SAML2STSLoginModule: no certificate found for alias '" + alias + "' in the '" + sd.getName() + "' security domain");
            }
            PublicKey publicKey = cert.getPublicKey();
            boolean sigValid = AssertionUtil.isSignatureValid((Element)assertionElement, (PublicKey)publicKey);
            if (!sigValid) {
                throw new LoginException("PL00009: Invalid Digital Signature:SAML2STSLoginModule: http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid : invalid SAML V2.0 assertion signature");
            }
            AssertionType assertion = SAMLUtil.fromElement((Element)assertionElement);
            if (AssertionUtil.hasExpired((AssertionType)assertion)) {
                throw new LoginException("PL00079: Assertion has expired:SAML2STSLoginModule: http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid::assertion expired or used before its lifetime period");
            }
        }
        catch (NamingException e) {
            throw new LoginException(e.toString());
        }
        return true;
    }
}

