/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.sp;

import java.security.Principal;
import java.util.List;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.GenericPrincipal;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public AuthnRequestType createSAMLRequest(String serviceURL, String identityURL) throws ConfigurationException {
        if (serviceURL == null) {
            throw logger.nullArgumentError("serviceURL");
        }
        if (identityURL == null) {
            throw logger.nullArgumentError("identityURL");
        }
        SAML2Request saml2Request = new SAML2Request();
        String id = IDGenerator.create((String)"ID_");
        return saml2Request.createAuthnRequestType(id, serviceURL, identityURL, serviceURL);
    }

    public Principal createGenericPrincipal(Request request, String username, List<String> roles) {
        Context ctx = request.getContext();
        return new GenericPrincipal(ctx.getRealm(), username, null, roles);
    }
}

