/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jboss.auth;

import java.io.Serializable;
import java.security.Principal;
import javax.security.auth.Subject;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.security.SecurityContext;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.api.wstrust.WSTrustClient;
import org.picketlink.identity.federation.bindings.jboss.auth.SecurityActions;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.w3c.dom.Element;

public class STSClientInterceptor
implements Interceptor,
Serializable {
    private static final long serialVersionUID = -4351623612864518960L;
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private String propertiesFile;
    private STSClientConfig.Builder builder;

    public String getName() {
        return this.getClass().getName();
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
        logger.trace("Constructing STSClientInterceptor using " + propertiesFile + " as the configuration file");
    }

    public Object invoke(Invocation invocation) throws Throwable {
        SecurityContext sc = (SecurityContext)invocation.getMetaData((Object)"security", (Object)"context");
        logger.trace("Retrieved SecurityContext from invocation:" + sc);
        if (sc != null) {
            Principal principal = sc.getUtil().getUserPrincipal();
            String credential = (String)sc.getUtil().getCredential();
            if (this.builder == null) {
                if (this.propertiesFile != null) {
                    this.builder = new STSClientConfig.Builder(this.propertiesFile);
                } else {
                    throw logger.optionNotSet("propertiesFile");
                }
            }
            WSTrustClient client = new WSTrustClient(this.builder.getServiceName(), this.builder.getPortName(), this.builder.getEndpointAddress(), new WSTrustClient.SecurityInfo(principal.getName(), credential));
            Element assertion = null;
            try {
                logger.trace("Invoking token service to get SAML assertion for " + principal.getName());
                assertion = client.issueToken("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                logger.trace("SAML assertion for " + principal.getName() + " successfully obtained");
            }
            catch (WSTrustException wse) {
                logger.authSAMLAssertionIssuingFailed((Throwable)wse);
            }
            if (assertion != null) {
                Subject subject = sc.getUtil().getSubject();
                SecurityContext newSC = SecurityActions.createSecurityContext();
                newSC.getUtil().createSubjectInfo(principal, (Object)new SamlCredential(assertion), subject);
                invocation.getMetaData().addMetaData((Object)"security", (Object)"context", (Object)newSC);
            }
        }
        return invocation.invokeNext();
    }
}

