/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.openid;

import java.security.Principal;
import java.security.acl.Group;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.picketlink.social.openid.OpenIDProcessor;

public class OpenIDLoginModule
extends UsernamePasswordLoginModule {
    protected Principal getIdentity() {
        return OpenIDProcessor.cachedPrincipal.get();
    }

    protected String getUsersPassword() throws LoginException {
        return OpenIDProcessor.EMPTY_PASSWORD;
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup group = new SimpleGroup("Roles");
        List<String> roles = OpenIDProcessor.cachedRoles.get();
        if (roles != null) {
            for (String role : roles) {
                group.addMember((Principal)new SimplePrincipal(role));
            }
        }
        return new Group[]{group};
    }
}

