/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jboss.auth.mapping;

import java.security.Principal;
import java.util.Map;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.mapping.MappingResult;
import org.jboss.security.mapping.providers.principal.AbstractPrincipalMappingProvider;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.BaseIDAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSPrincipalMappingProvider
extends AbstractPrincipalMappingProvider {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private MappingResult<Principal> result;

    public void init(Map<String, Object> contextMap) {
    }

    public void performMapping(Map<String, Object> contextMap, Principal principal) {
        Object tokenObject;
        if (contextMap == null) {
            logger.mappingContextNull();
        }
        if (!((tokenObject = contextMap.get("org.picketlink.identity.federation.core.wstrust.lm.stsToken")) instanceof Element)) {
            logger.debug("Did not find a token " + Element.class.getName() + " under " + "org.picketlink.identity.federation.core.wstrust.lm.stsToken" + " in the map");
        }
        try {
            BaseIDAbstractType baseID;
            Element tokenElement = (Element)tokenObject;
            AssertionType assertion = SAMLUtil.fromElement((Element)tokenElement);
            SubjectType subject = assertion.getSubject();
            if (subject != null && (baseID = subject.getSubType().getBaseID()) != null && baseID instanceof NameIDType) {
                NameIDType nameID = (NameIDType)baseID;
                SimplePrincipal mappedPrincipal = new SimplePrincipal(nameID.getValue());
                this.result.setMappedObject((Object)mappedPrincipal);
                logger.trace("Mapped principal = " + mappedPrincipal);
                return;
            }
        }
        catch (Exception e) {
            logger.samlAssertionPasingFailed((Throwable)e);
        }
    }

    public void setMappingResult(MappingResult<Principal> mappingResult) {
        this.result = mappingResult;
    }
}

