/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api.session;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.api.AttributesManager;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.PersistenceManager;
import org.picketlink.idm.api.RelationshipManager;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.RoleManager;
import org.picketlink.idm.api.Transaction;
import org.picketlink.idm.api.User;
import org.picketlink.idm.api.event.EventListener;
import org.picketlink.idm.api.query.GroupQuery;
import org.picketlink.idm.api.query.GroupQueryBuilder;
import org.picketlink.idm.api.query.QueryException;
import org.picketlink.idm.api.query.RoleQuery;
import org.picketlink.idm.api.query.RoleQueryBuilder;
import org.picketlink.idm.api.query.UserQuery;
import org.picketlink.idm.api.query.UserQueryBuilder;
import org.picketlink.idm.cache.APICacheProvider;
import org.picketlink.idm.common.exception.FeatureNotSupportedException;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.query.GroupQueryBuilderImpl;
import org.picketlink.idm.impl.api.query.GroupQueryExecutorImpl;
import org.picketlink.idm.impl.api.query.GroupQueryImpl;
import org.picketlink.idm.impl.api.query.RoleQueryBuilderImpl;
import org.picketlink.idm.impl.api.query.RoleQueryExecutorImpl;
import org.picketlink.idm.impl.api.query.RoleQueryImpl;
import org.picketlink.idm.impl.api.query.UserQueryBuilderImpl;
import org.picketlink.idm.impl.api.query.UserQueryExecutorImpl;
import org.picketlink.idm.impl.api.query.UserQueryImpl;
import org.picketlink.idm.impl.api.session.SimpleTransactionImpl;
import org.picketlink.idm.impl.api.session.context.IdentitySessionContext;
import org.picketlink.idm.impl.api.session.context.IdentitySessionContextImpl;
import org.picketlink.idm.impl.api.session.context.IdentityStoreInvocationContextResolver;
import org.picketlink.idm.impl.api.session.managers.AttributesManagerImpl;
import org.picketlink.idm.impl.api.session.managers.PersistenceManagerImpl;
import org.picketlink.idm.impl.api.session.managers.RelationshipManagerImpl;
import org.picketlink.idm.impl.api.session.managers.RoleManagerImpl;
import org.picketlink.idm.impl.api.session.mapper.IdentityObjectTypeMapper;
import org.picketlink.idm.impl.store.SimpleIdentityStoreInvocationContext;
import org.picketlink.idm.spi.configuration.IdentityConfigurationContext;
import org.picketlink.idm.spi.repository.IdentityStoreRepository;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.store.IdentityStoreSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentitySessionImpl
implements IdentitySession,
Serializable {
    private static final long serialVersionUID = 7615238887627699243L;
    private final String realmName;
    private final IdentitySessionContext sessionContext;
    private final PersistenceManager persistenceManager;
    private final RelationshipManager relationshipManager;
    private final AttributesManager profileManager;
    private final RoleManager roleManager;
    private final UserQueryExecutorImpl userQueryExecutor;
    private final GroupQueryExecutorImpl groupQueryExecutor;
    private final RoleQueryExecutorImpl roleQueryExecutor;
    private final Collection<EventListener> listeners = new LinkedList<EventListener>();
    private final APICacheProvider apiCacheProvider;
    private final String cacheNS;

    public IdentitySessionContext getSessionContext() {
        return this.sessionContext;
    }

    public IdentitySessionImpl(String realmName, IdentityStoreRepository repository, IdentityObjectTypeMapper typeMapper, APICacheProvider apiCacheProvider, IdentityConfigurationContext configurationContext, Map<String, List<String>> realmOptions) throws IdentityException {
        List<String> cacheScope;
        this.realmName = realmName;
        IdentityStoreSession storeSession = repository.createIdentityStoreSession();
        final SimpleIdentityStoreInvocationContext invocationCtx = new SimpleIdentityStoreInvocationContext(storeSession, realmName, String.valueOf(this.hashCode()));
        IdentityStoreInvocationContextResolver resolver = new IdentityStoreInvocationContextResolver(){

            public IdentityStoreInvocationContext resolveInvocationContext() {
                return invocationCtx;
            }
        };
        this.apiCacheProvider = apiCacheProvider;
        this.sessionContext = new IdentitySessionContextImpl(repository, typeMapper, resolver);
        this.persistenceManager = new PersistenceManagerImpl(this);
        this.relationshipManager = new RelationshipManagerImpl(this);
        this.profileManager = new AttributesManagerImpl(this);
        this.roleManager = new RoleManagerImpl(this);
        this.userQueryExecutor = new UserQueryExecutorImpl(this);
        this.groupQueryExecutor = new GroupQueryExecutorImpl(this);
        this.roleQueryExecutor = new RoleQueryExecutorImpl(this);
        this.cacheNS = apiCacheProvider != null ? ((cacheScope = realmOptions.get("cache.scope")) != null && cacheScope.size() > 1 && cacheScope.get(0).equals("session") ? apiCacheProvider.getNamespace(realmName, String.valueOf(this.hashCode())) : apiCacheProvider.getNamespace(realmName)) : null;
    }

    public String getId() {
        return String.valueOf(this.hashCode());
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void close() throws IdentityException {
        this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession().close();
    }

    public void save() throws IdentityException {
        this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession().save();
    }

    public void clear() throws IdentityException {
        this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession().clear();
    }

    public boolean isOpen() {
        return this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession().isOpen();
    }

    public Transaction beginTransaction() {
        SimpleTransactionImpl transaction = new SimpleTransactionImpl(this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession());
        transaction.start();
        return transaction;
    }

    public Transaction getTransaction() {
        return new SimpleTransactionImpl(this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession());
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public RelationshipManager getRelationshipManager() {
        return this.relationshipManager;
    }

    public AttributesManager getAttributesManager() {
        return this.profileManager;
    }

    public RoleManager getRoleManager() throws FeatureNotSupportedException {
        if (!this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isNamedRelationshipsSupported()) {
            throw new FeatureNotSupportedException("Role management not supported by underlaying configured identity stores");
        }
        return this.roleManager;
    }

    public UserQueryBuilder createUserQueryBuilder() {
        return new UserQueryBuilderImpl();
    }

    public GroupQueryBuilder createGroupQueryBuilder() {
        return new GroupQueryBuilderImpl();
    }

    public RoleQueryBuilder createRoleQueryBuilder() throws FeatureNotSupportedException {
        if (!this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isNamedRelationshipsSupported()) {
            throw new FeatureNotSupportedException("Role management not supported by underlaying configured identity stores");
        }
        return new RoleQueryBuilderImpl();
    }

    public Collection<User> execute(UserQuery userQuery) throws QueryException {
        Collection results;
        if (this.apiCacheProvider != null && (results = this.apiCacheProvider.getUserQuery(this.cacheNS, userQuery)) != null) {
            return results;
        }
        results = this.userQueryExecutor.execute((UserQueryImpl)userQuery);
        if (this.apiCacheProvider != null) {
            this.apiCacheProvider.putUserQuery(this.cacheNS, userQuery, results);
        }
        return results;
    }

    public User uniqueResult(UserQuery userQuery) throws QueryException {
        User result;
        if (this.apiCacheProvider != null && (result = this.apiCacheProvider.getUserQueryUnique(this.cacheNS, userQuery)) != null) {
            return result;
        }
        result = this.userQueryExecutor.uniqueResult((UserQueryImpl)userQuery);
        if (this.apiCacheProvider != null) {
            this.apiCacheProvider.putUserQueryUnique(this.cacheNS, userQuery, result);
        }
        return result;
    }

    public List<User> list(UserQuery userQuery) throws QueryException {
        Collection<Object> results;
        if (this.apiCacheProvider != null && (results = this.apiCacheProvider.getUserQuery(this.cacheNS, userQuery)) != null && results instanceof List) {
            return results;
        }
        results = this.userQueryExecutor.list((UserQueryImpl)userQuery);
        if (this.apiCacheProvider != null) {
            this.apiCacheProvider.putUserQuery(this.cacheNS, userQuery, results);
        }
        return results;
    }

    public Collection<Group> execute(GroupQuery groupQuery) throws QueryException {
        Collection results;
        if (this.apiCacheProvider != null && (results = this.apiCacheProvider.getGroupQuery(this.cacheNS, groupQuery)) != null) {
            return results;
        }
        results = this.groupQueryExecutor.execute((GroupQueryImpl)groupQuery);
        if (this.apiCacheProvider != null) {
            this.apiCacheProvider.putGroupQuery(this.cacheNS, groupQuery, results);
        }
        return results;
    }

    public Group uniqueResult(GroupQuery groupQuery) throws QueryException {
        Group result;
        if (this.apiCacheProvider != null && (result = this.apiCacheProvider.getGroupQueryUnique(this.cacheNS, groupQuery)) != null) {
            return result;
        }
        Group group = this.groupQueryExecutor.uniqueResult((GroupQueryImpl)groupQuery);
        if (this.apiCacheProvider != null) {
            this.apiCacheProvider.putGroupQueryUnique(this.cacheNS, groupQuery, group);
        }
        return group;
    }

    public List<Group> list(GroupQuery groupQuery) throws QueryException {
        Collection<Object> results;
        if (this.apiCacheProvider != null && (results = this.apiCacheProvider.getGroupQuery(this.cacheNS, groupQuery)) != null && results instanceof List) {
            return results;
        }
        results = this.groupQueryExecutor.list((GroupQueryImpl)groupQuery);
        if (this.apiCacheProvider != null) {
            this.apiCacheProvider.putGroupQuery(this.cacheNS, groupQuery, results);
        }
        return results;
    }

    public Collection<Role> execute(RoleQuery roleQuery) throws QueryException {
        Collection results;
        if (this.apiCacheProvider != null && (results = this.apiCacheProvider.getRoleQuery(this.cacheNS, roleQuery)) != null) {
            return results;
        }
        results = this.roleQueryExecutor.execute((RoleQueryImpl)roleQuery);
        if (this.apiCacheProvider != null) {
            this.apiCacheProvider.putRoleQuery(this.cacheNS, roleQuery, results);
        }
        return results;
    }

    public Role uniqueResult(RoleQuery roleQuery) throws QueryException {
        Role result;
        if (this.apiCacheProvider != null && (result = this.apiCacheProvider.getRoleQueryUnique(this.cacheNS, roleQuery)) != null) {
            return result;
        }
        result = this.roleQueryExecutor.uniqueResult((RoleQueryImpl)roleQuery);
        if (this.apiCacheProvider != null) {
            this.apiCacheProvider.putRoleQueryUnique(this.cacheNS, roleQuery, result);
        }
        return result;
    }

    public List<Role> list(RoleQuery roleQuery) throws QueryException {
        Collection<Object> results;
        if (this.apiCacheProvider != null && (results = this.apiCacheProvider.getRoleQuery(this.cacheNS, roleQuery)) != null && results instanceof List) {
            return results;
        }
        results = this.roleQueryExecutor.list((RoleQueryImpl)roleQuery);
        if (this.apiCacheProvider != null) {
            this.apiCacheProvider.putRoleQuery(this.cacheNS, roleQuery, results);
        }
        return results;
    }

    public void registerListener(EventListener listener) {
        this.listeners.add(listener);
    }

    public Collection<EventListener> getListeners() {
        return this.listeners;
    }

    public APICacheProvider getApiCacheProvider() {
        return this.apiCacheProvider;
    }

    public String getCacheNS() {
        return this.cacheNS;
    }
}

