/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.ldap;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.SortControl;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.NotYetImplementedException;
import org.picketlink.idm.impl.api.SimpleAttribute;
import org.picketlink.idm.impl.helper.Tools;
import org.picketlink.idm.impl.model.ldap.LDAPIdentityObjectImpl;
import org.picketlink.idm.impl.model.ldap.LDAPIdentityObjectRelationshipImpl;
import org.picketlink.idm.impl.store.FeaturesMetaDataImpl;
import org.picketlink.idm.impl.store.ldap.LDAPIdentityObjectTypeConfiguration;
import org.picketlink.idm.impl.store.ldap.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.impl.store.ldap.LDAPIdentityStoreSessionImpl;
import org.picketlink.idm.impl.store.ldap.SimpleLDAPIdentityStoreConfiguration;
import org.picketlink.idm.impl.types.SimpleIdentityObject;
import org.picketlink.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectTypeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;
import org.picketlink.idm.spi.exception.OperationNotSupportedException;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;
import org.picketlink.idm.spi.model.IdentityObjectCredential;
import org.picketlink.idm.spi.model.IdentityObjectRelationship;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.search.IdentityObjectSearchCriteria;
import org.picketlink.idm.spi.store.FeaturesMetaData;
import org.picketlink.idm.spi.store.IdentityObjectSearchCriteriaType;
import org.picketlink.idm.spi.store.IdentityStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.store.IdentityStoreSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPIdentityStoreImpl
implements IdentityStore {
    private static Logger log = Logger.getLogger(LDAPIdentityStoreImpl.class.getName());
    private final String id;
    public static final String MEMBERSHIP_TYPE = "JBOSS_IDENTITY_MEMBERSHIP";
    private FeaturesMetaData supportedFeatures;
    LDAPIdentityStoreConfiguration configuration;
    IdentityStoreConfigurationMetaData configurationMD;
    private final Set<IdentityObjectSearchCriteriaType> supportedSearchCriteriaTypes = new HashSet<IdentityObjectSearchCriteriaType>();
    private Map<String, Map<String, IdentityObjectAttributeMetaData>> attributesMetaData = new HashMap<String, Map<String, IdentityObjectAttributeMetaData>>();

    public LDAPIdentityStoreImpl(String id) {
        this.id = id;
    }

    public void bootstrap(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
        if (configurationContext == null) {
            throw new IllegalArgumentException("Configuration context is null");
        }
        this.configurationMD = configurationContext.getStoreConfigurationMetaData();
        this.configuration = new SimpleLDAPIdentityStoreConfiguration(this.configurationMD);
        HashSet<String> readOnlyObjectTypes = new HashSet<String>();
        for (IdentityObjectType identityObjectType : this.configuration.getConfiguredTypes()) {
            if (this.configuration.getTypeConfiguration(identityObjectType.getName()).isAllowCreateEntry()) continue;
            readOnlyObjectTypes.add(identityObjectType.getName());
        }
        this.supportedSearchCriteriaTypes.clear();
        if (this.configuration.isSortExtensionSupported()) {
            this.supportedSearchCriteriaTypes.add(IdentityObjectSearchCriteriaType.SORT);
        }
        this.supportedSearchCriteriaTypes.add(IdentityObjectSearchCriteriaType.PAGE);
        this.supportedSearchCriteriaTypes.add(IdentityObjectSearchCriteriaType.NAME_FILTER);
        this.supportedFeatures = new FeaturesMetaDataImpl(this.configurationMD, this.supportedSearchCriteriaTypes, false, false, readOnlyObjectTypes);
        for (IdentityObjectTypeMetaData identityObjectTypeMetaData : this.configurationMD.getSupportedIdentityTypes()) {
            HashMap<String, IdentityObjectAttributeMetaData> metadataMap = new HashMap<String, IdentityObjectAttributeMetaData>();
            for (IdentityObjectAttributeMetaData attributeMetaData : identityObjectTypeMetaData.getAttributes()) {
                metadataMap.put(attributeMetaData.getName(), attributeMetaData);
            }
            this.attributesMetaData.put(identityObjectTypeMetaData.getName(), metadataMap);
        }
        if (this.configuration.isCreateMissingContexts()) {
            HashSet<String> dns = new HashSet<String>();
            if (this.configuration.getRelationshipNamesCtxDNs() != null) {
                for (String dn : this.configuration.getRelationshipNamesCtxDNs()) {
                    dns.add(dn);
                }
            }
            for (LDAPIdentityObjectTypeConfiguration typeCfg : this.configuration.getTypesConfiguration().values()) {
                for (String dn : typeCfg.getCtxDNs()) {
                    dns.add(dn);
                }
            }
            DirContext ctx = (DirContext)this.createIdentityStoreSession().getSessionContext();
            try {
                for (String dn : dns) {
                    this.checkCtx(ctx, dn);
                }
            }
            catch (Exception e) {
                throw new IdentityException("Cannot create entries in LDAP during store initialization: " + e);
            }
            finally {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    throw new IdentityException("Cannot close LDAP connection: ", (Throwable)e);
                }
            }
        }
    }

    public IdentityStoreSession createIdentityStoreSession() {
        return new LDAPIdentityStoreSessionImpl(this.configuration);
    }

    public String getId() {
        return this.id;
    }

    public FeaturesMetaData getSupportedFeatures() {
        return this.supportedFeatures;
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType) throws IdentityException {
        return this.createIdentityObject(invocationCtx, name, identityObjectType, null);
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType type, Map<String, String[]> attributes) throws IdentityException {
        if (name == null) {
            throw new IdentityException("Name cannot be null");
        }
        this.checkIOType(type);
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".createIdentityObject with name: " + name + " and type: " + type.getName());
        }
        LdapContext ldapContext = this.getLDAPContext(invocationCtx);
        String dn = null;
        try {
            Map.Entry<String, String[]> entry2;
            LdapContext ctx = (LdapContext)ldapContext.lookup(this.getTypeConfiguration(invocationCtx, type).getCtxDNs()[0]);
            BasicAttributes attrs = new BasicAttributes(true);
            Map<String, String[]> attributesToAdd = this.getTypeConfiguration(invocationCtx, type).getCreateEntryAttributeValues();
            if (attributes != null) {
                for (Map.Entry<String, String[]> entry2 : attributes.entrySet()) {
                    if (!attributesToAdd.containsKey(entry2.getKey())) {
                        attributesToAdd.put(entry2.getKey(), entry2.getValue());
                        continue;
                    }
                    List<Object> list1 = Arrays.asList((Object[])attributesToAdd.get(entry2.getKey()));
                    List<Object> list2 = Arrays.asList((Object[])entry2.getValue());
                    list1.addAll(list2);
                    String[] vals = list1.toArray(new String[list1.size()]);
                    attributesToAdd.put((String)entry2.getKey(), vals);
                }
            }
            for (String attributeName : attributesToAdd.keySet()) {
                String[] attributeValues;
                BasicAttribute attr = new BasicAttribute(attributeName);
                for (String attrValue : attributeValues = attributesToAdd.get(attributeName)) {
                    attr.add(attrValue);
                }
                attrs.put(attr);
            }
            LdapName validLDAPName = new LdapName(this.getTypeConfiguration(invocationCtx, type).getIdAttributeName().concat("=").concat(name));
            if (log.isLoggable(Level.FINER)) {
                log.finer("creating ldap entry for: " + validLDAPName + "; " + attrs);
            }
            if ((entry2 = ctx.createSubcontext(validLDAPName, (Attributes)attrs)) != null) {
                dn = entry2.getNameInNamespace();
            }
        }
        catch (Exception e) {
            throw new IdentityException("Failed to create identity object", (Throwable)e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
        return new SimpleIdentityObject(name, dn, type);
    }

    public void removeIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObject identity) throws IdentityException {
        LDAPIdentityObjectImpl ldapIdentity;
        String dn;
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".removeIdentityObject: " + identity);
        }
        if ((dn = (ldapIdentity = this.getSafeLDAPIO(invocationCtx, identity)).getDn()) == null) {
            throw new IdentityException("Cannot obtain DN of identity");
        }
        LdapContext ldapContext = this.getLDAPContext(invocationCtx);
        try {
            log.finer("removing entry: " + dn);
            ldapContext.unbind(dn);
        }
        catch (Exception e) {
            throw new IdentityException("Failed to remove identity: ", (Throwable)e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
    }

    public int getIdentityObjectsCount(IdentityStoreInvocationContext ctx, IdentityObjectType identityType) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".getIdentityObjectsCount for type: " + identityType);
        }
        this.checkIOType(identityType);
        try {
            String filter = this.getTypeConfiguration(ctx, identityType).getEntrySearchFilter();
            filter = filter != null && filter.length() > 0 ? filter.replaceAll("\\{0\\}", "*") : "(".concat(this.getTypeConfiguration(ctx, identityType).getIdAttributeName()).concat("=").concat("*").concat(")");
            String[] entryCtxs = this.getTypeConfiguration(ctx, identityType).getCtxDNs();
            String scope = this.getTypeConfiguration(ctx, identityType).getEntrySearchScope();
            List<SearchResult> sr = this.searchIdentityObjects(ctx, entryCtxs, filter, null, new String[]{this.getTypeConfiguration(ctx, identityType).getIdAttributeName()}, scope, null);
            return sr.size();
        }
        catch (NoSuchElementException e) {
        }
        catch (Exception e) {
            throw new IdentityException("User search failed.", (Throwable)e);
        }
        return 0;
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType type) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".findIdentityObject with name: " + name + "; and type: " + type);
        }
        Context ctx = null;
        this.checkIOType(type);
        try {
            if (name == null) {
                throw new IdentityException("Identity object name canot be null");
            }
            String filter = this.getTypeConfiguration(invocationCtx, type).getEntrySearchFilter();
            List<SearchResult> sr = null;
            String[] entryCtxs = this.getTypeConfiguration(invocationCtx, type).getCtxDNs();
            String scope = this.getTypeConfiguration(invocationCtx, type).getEntrySearchScope();
            if (filter != null && filter.length() > 0) {
                Object[] filterArgs = new Object[]{name};
                sr = this.searchIdentityObjects(invocationCtx, entryCtxs, filter, filterArgs, new String[]{this.getTypeConfiguration(invocationCtx, type).getIdAttributeName()}, scope, null);
            } else {
                filter = "(".concat(this.getTypeConfiguration(invocationCtx, type).getIdAttributeName()).concat("=").concat(name).concat(")");
                sr = this.searchIdentityObjects(invocationCtx, entryCtxs, filter, null, new String[]{this.getTypeConfiguration(invocationCtx, type).getIdAttributeName()}, scope, null);
            }
            if (sr.size() > 1) {
                throw new IdentityException("Found more than one identity object with name: " + name + "; Posible data inconsistency");
            }
            SearchResult res = sr.iterator().next();
            ctx = (Context)res.getObject();
            String dn = ctx.getNameInNamespace();
            LDAPIdentityObjectImpl io = this.createIdentityObjectInstance(invocationCtx, type, res.getAttributes(), dn);
            ctx.close();
            LDAPIdentityObjectImpl lDAPIdentityObjectImpl = io;
            return lDAPIdentityObjectImpl;
        }
        catch (NoSuchElementException e) {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e2) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e2);
            }
        }
        catch (NamingException e) {
            throw new IdentityException("IdentityObject search failed.", (Throwable)e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
        return null;
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext ctx, String id) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".findIdentityObject with id: " + id);
        }
        LdapContext ldapContext = this.getLDAPContext(ctx);
        try {
            if (id == null) {
                throw new IdentityException("identity id cannot be null");
            }
            String dn = id;
            IdentityObjectType type = null;
            IdentityObjectType[] possibleTypes = this.getConfiguration(ctx).getConfiguredTypes();
            HashSet<IdentityObjectType> matches = new HashSet<IdentityObjectType>();
            block13: for (IdentityObjectType possibleType : possibleTypes) {
                String[] typeCtxs;
                for (String typeCtx : typeCtxs = this.getTypeConfiguration(ctx, possibleType).getCtxDNs()) {
                    if (!dn.toLowerCase().endsWith(typeCtx.toLowerCase())) continue;
                    matches.add(possibleType);
                    continue block13;
                }
            }
            if (matches.size() == 1) {
                type = (IdentityObjectType)matches.iterator().next();
            } else if (matches.size() > 1) {
                String name = Tools.stripDnToName((String)dn);
                for (IdentityObjectType match : matches) {
                    LDAPIdentityObjectImpl entry = (LDAPIdentityObjectImpl)this.findIdentityObject(ctx, name, match);
                    if (entry == null || !entry.getDn().equalsIgnoreCase(dn)) continue;
                    type = match;
                    break;
                }
            }
            if (type == null) {
                throw new IdentityException("Cannot recognize identity object type by its DN: " + dn);
            }
            Attributes attrs = ldapContext.getAttributes(dn);
            if (attrs == null) {
                throw new IdentityException("Can't find identity entry with DN: " + dn);
            }
            LDAPIdentityObjectImpl lDAPIdentityObjectImpl = this.createIdentityObjectInstance(ctx, type, attrs, dn);
            return lDAPIdentityObjectImpl;
        }
        catch (NoSuchElementException e) {
            try {
                ldapContext.close();
            }
            catch (NamingException e2) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e2);
            }
        }
        catch (NamingException e) {
            throw new IdentityException("Identity object search failed.", (Throwable)e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
        return null;
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObjectType type, IdentityObjectSearchCriteria criteria) throws IdentityException {
        String nameFilter = "*";
        if (criteria != null && criteria.getFilter() != null) {
            nameFilter = criteria.getFilter();
        }
        LdapContext ctx = this.getLDAPContext(invocationCtx);
        this.checkIOType(type);
        LinkedList objects = new LinkedList();
        LDAPIdentityObjectTypeConfiguration typeConfiguration = this.getTypeConfiguration(invocationCtx, type);
        try {
            Control[] requestControls = null;
            if (criteria != null && criteria.isSorted() && this.configuration.isSortExtensionSupported()) {
                requestControls = new Control[]{new SortControl(typeConfiguration.getIdAttributeName(), true)};
            }
            StringBuilder af = new StringBuilder();
            if (criteria != null && criteria.isFiltered()) {
                af.append("(&");
                for (Map.Entry stringEntry : criteria.getValues().entrySet()) {
                    for (String value : (String[])stringEntry.getValue()) {
                        String attributeName = this.getTypeConfiguration(invocationCtx, type).getAttributeMapping((String)stringEntry.getKey());
                        if (attributeName == null) {
                            attributeName = (String)stringEntry.getKey();
                        }
                        af.append("(").append(attributeName).append("=").append(value).append(")");
                    }
                }
                af.append(")");
            }
            String filter = this.getTypeConfiguration(invocationCtx, type).getEntrySearchFilter();
            List<SearchResult> sr = null;
            String[] entryCtxs = this.getTypeConfiguration(invocationCtx, type).getCtxDNs();
            String scope = this.getTypeConfiguration(invocationCtx, type).getEntrySearchScope();
            if (filter != null && filter.length() > 0) {
                filter = filter.replaceAll("\\{0\\}", nameFilter);
                sr = this.searchIdentityObjects(invocationCtx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", null, new String[]{typeConfiguration.getIdAttributeName()}, scope, requestControls);
            } else {
                filter = "(".concat(typeConfiguration.getIdAttributeName()).concat("=").concat(nameFilter).concat(")");
                sr = this.searchIdentityObjects(invocationCtx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", null, new String[]{typeConfiguration.getIdAttributeName()}, scope, requestControls);
            }
            for (SearchResult res : sr) {
                ctx = (LdapContext)res.getObject();
                String dn = ctx.getNameInNamespace();
                if (criteria != null && criteria.isSorted() && this.configuration.isSortExtensionSupported()) {
                    if (!criteria.isAscending()) {
                        objects.addFirst(this.createIdentityObjectInstance(invocationCtx, type, res.getAttributes(), dn));
                        continue;
                    }
                    objects.addLast(this.createIdentityObjectInstance(invocationCtx, type, res.getAttributes(), dn));
                    continue;
                }
                objects.add(this.createIdentityObjectInstance(invocationCtx, type, res.getAttributes(), dn));
            }
            ctx.close();
        }
        catch (NoSuchElementException e) {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e2) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e2);
            }
        }
        catch (Exception e) {
            throw new IdentityException("IdentityObject search failed.", (Throwable)e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
        if (criteria != null && criteria.isSorted() && !this.configuration.isSortExtensionSupported()) {
            this.sortByName(objects, criteria.isAscending());
        }
        if (criteria != null && criteria.isPaged()) {
            objects = (LinkedList)this.cutPageFromResults(objects, criteria);
        }
        return objects;
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObjectType type) throws IdentityException {
        return this.findIdentityObject(invocationCtx, type, null);
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        if (relationshipType != null && !relationshipType.getName().equals(MEMBERSHIP_TYPE)) {
            throw new IdentityException("This store implementation supports only 'JBOSS_IDENTITY_MEMBERSHIP' relationship type");
        }
        LDAPIdentityObjectImpl ldapIO = this.getSafeLDAPIO(ctx, identity);
        LDAPIdentityObjectTypeConfiguration typeConfig = this.getTypeConfiguration(ctx, identity.getIdentityType());
        LdapContext ldapContext = this.getLDAPContext(ctx);
        List<IdentityObject> objects = new LinkedList<IdentityObject>();
        try {
            Attributes attrs;
            if (parent) {
                if (typeConfig.getParentMembershipAttributeName() != null) {
                    attrs = ldapContext.getAttributes(ldapIO.getDn());
                    Attribute member = attrs.get(typeConfig.getParentMembershipAttributeName());
                    if (member != null) {
                        NamingEnumeration<?> memberValues = member.getAll();
                        while (memberValues.hasMoreElements()) {
                            String memberRef = memberValues.nextElement().toString();
                            String placeholder = typeConfig.getParentMembershipAttributePlaceholder();
                            if (placeholder != null && memberRef.equalsIgnoreCase(placeholder)) continue;
                            if (typeConfig.isParentMembershipAttributeDN()) {
                                if (criteria != null && criteria.getFilter() != null) {
                                    String name = Tools.stripDnToName((String)memberRef);
                                    String regex = Tools.wildcardToRegex((String)criteria.getFilter());
                                    if (!Pattern.matches(regex, name)) continue;
                                    objects.add(this.findIdentityObject(ctx, memberRef));
                                    continue;
                                }
                                objects.add(this.findIdentityObject(ctx, memberRef));
                                continue;
                            }
                            throw new NotYetImplementedException("LDAP limitation. If relationship targets are not refered with FQDNs and only names, it's not possible to map them to proper IdentityType and keep name uniqnes per type. Workaround needed");
                        }
                    }
                } else {
                    objects.addAll(this.findRelatedIdentityObjects(ctx, identity, ldapIO, criteria, false));
                }
            } else if (typeConfig.getChildMembershipAttributeName() == null) {
                objects.addAll(this.findRelatedIdentityObjects(ctx, identity, ldapIO, criteria, true));
            } else {
                attrs = ldapContext.getAttributes(ldapIO.getDn());
                Attribute member = attrs.get(typeConfig.getChildMembershipAttributeName());
                if (member != null) {
                    NamingEnumeration<?> memberValues = member.getAll();
                    while (memberValues.hasMoreElements()) {
                        String memberRef = memberValues.nextElement().toString();
                        if (typeConfig.isChildMembershipAttributeDN()) {
                            if (criteria != null && criteria.getFilter() != null) {
                                String name = Tools.stripDnToName((String)memberRef);
                                String regex = Tools.wildcardToRegex((String)criteria.getFilter());
                                if (!Pattern.matches(regex, name)) continue;
                                objects.add(this.findIdentityObject(ctx, memberRef));
                                continue;
                            }
                            objects.add(this.findIdentityObject(ctx, memberRef));
                            continue;
                        }
                        throw new NotYetImplementedException("LDAP limitation. If relationship targets are not refered with FQDNs and only names, it's not possible to map them to proper IdentityType and keep name uniqnes per type. Workaround needed");
                    }
                }
            }
        }
        catch (NamingException e) {
            throw new IdentityException("Failed to resolve relationship", (Throwable)e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
        if (criteria != null && criteria.isPaged()) {
            objects = this.cutPageFromResults(objects, criteria);
        }
        if (criteria != null && criteria.isSorted()) {
            this.sortByName(objects, criteria.isAscending());
        }
        return objects;
    }

    public List<IdentityObject> findRelatedIdentityObjects(IdentityStoreInvocationContext ctx, IdentityObject identity, LDAPIdentityObjectImpl ldapIO, IdentityObjectSearchCriteria criteria, boolean parents) throws IdentityException, NamingException {
        LinkedList<IdentityObject> objects = new LinkedList<IdentityObject>();
        LDAPIdentityObjectTypeConfiguration typeConfiguration = this.getTypeConfiguration(ctx, identity.getIdentityType());
        List<String> allowedTypes = Arrays.asList(typeConfiguration.getAllowedMembershipTypes());
        for (IdentityObjectType checkedIOType : this.configuration.getConfiguredTypes()) {
            this.checkIOType(checkedIOType);
            LDAPIdentityObjectTypeConfiguration checkedTypeConfiguration = this.getTypeConfiguration(ctx, checkedIOType);
            List<String> checkedAllowedTypes = Arrays.asList(checkedTypeConfiguration.getAllowedMembershipTypes());
            if (!parents ? !allowedTypes.contains(checkedIOType.getName()) : !checkedAllowedTypes.contains(identity.getIdentityType().getName())) continue;
            if (parents && checkedTypeConfiguration.getParentMembershipAttributeName() == null || !parents && checkedTypeConfiguration.getChildMembershipAttributeName() == null) continue;
            String nameFilter = "*";
            if (criteria != null && criteria.getFilter() != null) {
                nameFilter = criteria.getFilter();
            }
            Control[] requestControls = null;
            StringBuilder af = new StringBuilder();
            if (criteria != null && criteria.isFiltered()) {
                af.append("(&");
                for (Map.Entry stringEntry : criteria.getValues().entrySet()) {
                    for (String value : (String[])stringEntry.getValue()) {
                        af.append("(").append((String)stringEntry.getKey()).append("=").append(value).append(")");
                    }
                }
                af.append(")");
            }
            if (parents) {
                af.append("(").append(checkedTypeConfiguration.getParentMembershipAttributeName()).append("=");
                if (checkedTypeConfiguration.isParentMembershipAttributeDN()) {
                    af.append(ldapIO.getDn());
                } else {
                    af.append(ldapIO.getName());
                }
                af.append(")");
            } else {
                af.append("(").append(checkedTypeConfiguration.getChildMembershipAttributeName()).append("=");
                if (checkedTypeConfiguration.isChildMembershipAttributeDN()) {
                    af.append(ldapIO.getDn());
                } else {
                    af.append(ldapIO.getName());
                }
                af.append(")");
            }
            String filter = checkedTypeConfiguration.getEntrySearchFilter();
            List<SearchResult> sr = null;
            String[] entryCtxs = checkedTypeConfiguration.getCtxDNs();
            String scope = checkedTypeConfiguration.getEntrySearchScope();
            if (filter != null && filter.length() > 0) {
                filter = filter.replaceAll("\\{0\\}", nameFilter);
                sr = this.searchIdentityObjects(ctx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", null, new String[]{checkedTypeConfiguration.getIdAttributeName()}, scope, requestControls);
            } else {
                filter = "(".concat(checkedTypeConfiguration.getIdAttributeName()).concat("=").concat(nameFilter).concat(")");
                sr = this.searchIdentityObjects(ctx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", null, new String[]{checkedTypeConfiguration.getIdAttributeName()}, scope, requestControls);
            }
            for (SearchResult res : sr) {
                String placeholder;
                LdapContext ldapCtx = (LdapContext)res.getObject();
                String dn = ldapCtx.getNameInNamespace();
                if (parents && (placeholder = checkedTypeConfiguration.getParentMembershipAttributePlaceholder()) != null && dn.equalsIgnoreCase(placeholder)) continue;
                objects.add(this.createIdentityObjectInstance(ctx, checkedIOType, res.getAttributes(), dn));
            }
        }
        return objects;
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType type, boolean parent, boolean named, String name) throws IdentityException {
        if (type == null || !type.getName().equals(MEMBERSHIP_TYPE)) {
            throw new IdentityException("This store implementation supports only 'JBOSS_IDENTITY_MEMBERSHIP' relationship type");
        }
        LDAPIdentityObjectImpl ldapIO = this.getSafeLDAPIO(ctx, identity);
        LDAPIdentityObjectTypeConfiguration typeConfig = this.getTypeConfiguration(ctx, identity.getIdentityType());
        LdapContext ldapContext = this.getLDAPContext(ctx);
        HashSet<IdentityObjectRelationship> relationships = new HashSet<IdentityObjectRelationship>();
        try {
            Attributes attrs;
            if (parent) {
                attrs = ldapContext.getAttributes(ldapIO.getDn());
                if (typeConfig.getParentMembershipAttributeName() != null) {
                    Attribute member = attrs.get(typeConfig.getParentMembershipAttributeName());
                    if (member != null) {
                        NamingEnumeration<?> memberValues = member.getAll();
                        while (memberValues.hasMoreElements()) {
                            String memberRef = memberValues.nextElement().toString();
                            String placeholder = typeConfig.getParentMembershipAttributePlaceholder();
                            if (placeholder != null && memberRef.equalsIgnoreCase(placeholder)) continue;
                            if (typeConfig.isParentMembershipAttributeDN()) {
                                relationships.add(new LDAPIdentityObjectRelationshipImpl(MEMBERSHIP_TYPE, ldapIO, this.findIdentityObject(ctx, memberRef)));
                                continue;
                            }
                            throw new NotYetImplementedException("LDAP limitation. If relationship targets are not refered with FQDNs and only names, it's not possible to map them to proper IdentityType and keep name uniqnes per type. Workaround needed");
                        }
                    }
                } else {
                    relationships.addAll(this.findRelationships(ctx, identity, ldapIO, false));
                }
            } else {
                attrs = ldapContext.getAttributes(ldapIO.getDn());
                if (typeConfig.getChildMembershipAttributeName() != null) {
                    Attribute member = attrs.get(typeConfig.getChildMembershipAttributeName());
                    if (member != null) {
                        NamingEnumeration<?> memberValues = member.getAll();
                        while (memberValues.hasMoreElements()) {
                            String memberRef = memberValues.nextElement().toString();
                            if (typeConfig.isChildMembershipAttributeDN()) {
                                relationships.add(new LDAPIdentityObjectRelationshipImpl(MEMBERSHIP_TYPE, this.findIdentityObject(ctx, memberRef), ldapIO));
                                continue;
                            }
                            throw new NotYetImplementedException("LDAP limitation. If relationship targets are not refered with FQDNs and only names, it's not possible to map them to proper IdentityType and keep name uniqnes per type. Workaround needed");
                        }
                    }
                } else {
                    relationships.addAll(this.findRelationships(ctx, identity, ldapIO, true));
                }
            }
        }
        catch (NamingException e) {
            throw new IdentityException("Failed to resolve relationship", (Throwable)e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
        return relationships;
    }

    private Collection<LDAPIdentityObjectRelationshipImpl> findRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity, LDAPIdentityObjectImpl ldapIO, boolean parents) throws IdentityException, NamingException {
        HashSet<LDAPIdentityObjectRelationshipImpl> relationships = new HashSet<LDAPIdentityObjectRelationshipImpl>();
        LDAPIdentityObjectTypeConfiguration typeConfiguration = this.getTypeConfiguration(ctx, identity.getIdentityType());
        List<String> allowedTypes = Arrays.asList(typeConfiguration.getAllowedMembershipTypes());
        for (IdentityObjectType checkedIOType : this.configuration.getConfiguredTypes()) {
            this.checkIOType(checkedIOType);
            LDAPIdentityObjectTypeConfiguration checkedTypeConfiguration = this.getTypeConfiguration(ctx, checkedIOType);
            List<String> checkedAllowedTypes = Arrays.asList(checkedTypeConfiguration.getAllowedMembershipTypes());
            if (parents ? !checkedAllowedTypes.contains(identity.getIdentityType().getName()) : !allowedTypes.contains(checkedIOType.getName())) continue;
            String nameFilter = "*";
            Control[] requestControls = null;
            StringBuilder af = new StringBuilder();
            if (parents) {
                af.append("(").append(checkedTypeConfiguration.getParentMembershipAttributeName()).append("=");
                if (checkedTypeConfiguration.isParentMembershipAttributeDN()) {
                    af.append(ldapIO.getDn());
                } else {
                    af.append(ldapIO.getName());
                }
                af.append(")");
            } else {
                af.append("(").append(checkedTypeConfiguration.getChildMembershipAttributeName()).append("=");
                if (checkedTypeConfiguration.isChildMembershipAttributeDN()) {
                    af.append(ldapIO.getDn());
                } else {
                    af.append(ldapIO.getName());
                }
                af.append(")");
            }
            String filter = checkedTypeConfiguration.getEntrySearchFilter();
            List<SearchResult> sr = null;
            String[] entryCtxs = checkedTypeConfiguration.getCtxDNs();
            String scope = checkedTypeConfiguration.getEntrySearchScope();
            if (filter != null && filter.length() > 0) {
                filter = filter.replaceAll("\\{0\\}", nameFilter);
                sr = this.searchIdentityObjects(ctx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", null, new String[]{checkedTypeConfiguration.getIdAttributeName()}, scope, requestControls);
            } else {
                filter = "(".concat(checkedTypeConfiguration.getIdAttributeName()).concat("=").concat(nameFilter).concat(")");
                sr = this.searchIdentityObjects(ctx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", null, new String[]{checkedTypeConfiguration.getIdAttributeName()}, scope, requestControls);
            }
            for (SearchResult res : sr) {
                LdapContext ldapCtx = (LdapContext)res.getObject();
                String dn = ldapCtx.getNameInNamespace();
                if (parents) {
                    String placeholder = checkedTypeConfiguration.getParentMembershipAttributePlaceholder();
                    if (placeholder != null && dn.equalsIgnoreCase(placeholder)) continue;
                    relationships.add(new LDAPIdentityObjectRelationshipImpl(MEMBERSHIP_TYPE, this.createIdentityObjectInstance(ctx, checkedIOType, res.getAttributes(), dn), ldapIO));
                    continue;
                }
                relationships.add(new LDAPIdentityObjectRelationshipImpl(MEMBERSHIP_TYPE, ldapIO, this.createIdentityObjectInstance(ctx, checkedIOType, res.getAttributes(), dn)));
            }
        }
        return relationships;
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent) throws IdentityException {
        return this.findIdentityObject(ctx, identity, relationshipType, parent, null);
    }

    public IdentityObjectRelationship createRelationship(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String name, boolean createNames) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".createRelationship with " + "fromIdentity: " + fromIdentity + "; toIdentity: " + toIdentity + "; relationshipType: " + relationshipType);
        }
        if (relationshipType == null || !relationshipType.getName().equals(MEMBERSHIP_TYPE)) {
            throw new IdentityException("This store implementation supports only 'JBOSS_IDENTITY_MEMBERSHIP' relationship type");
        }
        LDAPIdentityObjectRelationshipImpl relationship = null;
        LDAPIdentityObjectImpl ldapFromIO = this.getSafeLDAPIO(ctx, fromIdentity);
        LDAPIdentityObjectImpl ldapToIO = this.getSafeLDAPIO(ctx, toIdentity);
        LDAPIdentityObjectTypeConfiguration fromTypeConfig = this.getTypeConfiguration(ctx, fromIdentity.getIdentityType());
        LDAPIdentityObjectTypeConfiguration toTypeConfig = this.getTypeConfiguration(ctx, toIdentity.getIdentityType());
        LdapContext ldapContext = this.getLDAPContext(ctx);
        if (!this.getSupportedFeatures().isRelationshipTypeSupported(fromIdentity.getIdentityType(), toIdentity.getIdentityType(), relationshipType)) {
            throw new IdentityException("Relationship not supported. RelationshipType[ " + relationshipType + " ] " + "beetween: [ " + fromIdentity.getIdentityType().getName() + " ] and [ " + toIdentity.getIdentityType().getName() + " ]");
        }
        try {
            BasicAttribute member;
            BasicAttributes attrs = new BasicAttributes(true);
            if (fromTypeConfig.getParentMembershipAttributeName() != null) {
                member = new BasicAttribute(fromTypeConfig.getParentMembershipAttributeName());
                if (fromTypeConfig.isParentMembershipAttributeDN()) {
                    member.add(ldapToIO.getDn());
                } else {
                    member.add(toIdentity.getName());
                }
                attrs.put(member);
                ldapContext.modifyAttributes(ldapFromIO.getDn(), 1, (Attributes)attrs);
            }
            if (toTypeConfig.getChildMembershipAttributeName() != null && !toTypeConfig.isChildMembershipAttributeVirtual()) {
                member = new BasicAttribute(toTypeConfig.getChildMembershipAttributeName());
                if (toTypeConfig.isChildMembershipAttributeDN()) {
                    member.add(ldapFromIO.getDn());
                } else {
                    member.add(fromIdentity.getName());
                }
                attrs.put(member);
                ldapContext.modifyAttributes(ldapToIO.getDn(), 1, (Attributes)attrs);
            }
            relationship = new LDAPIdentityObjectRelationshipImpl(name, ldapFromIO, ldapToIO);
        }
        catch (NamingException e) {
            throw new IdentityException("Failed to create relationship", (Throwable)e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
        return relationship;
    }

    public void removeRelationship(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String name) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".removeRelationship with " + "fromIdentity: " + fromIdentity + "; toIdentity: " + toIdentity + "; relationshipType: " + relationshipType);
        }
        LDAPIdentityObjectImpl ldapFromIO = this.getSafeLDAPIO(ctx, fromIdentity);
        LDAPIdentityObjectImpl ldapToIO = this.getSafeLDAPIO(ctx, toIdentity);
        LDAPIdentityObjectTypeConfiguration fromTypeConfig = this.getTypeConfiguration(ctx, fromIdentity.getIdentityType());
        LDAPIdentityObjectTypeConfiguration toTypeConfig = this.getTypeConfiguration(ctx, toIdentity.getIdentityType());
        if (!Arrays.asList(fromTypeConfig.getAllowedMembershipTypes()).contains(ldapToIO.getIdentityType().getName())) {
            return;
        }
        LdapContext ldapContext = this.getLDAPContext(ctx);
        if (relationshipType != null && !this.getSupportedFeatures().isRelationshipTypeSupported(fromIdentity.getIdentityType(), toIdentity.getIdentityType(), relationshipType)) {
            throw new IdentityException("Relationship not supported");
        }
        try {
            BasicAttribute member;
            BasicAttributes attrs = new BasicAttributes(true);
            if (fromTypeConfig.getParentMembershipAttributeName() != null) {
                member = new BasicAttribute(fromTypeConfig.getParentMembershipAttributeName());
                if (fromTypeConfig.isParentMembershipAttributeDN()) {
                    member.add(ldapToIO.getDn());
                } else {
                    member.add(toIdentity.getName());
                }
                attrs.put(member);
                ldapContext.modifyAttributes(ldapFromIO.getDn(), 3, (Attributes)attrs);
            }
            if (toTypeConfig.getChildMembershipAttributeName() != null && !toTypeConfig.isChildMembershipAttributeVirtual()) {
                member = new BasicAttribute(toTypeConfig.getChildMembershipAttributeName());
                if (toTypeConfig.isChildMembershipAttributeDN()) {
                    member.add(ldapFromIO.getDn());
                } else {
                    member.add(fromIdentity.getName());
                }
                attrs.put(member);
                ldapContext.modifyAttributes(ldapToIO.getDn(), 3, (Attributes)attrs);
            }
        }
        catch (NamingException e) {
            throw new IdentityException("Failed to remove relationship", (Throwable)e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
    }

    public void removeRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity1, IdentityObject identity2, boolean named) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".removeRelationships with " + "identity1: " + identity1 + "; identity2: " + identity2);
        }
        this.removeRelationship(ctx, identity1, identity2, null, null);
        this.removeRelationship(ctx, identity2, identity1, null, null);
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".resolveRelationships with " + "fromIdentity: " + fromIdentity + "; toIdentity: " + toIdentity);
        }
        if (relationshipType != null && !relationshipType.getName().equals(MEMBERSHIP_TYPE)) {
            throw new IdentityException("This store implementation supports only 'JBOSS_IDENTITY_MEMBERSHIP' relationship type");
        }
        HashSet<IdentityObjectRelationship> relationships = new HashSet<IdentityObjectRelationship>();
        LDAPIdentityObjectImpl ldapFromIO = this.getSafeLDAPIO(ctx, fromIdentity);
        LDAPIdentityObjectImpl ldapToIO = this.getSafeLDAPIO(ctx, toIdentity);
        LDAPIdentityObjectTypeConfiguration fromTypeConfig = this.getTypeConfiguration(ctx, fromIdentity.getIdentityType());
        LDAPIdentityObjectTypeConfiguration toTypeConfig = this.getTypeConfiguration(ctx, toIdentity.getIdentityType());
        if (!Arrays.asList(fromTypeConfig.getAllowedMembershipTypes()).contains(ldapToIO.getIdentityType().getName())) {
            return relationships;
        }
        LdapContext ldapContext = this.getLDAPContext(ctx);
        try {
            Attribute member;
            Attributes attrs = ldapContext.getAttributes(ldapFromIO.getDn());
            if (fromTypeConfig.getParentMembershipAttributeName() != null) {
                Attribute member2 = attrs.get(fromTypeConfig.getParentMembershipAttributeName());
                if (member2 != null) {
                    NamingEnumeration<?> memberValues = member2.getAll();
                    while (memberValues.hasMoreElements()) {
                        String memberRef = memberValues.nextElement().toString();
                        if ((!fromTypeConfig.isParentMembershipAttributeDN() || !memberRef.equals(ldapToIO.getDn())) && (fromTypeConfig.isParentMembershipAttributeDN() || !memberRef.equals(ldapToIO.getName()))) continue;
                        relationships.add(new LDAPIdentityObjectRelationshipImpl(MEMBERSHIP_TYPE, ldapFromIO, ldapToIO));
                    }
                }
            } else if (toTypeConfig.getChildMembershipAttributeName() != null && (member = attrs.get(toTypeConfig.getChildMembershipAttributeName())) != null) {
                NamingEnumeration<?> memberValues = member.getAll();
                while (memberValues.hasMoreElements()) {
                    String memberRef = memberValues.nextElement().toString();
                    if ((!fromTypeConfig.isChildMembershipAttributeDN() || !memberRef.equals(ldapFromIO.getDn())) && (fromTypeConfig.isChildMembershipAttributeDN() || !memberRef.equals(ldapFromIO.getName()))) continue;
                    relationships.add(new LDAPIdentityObjectRelationshipImpl(MEMBERSHIP_TYPE, ldapFromIO, ldapToIO));
                }
            }
        }
        catch (NamingException e) {
            throw new IdentityException("Failed to resolve relationship", (Throwable)e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
        return relationships;
    }

    public String createRelationshipName(IdentityStoreInvocationContext invocationCtx, String name) throws IdentityException, OperationNotSupportedException {
        if (name == null) {
            throw new IdentityException("Name cannot be null");
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".createRelationshipName with name: " + name);
        }
        LdapContext ldapContext = this.getLDAPContext(invocationCtx);
        try {
            LdapContext ctx = (LdapContext)ldapContext.lookup(this.getConfiguration(invocationCtx).getRelationshipNamesCtxDNs()[0]);
            BasicAttributes attrs = new BasicAttributes(true);
            Map<String, String[]> attributesToAdd = this.getConfiguration(invocationCtx).getRelationshipNameCreateEntryAttributeValues();
            for (String attributeName : attributesToAdd.keySet()) {
                String[] attributeValues;
                BasicAttribute attr = new BasicAttribute(attributeName);
                for (String attrValue : attributeValues = attributesToAdd.get(attributeName)) {
                    attr.add(attrValue);
                }
                attrs.put(attr);
            }
            LdapName validLDAPName = new LdapName(this.getConfiguration(invocationCtx).getRelationshipNameAttributeName().concat("=").concat(name));
            if (log.isLoggable(Level.FINER)) {
                log.finer("creating ldap entry for: " + validLDAPName + "; " + attrs);
            }
            ctx.createSubcontext(validLDAPName, (Attributes)attrs);
        }
        catch (Exception e) {
            throw new IdentityException("Failed to create relationship name object", (Throwable)e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
        return name;
    }

    public String removeRelationshipName(IdentityStoreInvocationContext invocationCtx, String name) throws IdentityException, OperationNotSupportedException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".removeRelationshipName with name: " + name);
        }
        Context ctx = null;
        try {
            if (name == null) {
                throw new IdentityException("relationship name canot be null");
            }
            String filter = this.getConfiguration(invocationCtx).getRelationshipNameSearchFilter();
            List<SearchResult> sr = null;
            String[] entryCtxs = this.getConfiguration(invocationCtx).getRelationshipNamesCtxDNs();
            String scope = this.getConfiguration(invocationCtx).getRelationshipNameSearchScope();
            if (filter != null && filter.length() > 0) {
                Object[] filterArgs = new Object[]{name};
                sr = this.searchIdentityObjects(invocationCtx, entryCtxs, filter, filterArgs, new String[]{this.getConfiguration(invocationCtx).getRelationshipNameAttributeName()}, scope, null);
            } else {
                filter = "(".concat(this.getConfiguration(invocationCtx).getRelationshipNameAttributeName()).concat("=").concat(name).concat(")");
                sr = this.searchIdentityObjects(invocationCtx, entryCtxs, filter, null, new String[]{this.getConfiguration(invocationCtx).getRelationshipNameAttributeName()}, scope, null);
            }
            if (sr.size() > 1) {
                throw new IdentityException("Found more than one relationship name entry: " + name + "; Posible data inconsistency");
            }
            SearchResult res = sr.iterator().next();
            ctx = (Context)res.getObject();
            String dn = ctx.getNameInNamespace();
            ctx.unbind(dn);
            ctx.close();
            String string = null;
            return string;
        }
        catch (NoSuchElementException e) {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e2) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e2);
            }
        }
        catch (NamingException e) {
            throw new IdentityException("relationship name remove failed.", (Throwable)e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
        return null;
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext invocationCtx, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        String nameFilter = "*";
        if (criteria != null && criteria.getFilter() != null) {
            nameFilter = criteria.getFilter();
        }
        LdapContext ctx = this.getLDAPContext(invocationCtx);
        HashSet<String> names = new HashSet<String>();
        LDAPIdentityStoreConfiguration config = this.getConfiguration(invocationCtx);
        try {
            Control[] requestControls = null;
            StringBuilder af = new StringBuilder();
            String filter = config.getRelationshipNameSearchFilter();
            List<SearchResult> sr = null;
            String[] entryCtxs = config.getRelationshipNamesCtxDNs();
            String scope = config.getRelationshipNameSearchScope();
            if (filter != null && filter.length() > 0) {
                filter = filter.replaceAll("\\{0\\}", nameFilter);
                sr = this.searchIdentityObjects(invocationCtx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", null, new String[]{config.getRelationshipNameAttributeName()}, scope, requestControls);
            } else {
                filter = "(".concat(config.getRelationshipNameAttributeName()).concat("=").concat(nameFilter).concat(")");
                sr = this.searchIdentityObjects(invocationCtx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", null, new String[]{config.getRelationshipNameAttributeName()}, scope, requestControls);
            }
            for (SearchResult res : sr) {
                ctx = (LdapContext)res.getObject();
                String dn = ctx.getNameInNamespace();
                String[] parts = dn.split("=");
                names.add(parts[1]);
            }
            ctx.close();
        }
        catch (NoSuchElementException e) {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e2) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e2);
            }
        }
        catch (Exception e) {
            throw new IdentityException("relationship names search failed.", (Throwable)e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
        return names;
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx) throws IdentityException, OperationNotSupportedException {
        return this.getRelationshipNames(ctx, (IdentityObjectSearchCriteria)null);
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Named relationships are not supported by this implementation of LDAP IdentityStore");
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Named relationships are not supported by this implementation of LDAP IdentityStore");
    }

    public Map<String, String> getRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Named relationships are not supported by this implementation of LDAP IdentityStore");
    }

    public void setRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Named relationships are not supported by this implementation of LDAP IdentityStore");
    }

    public void removeRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Named relationships are not supported by this implementation of LDAP IdentityStore");
    }

    public Map<String, String> getRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Relationship properties are not supported by this implementation of LDAP IdentityStore");
    }

    public void setRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Relationship properties are not supported by this implementation of LDAP IdentityStore");
    }

    public void removeRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Relationship properties are not supported by this implementation of LDAP IdentityStore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        if (credential == null) {
            throw new IllegalArgumentException();
        }
        LDAPIdentityObjectImpl ldapIO = this.getSafeLDAPIO(ctx, identityObject);
        if (this.supportedFeatures.isCredentialSupported(ldapIO.getIdentityType(), credential.getType())) {
            String passwordString = null;
            if (credential.getValue() != null) {
                passwordString = credential.getValue().toString();
                if (passwordString.length() == 0 && !this.getTypeConfiguration(ctx, identityObject.getIdentityType()).isAllowEmptyPassword()) {
                    return false;
                }
            } else {
                if (!this.getTypeConfiguration(ctx, identityObject.getIdentityType()).isAllowEmptyPassword()) {
                    new IdentityException("Null password value");
                }
                passwordString = "";
            }
            LdapContext ldapContext = this.getLDAPContext(ctx);
            try {
                Hashtable<?, ?> env = ldapContext.getEnvironment();
                env.put("java.naming.security.principal", ldapIO.getDn());
                env.put("java.naming.security.credentials", passwordString);
                InitialLdapContext initialCtx = new InitialLdapContext(env, null);
                if (initialCtx != null) {
                    initialCtx.close();
                    boolean bl = true;
                    return bl;
                }
            }
            catch (NamingException e) {
                try {
                    ldapContext.close();
                }
                catch (NamingException e2) {
                    throw new IdentityException("Failed to close LDAP connection", (Throwable)e2);
                }
            }
            finally {
                try {
                    ldapContext.close();
                }
                catch (NamingException e) {
                    throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
                }
            }
            return false;
        }
        throw new IdentityException("CredentialType not supported for a given IdentityObjectType");
    }

    public void updateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        if (credential == null) {
            throw new IllegalArgumentException();
        }
        LDAPIdentityObjectImpl ldapIO = this.getSafeLDAPIO(ctx, identityObject);
        if (this.supportedFeatures.isCredentialSupported(ldapIO.getIdentityType(), credential.getType())) {
            String attributeName;
            String passwordString = null;
            LDAPIdentityObjectTypeConfiguration typeConfig = this.getTypeConfiguration(ctx, identityObject.getIdentityType());
            if (credential.getValue() != null) {
                passwordString = credential.getValue().toString();
                if (passwordString.length() == 0 && !typeConfig.isAllowEmptyPassword()) {
                    new IdentityException("Empty password is not allowed by configuration");
                }
            } else {
                if (!typeConfig.isAllowEmptyPassword()) {
                    new IdentityException("Null password value");
                }
                passwordString = "";
            }
            if (typeConfig.getEnclosePasswordWith() != null) {
                String enc = typeConfig.getEnclosePasswordWith();
                passwordString = enc + passwordString + enc;
            }
            byte[] encodedPassword = null;
            if (typeConfig.getPasswordEncoding() != null) {
                try {
                    encodedPassword = passwordString.getBytes(typeConfig.getPasswordEncoding());
                }
                catch (UnsupportedEncodingException e) {
                    throw new IdentityException("Error while encoding password with configured setting: " + typeConfig.getPasswordEncoding(), (Throwable)e);
                }
            }
            if ((attributeName = this.getTypeConfiguration(ctx, ldapIO.getIdentityType()).getPasswordAttributeName()) == null) {
                throw new IdentityException("IdentityType doesn't have passwordAttributeName option set: " + ldapIO.getIdentityType().getName());
            }
            LdapContext ldapContext = this.getLDAPContext(ctx);
            try {
                BasicAttributes attrs = new BasicAttributes(true);
                BasicAttribute attr = new BasicAttribute(attributeName);
                if (encodedPassword != null) {
                    attr.add(encodedPassword);
                } else {
                    attr.add(passwordString);
                }
                attrs.put(attr);
                if (typeConfig.getUpdatePasswordAttributeValues().size() > 0) {
                    Map<String, String[]> attributesToAdd = typeConfig.getUpdatePasswordAttributeValues();
                    for (Map.Entry<String, String[]> entry : attributesToAdd.entrySet()) {
                        BasicAttribute additionalAttr = new BasicAttribute(entry.getKey());
                        for (String val : entry.getValue()) {
                            additionalAttr.add(val);
                        }
                        attrs.put(additionalAttr);
                    }
                }
                ldapContext.modifyAttributes(ldapIO.getDn(), 2, (Attributes)attrs);
            }
            catch (NamingException e) {
                throw new IdentityException("Cannot set identity password value.", (Throwable)e);
            }
            finally {
                try {
                    ldapContext.close();
                }
                catch (NamingException e) {
                    throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
                }
            }
        }
        throw new IdentityException("CredentialType not supported for a given IdentityObjectType");
    }

    public Set<String> getSupportedAttributeNames(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".getSupportedAttributeNames with " + "identityType: " + identityType);
        }
        this.checkIOType(identityType);
        return this.getTypeConfiguration(invocationContext, identityType).getMappedAttributesNames();
    }

    public Map<String, IdentityObjectAttributeMetaData> getAttributesMetaData(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityObjectType) {
        return this.attributesMetaData.get(identityObjectType.getName());
    }

    public IdentityObjectAttribute getAttribute(IdentityStoreInvocationContext invocationContext, IdentityObject identity, String name) throws IdentityException {
        return this.getAttributes(invocationContext, identity).get(name);
    }

    public Map<String, IdentityObjectAttribute> getAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".getAttributes with " + "identity: " + identity);
        }
        HashMap<String, IdentityObjectAttribute> attrsMap = new HashMap<String, IdentityObjectAttribute>();
        LDAPIdentityObjectImpl ldapIdentity = this.getSafeLDAPIO(ctx, identity);
        LdapContext ldapContext = this.getLDAPContext(ctx);
        try {
            Set<String> mappedNames = this.getTypeConfiguration(ctx, identity.getIdentityType()).getMappedAttributesNames();
            String dn = ldapIdentity.getDn();
            Attributes attrs = ldapContext.getAttributes(dn);
            for (String name : mappedNames) {
                String attrName = this.getTypeConfiguration(ctx, identity.getIdentityType()).getAttributeMapping(name);
                Attribute attr = attrs.get(attrName);
                if (attr != null) {
                    SimpleAttribute identityObjectAttribute = new SimpleAttribute(name);
                    NamingEnumeration<?> values = attr.getAll();
                    while (values.hasMoreElements()) {
                        identityObjectAttribute.addValue((Object)values.nextElement().toString());
                    }
                    attrsMap.put(name, (IdentityObjectAttribute)identityObjectAttribute);
                    continue;
                }
                log.fine("No such attribute ('" + attrName + "') in entry: " + dn);
            }
        }
        catch (NamingException e) {
            throw new IdentityException("Cannot get attributes value.", (Throwable)e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
        return attrsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".updateAttributes with " + "identity: " + identity + "attributes: " + attributes);
        }
        if (attributes == null) {
            throw new IllegalArgumentException("attributes is null");
        }
        LDAPIdentityObjectImpl ldapIdentity = this.getSafeLDAPIO(ctx, identity);
        String dn = ldapIdentity.getDn();
        LdapContext ldapContext = this.getLDAPContext(ctx);
        try {
            for (IdentityObjectAttribute attribute : attributes) {
                String name = attribute.getName();
                String attributeName = this.getTypeConfiguration(ctx, identity.getIdentityType()).getAttributeMapping(name);
                if (attributeName == null) {
                    log.fine("Proper LDAP attribute mapping not found for such property name: " + name);
                    continue;
                }
                BasicAttributes attrs = new BasicAttributes(true);
                BasicAttribute attr = new BasicAttribute(attributeName);
                Collection values = attribute.getValues();
                Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
                if (mdMap != null) {
                    IdentityObject checkIdentity;
                    IdentityObjectAttributeMetaData amd = mdMap.get(attributeName);
                    if (amd != null && !amd.isMultivalued() && values.size() > 1) {
                        throw new IdentityException("Cannot assigned multiply values to single valued attribute: " + attributeName);
                    }
                    if (amd != null && amd.isReadonly()) {
                        throw new IdentityException("Cannot update readonly attribute: " + attributeName);
                    }
                    if (amd != null && amd.isUnique() && (checkIdentity = this.findIdentityObjectByUniqueAttribute(ctx, identity.getIdentityType(), attribute)) != null && !checkIdentity.getName().equals(identity.getName())) {
                        throw new IdentityException("Unique attribute '" + attribute.getName() + " value already set for identityObject: " + checkIdentity);
                    }
                }
                if (values == null) continue;
                for (Object value : values) {
                    attr.add(value);
                }
                attrs.put(attr);
                try {
                    ldapContext.modifyAttributes(dn, 2, (Attributes)attrs);
                }
                catch (NamingException e) {
                    throw new IdentityException("Cannot add attribute", (Throwable)e);
                }
            }
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".addAttributes with " + "identity: " + identity + "attributes: " + attributes);
        }
        if (attributes == null) {
            throw new IllegalArgumentException("attributes is null");
        }
        LDAPIdentityObjectImpl ldapIdentity = this.getSafeLDAPIO(ctx, identity);
        String dn = ldapIdentity.getDn();
        LdapContext ldapContext = this.getLDAPContext(ctx);
        try {
            for (IdentityObjectAttribute attribute : attributes) {
                String name = attribute.getName();
                String attributeName = this.getTypeConfiguration(ctx, identity.getIdentityType()).getAttributeMapping(name);
                if (attributeName == null) {
                    log.fine("Proper LDAP attribute mapping not found for such property name: " + name);
                    continue;
                }
                BasicAttributes attrs = new BasicAttributes(true);
                BasicAttribute attr = new BasicAttribute(attributeName);
                Collection values = attribute.getValues();
                Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
                if (mdMap != null) {
                    IdentityObject checkIdentity;
                    IdentityObjectAttributeMetaData amd = mdMap.get(attribute.getName());
                    if (amd != null && !amd.isMultivalued() && values.size() > 1) {
                        throw new IdentityException("Cannot assigned multiply values to single valued attribute: " + attributeName);
                    }
                    if (amd != null && amd.isReadonly()) {
                        throw new IdentityException("Cannot update readonly attribute: " + attributeName);
                    }
                    if (amd != null && amd.isUnique() && (checkIdentity = this.findIdentityObjectByUniqueAttribute(ctx, identity.getIdentityType(), attribute)) != null && !checkIdentity.getName().equals(identity.getName())) {
                        throw new IdentityException("Unique attribute '" + attribute.getName() + " value already set for identityObject: " + checkIdentity);
                    }
                }
                if (values == null) continue;
                for (Object value : values) {
                    attr.add(value);
                }
                attrs.put(attr);
                try {
                    ldapContext.modifyAttributes(dn, 1, (Attributes)attrs);
                }
                catch (NamingException e) {
                    throw new IdentityException("Cannot add attribute", (Throwable)e);
                }
            }
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, String[] attributeNames) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".removeAttributes with " + "identity: " + identity + "attributeNames: " + attributeNames);
        }
        if (attributeNames == null) {
            throw new IllegalArgumentException("attributes is null");
        }
        LDAPIdentityObjectImpl ldapIdentity = this.getSafeLDAPIO(ctx, identity);
        String dn = ldapIdentity.getDn();
        LdapContext ldapContext = this.getLDAPContext(ctx);
        try {
            for (String name : attributeNames) {
                IdentityObjectAttributeMetaData amd;
                String attributeName = this.getTypeConfiguration(ctx, identity.getIdentityType()).getAttributeMapping(name);
                if (attributeName == null) {
                    log.fine("Proper LDAP attribute mapping not found for such property name: " + name);
                    continue;
                }
                Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
                if (mdMap != null && (amd = mdMap.get(name)) != null && amd.isRequired()) {
                    throw new IdentityException("Cannot remove required attribute: " + name);
                }
                BasicAttributes attrs = new BasicAttributes(true);
                BasicAttribute attr = new BasicAttribute(attributeName);
                attrs.put(attr);
                try {
                    ldapContext.modifyAttributes(dn, 3, (Attributes)attrs);
                }
                catch (NamingException e) {
                    throw new IdentityException("Cannot remove attribute", (Throwable)e);
                }
            }
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
    }

    public IdentityObject findIdentityObjectByUniqueAttribute(IdentityStoreInvocationContext invocationCtx, IdentityObjectType type, IdentityObjectAttribute attribute) throws IdentityException {
        String nameFilter = "*";
        LdapContext ctx = this.getLDAPContext(invocationCtx);
        this.checkIOType(type);
        LinkedList<LDAPIdentityObjectImpl> objects = new LinkedList<LDAPIdentityObjectImpl>();
        LDAPIdentityObjectTypeConfiguration typeConfiguration = this.getTypeConfiguration(invocationCtx, type);
        String attributeName = this.getTypeConfiguration(invocationCtx, type).getAttributeMapping(attribute.getName());
        try {
            Control[] requestControls = null;
            StringBuilder af = new StringBuilder();
            af.append("(").append(attributeName).append("=").append(attribute.getValue()).append(")");
            String filter = this.getTypeConfiguration(invocationCtx, type).getEntrySearchFilter();
            List<SearchResult> sr = null;
            String[] entryCtxs = this.getTypeConfiguration(invocationCtx, type).getCtxDNs();
            String scope = this.getTypeConfiguration(invocationCtx, type).getEntrySearchScope();
            if (filter != null && filter.length() > 0) {
                filter = filter.replaceAll("\\{0\\}", nameFilter);
                sr = this.searchIdentityObjects(invocationCtx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", null, new String[]{typeConfiguration.getIdAttributeName()}, scope, requestControls);
            } else {
                filter = "(".concat(typeConfiguration.getIdAttributeName()).concat("=").concat(nameFilter).concat(")");
                sr = this.searchIdentityObjects(invocationCtx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", null, new String[]{typeConfiguration.getIdAttributeName()}, scope, requestControls);
            }
            for (SearchResult res : sr) {
                ctx = (LdapContext)res.getObject();
                String dn = ctx.getNameInNamespace();
                objects.add(this.createIdentityObjectInstance(invocationCtx, type, res.getAttributes(), dn));
            }
            ctx.close();
        }
        catch (NoSuchElementException e) {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e2) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e2);
            }
        }
        catch (Exception e) {
            throw new IdentityException("IdentityObject search failed.", (Throwable)e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
        if (objects.size() == 0) {
            return null;
        }
        if (objects.size() > 1) {
            throw new IdentityException("Illegal state - more than one IdentityObject of same type share same unique attribute value");
        }
        return (IdentityObject)objects.get(0);
    }

    public LDAPIdentityObjectImpl createIdentityObjectInstance(IdentityStoreInvocationContext ctx, IdentityObjectType type, Attributes attrs, String dn) throws IdentityException {
        LDAPIdentityObjectImpl ldapio = null;
        try {
            String idAttrName = this.getTypeConfiguration(ctx, type).getIdAttributeName();
            Attribute ida = attrs.get(idAttrName);
            if (ida == null) {
                throw new IdentityException("LDAP entry doesn't contain proper attribute:" + idAttrName);
            }
            ldapio = new LDAPIdentityObjectImpl(dn, ida.get().toString(), type);
        }
        catch (Exception e) {
            throw new IdentityException("Couldn't create LDAPIdentityObjectImpl object from ldap entry (SearchResult)", (Throwable)e);
        }
        return ldapio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchResult> searchIdentityObjects(IdentityStoreInvocationContext ctx, String[] entryCtxs, String filter, Object[] filterArgs, String[] returningAttributes, String searchScope, Control[] requestControls) throws NamingException, IdentityException {
        LdapContext ldapContext;
        if (log.isLoggable(Level.FINER)) {
            StringBuffer sb = new StringBuffer();
            sb.append("Prepared LDAP Search ");
            if (entryCtxs != null) {
                sb.append("; contexts: ").append(Arrays.toString(entryCtxs));
            }
            if (filter != null) {
                sb.append("; filter: ").append(filter);
            }
            if (filterArgs != null) {
                sb.append("; filter args: ").append(Arrays.toString(filterArgs));
            }
            if (returningAttributes != null) {
                sb.append("; returning attributes: ").append(Arrays.toString(returningAttributes));
            }
            if (searchScope != null) {
                sb.append("; searchScope: ").append(searchScope);
            }
            log.finer(sb.toString());
        }
        if ((ldapContext = this.getLDAPContext(ctx)) != null) {
            ldapContext.setRequestControls(requestControls);
        }
        NamingEnumeration<SearchResult> results = null;
        try {
            SearchControls searchControls = new SearchControls();
            if (searchScope != null) {
                if (searchScope.equalsIgnoreCase("subtree")) {
                    searchControls.setSearchScope(2);
                } else if (searchScope.equalsIgnoreCase("object")) {
                    searchControls.setSearchScope(0);
                }
            }
            searchControls.setReturningObjFlag(true);
            searchControls.setTimeLimit(this.getConfiguration(ctx).getSearchTimeLimit());
            if (returningAttributes != null) {
                searchControls.setReturningAttributes(returningAttributes);
            }
            if (entryCtxs.length == 1) {
                results = filterArgs == null ? ldapContext.search(entryCtxs[0], filter, searchControls) : ldapContext.search(entryCtxs[0], filter, filterArgs, searchControls);
                List toReturn = Tools.toList(results);
                if (log.isLoggable(Level.FINER) && toReturn != null) {
                    log.finer("Search in " + entryCtxs[0] + " returned " + toReturn.size() + " entries");
                }
                List list = toReturn;
                return list;
            }
            LinkedList<SearchResult> merged = new LinkedList<SearchResult>();
            for (String entryCtx : entryCtxs) {
                results = filterArgs == null ? ldapContext.search(entryCtx, filter, searchControls) : ldapContext.search(entryCtx, filter, filterArgs, searchControls);
                List singleResult = Tools.toList(results);
                if (log.isLoggable(Level.FINER) && merged != null) {
                    log.finer("Search in " + entryCtx + " returned " + merged.size() + " entries");
                }
                merged.addAll(singleResult);
                results.close();
            }
            LinkedList<SearchResult> linkedList = merged;
            return linkedList;
        }
        finally {
            if (results != null) {
                results.close();
            }
            ldapContext.close();
        }
    }

    private LDAPIdentityObjectImpl getSafeLDAPIO(IdentityStoreInvocationContext ctx, IdentityObject io) throws IdentityException {
        if (io == null) {
            throw new IllegalArgumentException("IdentityObject is null");
        }
        if (io instanceof LDAPIdentityObjectImpl) {
            return (LDAPIdentityObjectImpl)io;
        }
        try {
            return (LDAPIdentityObjectImpl)this.findIdentityObject(ctx, io.getName(), io.getIdentityType());
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Failed to find IdentityObject in LDAP: " + io);
            }
            throw new IdentityException("Provided IdentityObject is not present in the store. Cannot operate on not stored objects.", (Throwable)e);
        }
    }

    private void checkIOType(IdentityObjectType iot) throws IdentityException {
        if (iot == null) {
            throw new IllegalArgumentException("IdentityObjectType is null");
        }
        if (!this.getSupportedFeatures().isIdentityObjectTypeSupported(iot)) {
            throw new IdentityException("IdentityType not supported by this IdentityStore implementation: " + iot);
        }
    }

    private LdapContext getLDAPContext(IdentityStoreInvocationContext ctx) throws IdentityException {
        LdapContext ldapContext = null;
        try {
            ldapContext = (LdapContext)ctx.getIdentityStoreSession().getSessionContext();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Failed to obtain LDAP connection!");
            }
            throw new IdentityException("Could not obtain LDAP connection: ", (Throwable)e);
        }
        if (ldapContext == null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Failed to obtain LDAP connection!");
            }
            throw new IdentityException("IllegalState: - Could not obtain LDAP connection");
        }
        return ldapContext;
    }

    private LDAPIdentityStoreConfiguration getConfiguration(IdentityStoreInvocationContext ctx) throws IdentityException {
        return this.configuration;
    }

    private LDAPIdentityObjectTypeConfiguration getTypeConfiguration(IdentityStoreInvocationContext ctx, IdentityObjectType type) throws IdentityException {
        return this.getConfiguration(ctx).getTypeConfiguration(type.getName());
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getId() + "]";
    }

    private void sortByName(List<IdentityObject> objects, final boolean ascending) {
        Collections.sort(objects, new Comparator<IdentityObject>(){

            @Override
            public int compare(IdentityObject o1, IdentityObject o2) {
                if (ascending) {
                    return o1.getName().compareTo(o2.getName());
                }
                return o2.getName().compareTo(o1.getName());
            }
        });
    }

    private <T> List<T> cutPageFromResults(List<T> objects, IdentityObjectSearchCriteria criteria) {
        LinkedList<T> results = new LinkedList<T>();
        if (criteria.getMaxResults() == 0) {
            for (int i = criteria.getFirstResult(); i < objects.size(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        } else {
            for (int i = criteria.getFirstResult(); i < criteria.getFirstResult() + criteria.getMaxResults(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCtx(DirContext ctx, String dn) throws Exception {
        String[] parts = dn.split(",");
        int l = 0;
        for (int r = parts.length - 1; l < r; ++l, --r) {
            String temp = parts[l];
            parts[l] = parts[r];
            parts[r] = temp;
        }
        String rootDN = "";
        Context root = null;
        for (String part : parts) {
            rootDN = rootDN.length() > 0 ? part + "," + rootDN : part;
            try {
                root = (DirContext)ctx.lookup(rootDN);
            }
            catch (NamingException e) {
                // empty catch block
            }
            if (root != null) break;
        }
        Context dx = root;
        String parsedDN = "";
        try {
            for (String part : parts) {
                if ((parsedDN = parsedDN.length() > 0 ? part + "," + parsedDN : part).length() <= rootDN.length()) continue;
                dx = this.obtainOrCreateContext((DirContext)dx, part);
            }
        }
        finally {
            if (dx != null) {
                dx.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DirContext obtainOrCreateContext(DirContext ctx, String dn) throws Exception {
        if (ctx == null) {
            throw new IllegalArgumentException("DirContext is null");
        }
        if (dn == null || dn.length() == 0 || !dn.contains("=")) {
            throw new IllegalArgumentException("DN doens't have proper format: " + dn);
        }
        DirContext subContext = null;
        try {
            subContext = (LdapContext)ctx.lookup(dn);
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (subContext != null) {
            ctx.close();
            return subContext;
        }
        BasicAttributes attrs = new BasicAttributes(true);
        String[] parts = dn.split("=");
        BasicAttribute attr = new BasicAttribute(parts[0]);
        attr.add(parts[1]);
        attrs.put(attr);
        attr = new BasicAttribute("objectClass");
        attr.add("top");
        if (parts[0].equalsIgnoreCase("dc")) {
            attr.add("dcObject");
        } else if (parts[0].equalsIgnoreCase("o")) {
            attr.add("organization");
        } else if (parts[0].equalsIgnoreCase("ou")) {
            attr.add("organizationalUnit");
        } else if (parts[0].equalsIgnoreCase("cn")) {
            attr.add("organizationalRole");
        } else if (parts[0].equalsIgnoreCase("c")) {
            attr.add("country");
        }
        attrs.put(attr);
        try {
            subContext = ctx.createSubcontext(dn, (Attributes)attrs);
        }
        finally {
            ctx.close();
        }
        return subContext;
    }
}

