/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;
import org.picketlink.idm.impl.api.session.managers.RoleManagerImpl;
import org.picketlink.idm.impl.repository.AbstractIdentityStoreRepository;
import org.picketlink.idm.impl.repository.RepositoryIdentityStoreSessionImpl;
import org.picketlink.idm.impl.store.SimpleIdentityStoreInvocationContext;
import org.picketlink.idm.impl.types.SimpleIdentityObject;
import org.picketlink.idm.spi.configuration.IdentityRepositoryConfigurationContext;
import org.picketlink.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityRepositoryConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreMappingMetaData;
import org.picketlink.idm.spi.exception.OperationNotSupportedException;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;
import org.picketlink.idm.spi.model.IdentityObjectCredential;
import org.picketlink.idm.spi.model.IdentityObjectCredentialType;
import org.picketlink.idm.spi.model.IdentityObjectRelationship;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.search.IdentityObjectSearchCriteria;
import org.picketlink.idm.spi.store.AttributeStore;
import org.picketlink.idm.spi.store.FeaturesMetaData;
import org.picketlink.idm.spi.store.IdentityObjectSearchCriteriaType;
import org.picketlink.idm.spi.store.IdentityStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.store.IdentityStoreSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FallbackIdentityStoreRepository
extends AbstractIdentityStoreRepository {
    private static Logger log = Logger.getLogger(FallbackIdentityStoreRepository.class.getName());
    public static final String OPTION_READ_ONLY = "readOnly";
    private final String id;
    private IdentityRepositoryConfigurationMetaData configurationMD;
    public static final String ALLOW_NOT_DEFINED_ATTRIBUTES = "allowNotDefinedAttributes";
    private FeaturesMetaData featuresMetaData;
    private boolean allowNotDefinedAttributes = false;
    private final Set<IdentityStore> configuredIdentityStores = new HashSet<IdentityStore>();

    public FallbackIdentityStoreRepository(String id) {
        this.id = id;
    }

    @Override
    public void bootstrap(IdentityRepositoryConfigurationContext configurationContext, Map<String, IdentityStore> bootstrappedIdentityStores, Map<String, AttributeStore> bootstrappedAttributeStores) throws IdentityException {
        String allowNotDefineAttributes;
        super.bootstrap(configurationContext, bootstrappedIdentityStores, bootstrappedAttributeStores);
        if (this.getIdentityStoreMappings().size() > 0) {
            this.configuredIdentityStores.addAll(this.getIdentityStoreMappings().values());
        }
        this.configurationMD = configurationContext.getRepositoryConfigurationMetaData();
        String isId = this.configurationMD.getDefaultIdentityStoreId();
        if (isId != null && bootstrappedIdentityStores.keySet().contains(isId) && !this.getIdentityStoreMappings().keySet().contains(this.defaultIdentityStore.getId())) {
            this.configuredIdentityStores.add(this.defaultIdentityStore);
        }
        if ((allowNotDefineAttributes = this.configurationMD.getOptionSingleValue(ALLOW_NOT_DEFINED_ATTRIBUTES)) != null && allowNotDefineAttributes.equalsIgnoreCase("true")) {
            this.allowNotDefinedAttributes = true;
        }
        this.featuresMetaData = new FeaturesMetaData(){

            public boolean isNamedRelationshipsSupported() {
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported()) continue;
                    return true;
                }
                return FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isNamedRelationshipsSupported();
            }

            public boolean isRelationshipPropertiesSupported() {
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    if (!identityStore.getSupportedFeatures().isRelationshipPropertiesSupported()) continue;
                    return true;
                }
                return FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isRelationshipPropertiesSupported();
            }

            public boolean isSearchCriteriaTypeSupported(IdentityObjectType identityObjectType, IdentityObjectSearchCriteriaType storeSearchConstraint) {
                return FallbackIdentityStoreRepository.this.resolveIdentityStore(identityObjectType).getSupportedFeatures().isSearchCriteriaTypeSupported(identityObjectType, storeSearchConstraint);
            }

            public Set<String> getSupportedIdentityObjectTypes() {
                HashSet<String> supportedIOTs = new HashSet<String>();
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    supportedIOTs.addAll(identityStore.getSupportedFeatures().getSupportedIdentityObjectTypes());
                }
                supportedIOTs.addAll(FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().getSupportedRelationshipTypes());
                return supportedIOTs;
            }

            public boolean isIdentityObjectTypeSupported(IdentityObjectType identityObjectType) {
                return FallbackIdentityStoreRepository.this.resolveIdentityStore(identityObjectType).getSupportedFeatures().isIdentityObjectTypeSupported(identityObjectType);
            }

            public boolean isRelationshipTypeSupported(IdentityObjectType fromType, IdentityObjectType toType, IdentityObjectRelationshipType relationshipType) throws IdentityException {
                IdentityStore toStore;
                IdentityStore fromStore = FallbackIdentityStoreRepository.this.resolveIdentityStore(fromType);
                if (fromStore == (toStore = FallbackIdentityStoreRepository.this.resolveIdentityStore(toType))) {
                    return fromStore.getSupportedFeatures().isRelationshipTypeSupported(fromType, toType, relationshipType);
                }
                return FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isRelationshipTypeSupported(fromType, toType, relationshipType);
            }

            public Set<String> getSupportedRelationshipTypes() {
                HashSet<String> supportedRelTypes = new HashSet<String>();
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    supportedRelTypes.addAll(identityStore.getSupportedFeatures().getSupportedRelationshipTypes());
                }
                supportedRelTypes.addAll(FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().getSupportedRelationshipTypes());
                return supportedRelTypes;
            }

            public boolean isCredentialSupported(IdentityObjectType identityObjectType, IdentityObjectCredentialType credentialType) {
                return FallbackIdentityStoreRepository.this.resolveIdentityStore(identityObjectType).getSupportedFeatures().isCredentialSupported(identityObjectType, credentialType);
            }

            public boolean isIdentityObjectAddRemoveSupported(IdentityObjectType objectType) {
                return FallbackIdentityStoreRepository.this.resolveIdentityStore(objectType).getSupportedFeatures().isIdentityObjectAddRemoveSupported(objectType);
            }

            public boolean isRelationshipNameAddRemoveSupported() {
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    if (!identityStore.getSupportedFeatures().isRelationshipNameAddRemoveSupported()) continue;
                    return true;
                }
                return FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isRelationshipNameAddRemoveSupported();
            }

            public boolean isRoleNameSearchCriteriaTypeSupported(IdentityObjectSearchCriteriaType constraint) {
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported() || !identityStore.getSupportedFeatures().isRoleNameSearchCriteriaTypeSupported(constraint)) continue;
                    return true;
                }
                return FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isNamedRelationshipsSupported() && FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isRoleNameSearchCriteriaTypeSupported(constraint);
            }
        };
    }

    public void bootstrap(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
    }

    public IdentityStoreSession createIdentityStoreSession() throws IdentityException {
        HashMap<String, IdentityStoreSession> sessions = new HashMap<String, IdentityStoreSession>();
        for (IdentityStore identityStore : this.identityStoreMappings.values()) {
            sessions.put(identityStore.getId(), identityStore.createIdentityStoreSession());
        }
        for (AttributeStore attributeStore : this.attributeStoreMappings.values()) {
            if (sessions.containsKey(attributeStore.getId())) continue;
            sessions.put(attributeStore.getId(), attributeStore.createIdentityStoreSession());
        }
        if (!sessions.containsKey(this.defaultAttributeStore.getId())) {
            sessions.put(this.defaultAttributeStore.getId(), this.defaultAttributeStore.createIdentityStoreSession());
        }
        if (!sessions.containsKey(this.defaultIdentityStore.getId())) {
            sessions.put(this.defaultIdentityStore.getId(), this.defaultIdentityStore.createIdentityStoreSession());
        }
        return new RepositoryIdentityStoreSessionImpl(sessions);
    }

    public String getId() {
        return this.id;
    }

    public FeaturesMetaData getSupportedFeatures() {
        return this.featuresMetaData;
    }

    IdentityStore resolveIdentityStore(IdentityObject io) throws IdentityException {
        return this.resolveIdentityStore(io.getIdentityType());
    }

    IdentityStore resolveIdentityStore(IdentityObjectType iot) {
        IdentityStore ids = null;
        try {
            ids = this.getIdentityStore(iot);
        }
        catch (IdentityException e) {
            if (this.isAllowNotDefinedAttributes()) {
                return this.defaultIdentityStore;
            }
            throw new IllegalStateException("Used IdentityObjectType not mapped. Consider using allowNotDefinedIdentityObjectTypes repository option switch: " + iot);
        }
        if (ids == null) {
            ids = this.defaultIdentityStore;
        }
        return ids;
    }

    AttributeStore resolveAttributeStore(IdentityObjectType iot) {
        AttributeStore ads = null;
        try {
            ads = this.getAttributeStore(iot);
        }
        catch (IdentityException e) {
            if (this.isAllowNotDefinedAttributes()) {
                return this.defaultAttributeStore;
            }
            throw new IllegalStateException("Used IdentityObjectType not mapped. Consider using allowNotDefinedIdentityObjectTypes repository option switch: " + iot);
        }
        if (ads == null) {
            ads = this.defaultAttributeStore;
        }
        return ads;
    }

    IdentityStoreInvocationContext resolveInvocationContext(IdentityStore targetStore, IdentityStoreInvocationContext invocationCtx) {
        return this.resolveInvocationContext(targetStore.getId(), invocationCtx);
    }

    IdentityStoreInvocationContext resolveInvocationContext(AttributeStore targetStore, IdentityStoreInvocationContext invocationCtx) {
        return this.resolveInvocationContext(targetStore.getId(), invocationCtx);
    }

    IdentityStoreInvocationContext resolveInvocationContext(String id, IdentityStoreInvocationContext invocationCtx) {
        RepositoryIdentityStoreSessionImpl repoSession = (RepositoryIdentityStoreSessionImpl)invocationCtx.getIdentityStoreSession();
        IdentityStoreSession targetSession = repoSession.getIdentityStoreSession(id);
        return new SimpleIdentityStoreInvocationContext(targetSession, invocationCtx.getRealmId(), String.valueOf(this.hashCode()));
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType) throws IdentityException {
        IdentityObject result;
        block4: {
            IdentityStore targetStore = this.resolveIdentityStore(identityObjectType);
            IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
            IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCtx);
            SimpleIdentityObject mock = new SimpleIdentityObject(name, identityObjectType);
            if (targetStore != this.defaultIdentityStore && this.hasIdentityObject(defaultCtx, this.defaultIdentityStore, mock)) {
                return mock;
            }
            if (this.isIdentityStoreReadOnly(targetStore)) {
                targetStore = this.defaultIdentityStore;
                targetCtx = defaultCtx;
            }
            result = null;
            try {
                result = targetStore.createIdentityObject(targetCtx, name, identityObjectType);
            }
            catch (IdentityException e) {
                if (!log.isLoggable(Level.INFO)) break block4;
                log.info("Failed to create IdentityObject: " + (Object)((Object)e));
            }
        }
        return result;
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType, Map<String, String[]> attributes) throws IdentityException {
        IdentityObject result;
        block4: {
            IdentityStore targetStore = this.resolveIdentityStore(identityObjectType);
            IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
            IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCtx);
            SimpleIdentityObject mock = new SimpleIdentityObject(name, identityObjectType);
            if (targetStore != this.defaultIdentityStore && this.hasIdentityObject(defaultCtx, this.defaultIdentityStore, mock)) {
                return mock;
            }
            if (this.isIdentityStoreReadOnly(targetStore)) {
                targetStore = this.defaultIdentityStore;
                targetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCtx);
            }
            result = null;
            try {
                result = targetStore.createIdentityObject(targetCtx, name, identityObjectType, attributes);
            }
            catch (IdentityException e) {
                if (!log.isLoggable(Level.INFO)) break block4;
                log.info("Failed to create IdentityObject: " + (Object)((Object)e));
            }
        }
        return result;
    }

    public void removeIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObject identity) throws IdentityException {
        block3: {
            IdentityStore targetStore = this.resolveIdentityStore(identity);
            IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
            if (this.isIdentityStoreReadOnly(targetStore)) {
                targetStore = this.defaultIdentityStore;
                targetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCtx);
            }
            try {
                targetStore.removeIdentityObject(targetCtx, identity);
            }
            catch (IdentityException e) {
                if (!log.isLoggable(Level.INFO)) break block3;
                log.info("Failed to remove IdentityObject: " + (Object)((Object)e));
            }
        }
    }

    public int getIdentityObjectsCount(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityType) throws IdentityException {
        int result;
        block2: {
            IdentityStore targetStore = this.resolveIdentityStore(identityType);
            IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
            result = 0;
            try {
                result = targetStore.getIdentityObjectsCount(targetCtx, identityType);
            }
            catch (IdentityException e) {
                if (!log.isLoggable(Level.FINER)) break block2;
                log.finer("Failed to obtain IdentityObject count: " + (Object)((Object)e));
            }
        }
        return result;
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String name, IdentityObjectType identityObjectType) throws IdentityException {
        IdentityObject io;
        block6: {
            IdentityStoreInvocationContext targetCtx;
            IdentityStore targetStore;
            block5: {
                targetStore = this.resolveIdentityStore(identityObjectType);
                targetCtx = this.resolveInvocationContext(targetStore, invocationContext);
                io = null;
                try {
                    io = targetStore.findIdentityObject(targetCtx, name, identityObjectType);
                }
                catch (IdentityException e) {
                    if (!log.isLoggable(Level.INFO)) break block5;
                    log.info("Failed to create IdentityObject: " + (Object)((Object)e));
                }
            }
            if (io != null) {
                return io;
            }
            targetStore = this.defaultIdentityStore;
            targetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationContext);
            try {
                io = targetStore.findIdentityObject(targetCtx, name, identityObjectType);
            }
            catch (IdentityException e) {
                if (!log.isLoggable(Level.INFO)) break block6;
                log.info("Failed to create IdentityObject: " + (Object)((Object)e));
            }
        }
        return io;
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String id) throws IdentityException {
        for (IdentityStore identityStore : this.getIdentityStoreMappings().values()) {
            IdentityStoreInvocationContext targetCtx;
            IdentityObject io = identityStore.findIdentityObject(targetCtx = this.resolveInvocationContext(identityStore, invocationContext), id);
            if (io == null) continue;
            return io;
        }
        return this.defaultIdentityStore.findIdentityObject(invocationContext, id);
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityType, IdentityObjectSearchCriteria criteria) throws IdentityException {
        IdentityStore targetStore = this.resolveIdentityStore(identityType);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
        Collection<Object> results = new LinkedList();
        Collection defaultIOs = new LinkedList();
        if (targetStore == this.defaultIdentityStore) {
            return targetStore.findIdentityObject(targetCtx, identityType, criteria);
        }
        IdentitySearchCriteriaImpl c = null;
        if (criteria != null) {
            c = new IdentitySearchCriteriaImpl(criteria);
            c.setPaged(false);
        }
        if ((defaultIOs = this.defaultIdentityStore.findIdentityObject(this.resolveInvocationContext(this.defaultIdentityStore, invocationCtx), identityType, (IdentityObjectSearchCriteria)c)).size() == 0) {
            return targetStore.findIdentityObject(targetCtx, identityType, criteria);
        }
        results = targetStore.findIdentityObject(targetCtx, identityType, (IdentityObjectSearchCriteria)c);
        HashSet merged = new HashSet();
        merged.addAll(results);
        merged.addAll(defaultIOs);
        if (criteria != null) {
            LinkedList<IdentityObject> processed = new LinkedList<IdentityObject>(merged);
            if (criteria.isSorted()) {
                this.sortByName(processed, criteria.isAscending());
            }
            results = processed;
            if (criteria.isPaged()) {
                results = this.cutPageFromResults(processed, criteria);
            }
        } else {
            results = merged;
        }
        return results;
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCxt, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        Collection objects;
        IdentityStore mappedStore = this.resolveIdentityStore(identity);
        IdentityStoreInvocationContext mappedCtx = this.resolveInvocationContext(mappedStore, invocationCxt);
        IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCxt);
        if (mappedStore == this.defaultIdentityStore) {
            return this.defaultIdentityStore.findIdentityObject(defaultCtx, identity, relationshipType, parent, criteria);
        }
        IdentitySearchCriteriaImpl c = null;
        if (criteria != null) {
            c = new IdentitySearchCriteriaImpl(criteria);
            c.setPaged(false);
        }
        Collection<Object> results = new LinkedList<IdentityObject>();
        if (this.hasIdentityObject(mappedCtx, mappedStore, identity) && (relationshipType == null || !RoleManagerImpl.ROLE.getName().equals(relationshipType.getName()) || mappedStore.getSupportedFeatures().isNamedRelationshipsSupported())) {
            if (this.hasIdentityObject(defaultCtx, this.defaultIdentityStore, identity)) {
                results = mappedStore.findIdentityObject(mappedCtx, identity, relationshipType, parent, (IdentityObjectSearchCriteria)c);
            } else {
                return mappedStore.findIdentityObject(mappedCtx, identity, relationshipType, parent, criteria);
            }
        }
        if ((objects = this.defaultIdentityStore.findIdentityObject(defaultCtx, identity, relationshipType, parent, (IdentityObjectSearchCriteria)c)) != null && objects.size() != 0) {
            HashSet<IdentityObject> merged = new HashSet<IdentityObject>();
            merged.addAll(results);
            merged.addAll(objects);
            if (criteria != null) {
                LinkedList<IdentityObject> processed = new LinkedList<IdentityObject>(merged);
                if (criteria.isSorted()) {
                    this.sortByName(processed, criteria.isAscending());
                }
                results = processed;
                if (criteria.isPaged()) {
                    results = this.cutPageFromResults(processed, criteria);
                }
            } else {
                results = merged;
            }
        }
        return results;
    }

    public IdentityObjectRelationship createRelationship(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String relationshipName, boolean createNames) throws IdentityException {
        IdentityStore fromStore = this.resolveIdentityStore(fromIdentity);
        IdentityStore toStore = this.resolveIdentityStore(toIdentity);
        IdentityStoreInvocationContext toTargetCtx = this.resolveInvocationContext(toStore, invocationCxt);
        IdentityStoreInvocationContext defaultTargetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCxt);
        if (fromStore == toStore && !this.isIdentityStoreReadOnly(fromStore) && this.hasIdentityObject(toTargetCtx, fromStore, fromIdentity) && this.hasIdentityObject(toTargetCtx, fromStore, toIdentity) && (relationshipName == null || relationshipName != null && fromStore.getSupportedFeatures().isNamedRelationshipsSupported())) {
            return fromStore.createRelationship(toTargetCtx, fromIdentity, toIdentity, relationshipType, relationshipName, createNames);
        }
        if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, fromIdentity)) {
            this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, fromIdentity.getName(), fromIdentity.getIdentityType());
        }
        if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, toIdentity)) {
            this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, toIdentity.getName(), toIdentity.getIdentityType());
        }
        return this.defaultIdentityStore.createRelationship(defaultTargetCtx, fromIdentity, toIdentity, relationshipType, relationshipName, createNames);
    }

    public void removeRelationship(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String relationshipName) throws IdentityException {
        IdentityStore fromStore = this.resolveIdentityStore(fromIdentity);
        IdentityStore toStore = this.resolveIdentityStore(toIdentity);
        IdentityStoreInvocationContext toTargetCtx = this.resolveInvocationContext(toStore, invocationCxt);
        IdentityStoreInvocationContext defaultTargetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCxt);
        if (fromStore == toStore && !this.isIdentityStoreReadOnly(fromStore) && this.hasIdentityObject(toTargetCtx, toStore, fromIdentity) && this.hasIdentityObject(toTargetCtx, toStore, toIdentity) && (relationshipName == null || relationshipName != null && fromStore.getSupportedFeatures().isNamedRelationshipsSupported())) {
            fromStore.removeRelationship(toTargetCtx, fromIdentity, toIdentity, relationshipType, relationshipName);
            return;
        }
        if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, fromIdentity)) {
            this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, fromIdentity.getName(), fromIdentity.getIdentityType());
        }
        if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, toIdentity)) {
            this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, toIdentity.getName(), toIdentity.getIdentityType());
        }
        this.defaultIdentityStore.removeRelationship(defaultTargetCtx, fromIdentity, toIdentity, relationshipType, relationshipName);
    }

    public void removeRelationships(IdentityStoreInvocationContext invocationCtx, IdentityObject identity1, IdentityObject identity2, boolean named) throws IdentityException {
        IdentityStore fromStore = this.resolveIdentityStore(identity1);
        IdentityStore toStore = this.resolveIdentityStore(identity2);
        IdentityStoreInvocationContext toTargetCtx = this.resolveInvocationContext(toStore, invocationCtx);
        IdentityStoreInvocationContext defaultTargetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCtx);
        if (fromStore == toStore && !this.isIdentityStoreReadOnly(fromStore) && this.hasIdentityObject(toTargetCtx, toStore, identity1) && this.hasIdentityObject(toTargetCtx, toStore, identity2)) {
            fromStore.removeRelationships(toTargetCtx, identity1, identity2, named);
            return;
        }
        if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, identity1)) {
            this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, identity1.getName(), identity1.getIdentityType());
        }
        if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, identity2)) {
            this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, identity2.getName(), identity2.getIdentityType());
        }
        this.defaultIdentityStore.removeRelationships(defaultTargetCtx, identity1, identity2, named);
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType) throws IdentityException {
        IdentityStore fromStore = this.resolveIdentityStore(fromIdentity);
        IdentityStore toStore = this.resolveIdentityStore(toIdentity);
        IdentityStoreInvocationContext toTargetCtx = this.resolveInvocationContext(toStore, invocationCxt);
        IdentityStoreInvocationContext defaultTargetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCxt);
        if (fromStore == toStore && (!RoleManagerImpl.ROLE.getName().equals(relationshipType.getName()) || fromStore.getSupportedFeatures().isNamedRelationshipsSupported()) && this.hasIdentityObject(toTargetCtx, toStore, fromIdentity) && this.hasIdentityObject(toTargetCtx, toStore, toIdentity)) {
            return fromStore.resolveRelationships(toTargetCtx, fromIdentity, toIdentity, relationshipType);
        }
        if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, fromIdentity)) {
            this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, fromIdentity.getName(), fromIdentity.getIdentityType());
        }
        if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, toIdentity)) {
            this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, toIdentity.getName(), toIdentity.getIdentityType());
        }
        return this.defaultIdentityStore.resolveRelationships(defaultTargetCtx, fromIdentity, toIdentity, relationshipType);
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, boolean named, String name) throws IdentityException {
        HashSet<IdentityObjectRelationship> relationships = new HashSet<IdentityObjectRelationship>();
        for (IdentityStore identityStore : this.configuredIdentityStores) {
            if (relationshipType.getName() != null && !identityStore.getSupportedFeatures().getSupportedRelationshipTypes().contains(relationshipType.getName())) continue;
            IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
            if (named && (!named || !identityStore.getSupportedFeatures().isNamedRelationshipsSupported()) || !this.hasIdentityObject(storeCtx, identityStore, identity)) continue;
            relationships.addAll(identityStore.resolveRelationships(storeCtx, identity, relationshipType, parent, named, name));
        }
        return relationships;
    }

    public String createRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        for (IdentityStore identityStore : this.configuredIdentityStores) {
            if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported() || this.isIdentityStoreReadOnly(identityStore)) continue;
            IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
            identityStore.createRelationshipName(storeCtx, name);
        }
        return name;
    }

    public String removeRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        for (IdentityStore identityStore : this.configuredIdentityStores) {
            if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported() || this.isIdentityStoreReadOnly(identityStore)) continue;
            IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
            identityStore.removeRelationshipName(storeCtx, name);
        }
        return name;
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        HashSet<String> results = new HashSet<String>();
        for (IdentityStore identityStore : this.configuredIdentityStores) {
            if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported()) continue;
            IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
            results.addAll(identityStore.getRelationshipNames(storeCtx, criteria));
        }
        return results;
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        IdentityStore toStore = this.resolveIdentityStore(identity);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, ctx);
        if (toStore.getSupportedFeatures().isNamedRelationshipsSupported()) {
            return toStore.getRelationshipNames(targetCtx, identity, criteria);
        }
        IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultIdentityStore, ctx);
        return this.defaultIdentityStore.getRelationshipNames(defaultCtx, identity, criteria);
    }

    public Map<String, String> getRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        HashMap<String, String> results = new HashMap<String, String>();
        for (IdentityStore identityStore : this.configuredIdentityStores) {
            IdentityStoreInvocationContext storeCtx;
            Map props;
            if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported() || (props = identityStore.getRelationshipNameProperties(storeCtx = this.resolveInvocationContext(identityStore, ctx), name)) == null || props.keySet().size() <= 0) continue;
            results.putAll(props);
        }
        return results;
    }

    public void setRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        for (IdentityStore identityStore : this.configuredIdentityStores) {
            if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported() || this.isIdentityStoreReadOnly(identityStore)) continue;
            IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
            identityStore.setRelationshipNameProperties(storeCtx, name, properties);
        }
    }

    public void removeRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        for (IdentityStore identityStore : this.configuredIdentityStores) {
            if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported() || this.isIdentityStoreReadOnly(identityStore)) continue;
            IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
            identityStore.removeRelationshipNameProperties(storeCtx, name, properties);
        }
    }

    public Map<String, String> getRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship) throws IdentityException, OperationNotSupportedException {
        IdentityStore toStore;
        IdentityStore fromStore = this.resolveIdentityStore(relationship.getFromIdentityObject());
        if (fromStore == (toStore = this.resolveIdentityStore(relationship.getToIdentityObject())) && toStore.getSupportedFeatures().isNamedRelationshipsSupported()) {
            return fromStore.getRelationshipProperties(this.resolveInvocationContext(fromStore, ctx), relationship);
        }
        return this.defaultIdentityStore.getRelationshipProperties(this.resolveInvocationContext(this.defaultIdentityStore, ctx), relationship);
    }

    public void setRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        IdentityStore toStore;
        IdentityStore fromStore = this.resolveIdentityStore(relationship.getFromIdentityObject());
        if (fromStore == (toStore = this.resolveIdentityStore(relationship.getToIdentityObject())) && toStore.getSupportedFeatures().isNamedRelationshipsSupported() && !this.isIdentityStoreReadOnly(fromStore)) {
            fromStore.setRelationshipProperties(this.resolveInvocationContext(fromStore, ctx), relationship, properties);
            return;
        }
        this.defaultIdentityStore.setRelationshipProperties(this.resolveInvocationContext(this.defaultIdentityStore, ctx), relationship, properties);
    }

    public void removeRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        IdentityStore toStore;
        IdentityStore fromStore = this.resolveIdentityStore(relationship.getFromIdentityObject());
        if (fromStore == (toStore = this.resolveIdentityStore(relationship.getToIdentityObject())) && toStore.getSupportedFeatures().isNamedRelationshipsSupported() && !this.isIdentityStoreReadOnly(fromStore)) {
            fromStore.removeRelationshipProperties(this.resolveInvocationContext(fromStore, ctx), relationship, properties);
            return;
        }
        this.defaultIdentityStore.removeRelationshipProperties(this.resolveInvocationContext(this.defaultIdentityStore, ctx), relationship, properties);
    }

    public boolean validateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        IdentityStore toStore = this.resolveIdentityStore(identityObject);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, ctx);
        if (this.hasIdentityObject(targetCtx, toStore, identityObject)) {
            return toStore.validateCredential(targetCtx, identityObject, credential);
        }
        targetCtx = this.resolveInvocationContext(this.defaultIdentityStore, ctx);
        if (toStore != this.defaultIdentityStore && this.hasIdentityObject(targetCtx, this.defaultIdentityStore, identityObject)) {
            return this.defaultIdentityStore.validateCredential(targetCtx, identityObject, credential);
        }
        return false;
    }

    public void updateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        IdentityStore toStore = this.resolveIdentityStore(identityObject);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, ctx);
        if (this.hasIdentityObject(targetCtx, toStore, identityObject)) {
            toStore.updateCredential(targetCtx, identityObject, credential);
            return;
        }
        targetCtx = this.resolveInvocationContext(this.defaultIdentityStore, ctx);
        if (toStore != this.defaultIdentityStore && this.hasIdentityObject(targetCtx, this.defaultIdentityStore, identityObject)) {
            this.defaultIdentityStore.updateCredential(targetCtx, identityObject, credential);
        }
    }

    public Set<String> getSupportedAttributeNames(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) throws IdentityException {
        IdentityStore toStore = this.resolveIdentityStore(identityType);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationContext);
        Set results = toStore.getSupportedAttributeNames(targetCtx, identityType);
        if (toStore != this.defaultAttributeStore) {
            IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationContext);
            results.addAll(this.defaultAttributeStore.getSupportedAttributeNames(defaultCtx, identityType));
        }
        return results;
    }

    public Map<String, IdentityObjectAttributeMetaData> getAttributesMetaData(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityObjectType) {
        IdentityStoreInvocationContext defaultCtx;
        Map defaultMDMap;
        IdentityStore targetStore = this.resolveIdentityStore(identityObjectType);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationContext);
        HashMap<String, IdentityObjectAttributeMetaData> mdMap = new HashMap<String, IdentityObjectAttributeMetaData>();
        mdMap.putAll(targetStore.getAttributesMetaData(targetCtx, identityObjectType));
        if (targetStore != this.defaultAttributeStore && (defaultMDMap = this.defaultAttributeStore.getAttributesMetaData(defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationContext), identityObjectType)) != null) {
            for (Map.Entry entry : defaultMDMap.entrySet()) {
                if (mdMap.containsKey(entry.getKey())) continue;
                mdMap.put((String)entry.getKey(), (IdentityObjectAttributeMetaData)entry.getValue());
            }
        }
        return mdMap;
    }

    public IdentityObjectAttribute getAttribute(IdentityStoreInvocationContext invocationContext, IdentityObject identity, String name) throws IdentityException {
        IdentityObjectAttribute result = null;
        IdentityStore toStore = this.resolveIdentityStore(identity);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationContext);
        if (this.hasIdentityObject(targetCtx, toStore, identity)) {
            result = toStore.getAttribute(targetCtx, identity, name);
        }
        if (result == null && toStore != this.defaultAttributeStore) {
            IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationContext);
            result = this.defaultAttributeStore.getAttribute(defaultCtx, identity, name);
        }
        return result;
    }

    public Map<String, IdentityObjectAttribute> getAttributes(IdentityStoreInvocationContext invocationContext, IdentityObject identity) throws IdentityException {
        HashMap<String, IdentityObjectAttribute> results = new HashMap();
        IdentityStore toStore = this.resolveIdentityStore(identity);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationContext);
        if (this.hasIdentityObject(targetCtx, toStore, identity)) {
            results = toStore.getAttributes(targetCtx, identity);
        }
        if (toStore != this.defaultAttributeStore) {
            IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationContext);
            Map defaultAttrs = this.defaultAttributeStore.getAttributes(defaultCtx, identity);
            for (Map.Entry entry : defaultAttrs.entrySet()) {
                if (results.keySet().contains(entry.getKey())) continue;
                results.put((String)entry.getKey(), (IdentityObjectAttribute)entry.getValue());
            }
        }
        return results;
    }

    public void updateAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        ArrayList<IdentityObjectAttribute> filteredAttrs = new ArrayList<IdentityObjectAttribute>();
        ArrayList<IdentityObjectAttribute> leftAttrs = new ArrayList<IdentityObjectAttribute>();
        IdentityObjectAttribute[] attributesToAdd = null;
        IdentityStore toStore = this.resolveIdentityStore(identity);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationCtx);
        if (toStore != this.defaultAttributeStore && !this.isIdentityStoreReadOnly(toStore) && this.hasIdentityObject(targetCtx, toStore, identity)) {
            Set supportedAttrs = toStore.getSupportedAttributeNames(targetCtx, identity.getIdentityType());
            for (IdentityObjectAttribute entry : attributes) {
                if (supportedAttrs.contains(entry.getName())) {
                    filteredAttrs.add(entry);
                    continue;
                }
                leftAttrs.add(entry);
            }
            toStore.updateAttributes(targetCtx, identity, filteredAttrs.toArray(new IdentityObjectAttribute[filteredAttrs.size()]));
            attributesToAdd = leftAttrs.toArray(new IdentityObjectAttribute[leftAttrs.size()]);
        } else {
            attributesToAdd = attributes;
        }
        IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationCtx);
        if (this.isAllowNotDefinedAttributes()) {
            if (!this.hasIdentityObject(defaultCtx, this.defaultIdentityStore, identity)) {
                this.defaultIdentityStore.createIdentityObject(defaultCtx, identity.getName(), identity.getIdentityType());
            }
            this.defaultAttributeStore.updateAttributes(defaultCtx, identity, attributesToAdd);
        } else {
            Set supportedAttrs = this.defaultAttributeStore.getSupportedAttributeNames(defaultCtx, identity.getIdentityType());
            for (IdentityObjectAttribute entry : leftAttrs) {
                if (supportedAttrs.contains(entry.getName())) continue;
                throw new IdentityException("Cannot update not defined attribute. Use 'allowNotDefinedAttributes' option to pass such attributes to default IdentityStore anyway.Attribute name: " + entry.getName());
            }
            this.defaultAttributeStore.updateAttributes(defaultCtx, identity, attributesToAdd);
        }
    }

    public void addAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        ArrayList<IdentityObjectAttribute> filteredAttrs = new ArrayList<IdentityObjectAttribute>();
        ArrayList<IdentityObjectAttribute> leftAttrs = new ArrayList<IdentityObjectAttribute>();
        IdentityObjectAttribute[] attributesToAdd = null;
        IdentityStore toStore = this.resolveIdentityStore(identity);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationCtx);
        if (toStore != this.defaultAttributeStore && !this.isIdentityStoreReadOnly(toStore) && this.hasIdentityObject(targetCtx, toStore, identity)) {
            Set supportedAttrs = toStore.getSupportedAttributeNames(targetCtx, identity.getIdentityType());
            for (IdentityObjectAttribute entry : attributes) {
                if (supportedAttrs.contains(entry.getName())) {
                    filteredAttrs.add(entry);
                    continue;
                }
                leftAttrs.add(entry);
            }
            toStore.addAttributes(targetCtx, identity, filteredAttrs.toArray(new IdentityObjectAttribute[filteredAttrs.size()]));
            attributesToAdd = leftAttrs.toArray(new IdentityObjectAttribute[leftAttrs.size()]);
        } else {
            attributesToAdd = attributes;
        }
        IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationCtx);
        if (this.isAllowNotDefinedAttributes()) {
            if (!this.hasIdentityObject(defaultCtx, this.defaultIdentityStore, identity)) {
                this.defaultIdentityStore.createIdentityObject(defaultCtx, identity.getName(), identity.getIdentityType());
            }
            this.defaultAttributeStore.addAttributes(defaultCtx, identity, attributesToAdd);
        } else {
            Set supportedAttrs = this.defaultAttributeStore.getSupportedAttributeNames(defaultCtx, identity.getIdentityType());
            for (IdentityObjectAttribute entry : attributesToAdd) {
                if (supportedAttrs.contains(entry.getName())) continue;
                throw new IdentityException("Cannot add not defined attribute. Use 'allowNotDefinedAttributes' option to pass such attributes to default IdentityStore anyway.Attribute name: " + entry.getName());
            }
            this.defaultAttributeStore.addAttributes(defaultCtx, identity, attributesToAdd);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, String[] attributes) throws IdentityException {
        LinkedList<String> filteredAttrs = new LinkedList<String>();
        List<Object> leftAttrs = new LinkedList();
        IdentityStore toStore = this.resolveIdentityStore(identity);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationCtx);
        if (toStore != this.defaultAttributeStore && !this.isIdentityStoreReadOnly(toStore) && this.hasIdentityObject(targetCtx, toStore, identity)) {
            void var11_13;
            Set supportedAttrs = toStore.getSupportedAttributeNames(targetCtx, identity.getIdentityType());
            String[] arr$ = attributes;
            int len$ = arr$.length;
            boolean bl = false;
            while (var11_13 < len$) {
                String name = arr$[var11_13];
                if (supportedAttrs.contains(name)) {
                    filteredAttrs.add(name);
                } else {
                    leftAttrs.add(name);
                }
                ++var11_13;
            }
            toStore.removeAttributes(targetCtx, identity, filteredAttrs.toArray(new String[filteredAttrs.size()]));
        } else {
            leftAttrs = Arrays.asList(attributes);
        }
        IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationCtx);
        if (this.isAllowNotDefinedAttributes()) {
            if (!this.hasIdentityObject(defaultCtx, this.defaultIdentityStore, identity)) {
                this.defaultIdentityStore.createIdentityObject(defaultCtx, identity.getName(), identity.getIdentityType());
            }
            this.defaultAttributeStore.removeAttributes(defaultCtx, identity, leftAttrs.toArray(new String[leftAttrs.size()]));
        } else {
            Set supportedAttrs = this.defaultAttributeStore.getSupportedAttributeNames(defaultCtx, identity.getIdentityType());
            for (String string : leftAttrs) {
                if (supportedAttrs.contains(string)) continue;
                throw new IdentityException("Cannot remove not defined attribute. Use 'allowNotDefinedAttributes' option to pass such attributes to default IdentityStore anyway.Attribute name: " + string);
            }
            this.defaultAttributeStore.removeAttributes(defaultCtx, identity, leftAttrs.toArray(new String[leftAttrs.size()]));
        }
    }

    public IdentityObject findIdentityObjectByUniqueAttribute(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityObjectType, IdentityObjectAttribute attribute) throws IdentityException {
        Set supportedAttrs;
        LinkedList filteredAttrs = new LinkedList();
        LinkedList leftAttrs = new LinkedList();
        IdentityStore toStore = this.resolveIdentityStore(identityObjectType);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationCtx);
        IdentityObject result = null;
        if (toStore != this.defaultAttributeStore && (supportedAttrs = toStore.getSupportedAttributeNames(targetCtx, identityObjectType)).contains(attribute.getName())) {
            result = toStore.findIdentityObjectByUniqueAttribute(targetCtx, identityObjectType, attribute);
        }
        if (result != null) {
            return result;
        }
        IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationCtx);
        if (this.isAllowNotDefinedAttributes()) {
            return this.defaultAttributeStore.findIdentityObjectByUniqueAttribute(defaultCtx, identityObjectType, attribute);
        }
        Set supportedAttrs2 = this.defaultAttributeStore.getSupportedAttributeNames(defaultCtx, identityObjectType);
        if (supportedAttrs2.contains(attribute.getName())) {
            return toStore.findIdentityObjectByUniqueAttribute(defaultCtx, identityObjectType, attribute);
        }
        return null;
    }

    private void sortByName(List<IdentityObject> objects, final boolean ascending) {
        Collections.sort(objects, new Comparator<IdentityObject>(){

            @Override
            public int compare(IdentityObject o1, IdentityObject o2) {
                if (ascending) {
                    return o1.getName().compareTo(o2.getName());
                }
                return o2.getName().compareTo(o1.getName());
            }
        });
    }

    private List<IdentityObject> cutPageFromResults(List<IdentityObject> objects, IdentityObjectSearchCriteria criteria) {
        LinkedList<IdentityObject> results = new LinkedList<IdentityObject>();
        if (criteria.getMaxResults() == 0) {
            for (int i = criteria.getFirstResult(); i < objects.size(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        } else {
            for (int i = criteria.getFirstResult(); i < criteria.getFirstResult() + criteria.getMaxResults(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        }
        return results;
    }

    public boolean isAllowNotDefinedAttributes() {
        return this.allowNotDefinedAttributes;
    }

    public boolean isIdentityStoreReadOnly(IdentityStore store) {
        List mappingMDs = this.configurationContext.getRepositoryConfigurationMetaData().getIdentityStoreToIdentityObjectTypeMappings();
        for (IdentityStoreMappingMetaData mappingMD : mappingMDs) {
            String value;
            if (!mappingMD.getIdentityStoreId().equals(store.getId()) || (value = mappingMD.getOptionSingleValue(OPTION_READ_ONLY)) == null || !value.equalsIgnoreCase("true")) continue;
            return true;
        }
        return false;
    }
}

