/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api.query;

import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.SortOrder;
import org.picketlink.idm.api.UnsupportedCriterium;
import org.picketlink.idm.api.query.QueryBuilder;
import org.picketlink.idm.api.query.UnsupportedQueryCriterium;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;
import org.picketlink.idm.impl.api.model.GroupKey;
import org.picketlink.idm.impl.api.model.SimpleGroup;
import org.picketlink.idm.impl.api.model.SimpleUser;

public class AbstractQueryBuilder
implements QueryBuilder {
    protected IdentitySearchCriteriaImpl searchCriteria = new IdentitySearchCriteriaImpl();

    public QueryBuilder sort(SortOrder order) throws UnsupportedQueryCriterium {
        try {
            this.searchCriteria.sort(order);
        }
        catch (UnsupportedCriterium unsupportedCriterium) {
            throw new UnsupportedQueryCriterium((Throwable)unsupportedCriterium);
        }
        return this;
    }

    public QueryBuilder sortAttributeName(String name) throws UnsupportedQueryCriterium {
        try {
            this.searchCriteria.sortAttributeName(name);
        }
        catch (UnsupportedCriterium unsupportedCriterium) {
            throw new UnsupportedQueryCriterium((Throwable)unsupportedCriterium);
        }
        return this;
    }

    public QueryBuilder page(int firstResult, int maxResults) throws UnsupportedQueryCriterium {
        try {
            this.searchCriteria.page(firstResult, maxResults);
        }
        catch (UnsupportedCriterium unsupportedCriterium) {
            throw new UnsupportedQueryCriterium((Throwable)unsupportedCriterium);
        }
        return this;
    }

    public QueryBuilder attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedQueryCriterium {
        try {
            this.searchCriteria.attributeValuesFilter(attributeName, attributeValue);
        }
        catch (UnsupportedCriterium unsupportedCriterium) {
            throw new UnsupportedQueryCriterium((Throwable)unsupportedCriterium);
        }
        return this;
    }

    public QueryBuilder idFilter(String idFilter) throws UnsupportedQueryCriterium {
        try {
            this.searchCriteria.nameFilter(idFilter);
        }
        catch (UnsupportedCriterium unsupportedCriterium) {
            throw new UnsupportedQueryCriterium((Throwable)unsupportedCriterium);
        }
        return this;
    }

    protected void checkNotNullArgument(Object arg, String name) {
        if (arg == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    protected Group createGroupFromId(String id) {
        return new SimpleGroup(new GroupKey(id));
    }

    protected IdentityType createIdentityTypeFromId(String id) {
        if (GroupKey.validateKey(id)) {
            GroupKey groupKey = new GroupKey(id);
            return new SimpleGroup(groupKey);
        }
        return new SimpleUser(id);
    }
}

