/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.repository;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.cache.JBossCacheIdentityStoreWrapper;
import org.picketlink.idm.spi.cache.IdentityStoreCacheProvider;
import org.picketlink.idm.spi.configuration.IdentityRepositoryConfigurationContext;
import org.picketlink.idm.spi.configuration.metadata.IdentityRepositoryConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreMappingMetaData;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.repository.IdentityStoreRepository;
import org.picketlink.idm.spi.store.AttributeStore;
import org.picketlink.idm.spi.store.IdentityStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIdentityStoreRepository
implements IdentityStoreRepository,
Serializable {
    protected Map<String, IdentityStore> identityStoreMappings = new HashMap<String, IdentityStore>();
    protected Map<String, AttributeStore> attributeStoreMappings = new HashMap<String, AttributeStore>();
    protected IdentityStore defaultIdentityStore;
    protected AttributeStore defaultAttributeStore;
    protected IdentityRepositoryConfigurationContext configurationContext;
    public static final String CACHE_OPTION = "cache";
    public static final String CACHE_CONFIG_FILE_OPTION = "cache.configFile";
    public static final String CACHE_PROVIDER_CLASS_OPTION = "cache.providerClass";
    public static final String CACHE_PROVIDER_REGISTRY_NAME = "cache.providerRegistryName";
    public static final String CACHE_SCOPE = "cache.scope";
    public static final String ALLOW_NOT_DEFINED_IDENTITY_OBJECT_TYPES_OPTION = "allowNotDefinedIdentityObjectTypes";
    private boolean allowNotDefinedIdentityObjectTypes = false;

    @Override
    public void bootstrap(IdentityRepositoryConfigurationContext configurationContext, Map<String, IdentityStore> bootstrappedIdentityStores, Map<String, AttributeStore> bootstrappedAttributeStores) throws IdentityException {
        String allowNotDefinedIOT;
        this.configurationContext = configurationContext;
        IdentityRepositoryConfigurationMetaData configurationMD = configurationContext.getRepositoryConfigurationMetaData();
        String asId = configurationMD.getDefaultAttributeStoreId();
        String isId = configurationMD.getDefaultIdentityStoreId();
        if (asId != null && bootstrappedAttributeStores.keySet().contains(asId)) {
            this.defaultAttributeStore = bootstrappedAttributeStores.get(asId);
        }
        if ((allowNotDefinedIOT = configurationMD.getOptionSingleValue(ALLOW_NOT_DEFINED_IDENTITY_OBJECT_TYPES_OPTION)) != null && allowNotDefinedIOT.equalsIgnoreCase("true")) {
            this.allowNotDefinedIdentityObjectTypes = true;
        }
        if (isId != null && bootstrappedIdentityStores.keySet().contains(isId)) {
            this.defaultIdentityStore = bootstrappedIdentityStores.get(isId);
            String cacheOption = configurationMD.getOptionSingleValue(CACHE_OPTION);
            if (cacheOption != null && cacheOption.equalsIgnoreCase("true")) {
                String cacheSupportClass = configurationMD.getOptionSingleValue(CACHE_PROVIDER_CLASS_OPTION);
                String cacheRegistryName = configurationMD.getOptionSingleValue(CACHE_PROVIDER_REGISTRY_NAME);
                String cacheScope = configurationMD.getOptionSingleValue(CACHE_PROVIDER_REGISTRY_NAME);
                if (cacheSupportClass == null && cacheRegistryName == null) {
                    throw new IdentityException("cache.providerClass is missing in the repository configuration");
                }
                IdentityStoreCacheProvider cacheSupport = null;
                HashMap<String, String> cacheProps = new HashMap<String, String>();
                for (String key : configurationMD.getOptions().keySet()) {
                    if (!key.startsWith("cache.") || configurationMD.getOptions().get(key).size() <= 0) continue;
                    cacheProps.put(key, configurationMD.getOptions().get(key).get(0));
                }
                if (cacheRegistryName != null) {
                    try {
                        cacheSupport = (IdentityStoreCacheProvider)configurationContext.getConfigurationRegistry().getObject(cacheRegistryName);
                    }
                    catch (IdentityException e) {
                        throw new IdentityException("Cannot find IdentityStoreCacheProvider cache provider instancewith provided name:" + cacheRegistryName, e);
                    }
                }
                try {
                    Class<?> cacheClass = null;
                    cacheClass = Class.forName(cacheSupportClass);
                    Constructor<?> ct = cacheClass.getConstructor(new Class[0]);
                    cacheSupport = (IdentityStoreCacheProvider)ct.newInstance(new Object[0]);
                    cacheSupport.initialize(cacheProps, configurationContext);
                }
                catch (Exception e) {
                    throw new IdentityException("Cannot instantiate cache provider:" + cacheSupportClass, e);
                }
                this.defaultIdentityStore = new JBossCacheIdentityStoreWrapper(this.defaultIdentityStore, cacheSupport, cacheScope);
            }
        }
        for (IdentityStoreMappingMetaData identityStoreMappingMetaData : configurationMD.getIdentityStoreToIdentityObjectTypeMappings()) {
            String storeId = identityStoreMappingMetaData.getIdentityStoreId();
            List<String> identityObjectTypeMappings = identityStoreMappingMetaData.getIdentityObjectTypeMappings();
            IdentityStore store = bootstrappedIdentityStores.get(storeId);
            String cacheOption = identityStoreMappingMetaData.getOptionSingleValue(CACHE_OPTION);
            if (cacheOption != null && cacheOption.equalsIgnoreCase("true")) {
                String cacheSupportClass = identityStoreMappingMetaData.getOptionSingleValue(CACHE_PROVIDER_CLASS_OPTION);
                String cacheRegistryName = identityStoreMappingMetaData.getOptionSingleValue(CACHE_PROVIDER_REGISTRY_NAME);
                String cacheScope = identityStoreMappingMetaData.getOptionSingleValue(CACHE_PROVIDER_REGISTRY_NAME);
                if (cacheSupportClass == null && cacheRegistryName == null) {
                    throw new IdentityException("cache.providerClass is missing in the <identity-store><options> configuration");
                }
                IdentityStoreCacheProvider cacheSupport = null;
                HashMap<String, String> cacheProps = new HashMap<String, String>();
                for (String key : identityStoreMappingMetaData.getOptions().keySet()) {
                    if (!key.startsWith("cache.") || identityStoreMappingMetaData.getOptions().get(key).size() <= 0) continue;
                    cacheProps.put(key, identityStoreMappingMetaData.getOptions().get(key).get(0));
                }
                if (cacheRegistryName != null) {
                    try {
                        cacheSupport = (IdentityStoreCacheProvider)configurationContext.getConfigurationRegistry().getObject(cacheRegistryName);
                    }
                    catch (IdentityException e) {
                        throw new IdentityException("Cannot find IdentityStoreCacheProvider cache provider instancewith provided name:" + cacheRegistryName, e);
                    }
                }
                try {
                    Class<?> cacheClass = null;
                    cacheClass = Class.forName(cacheSupportClass);
                    Constructor<?> ct = cacheClass.getConstructor(new Class[0]);
                    cacheSupport = (IdentityStoreCacheProvider)ct.newInstance(new Object[0]);
                    cacheSupport.initialize(cacheProps, configurationContext);
                }
                catch (Exception e) {
                    throw new IdentityException("Cannot instantiate cache provider:" + cacheSupportClass, e);
                }
                store = new JBossCacheIdentityStoreWrapper(store, cacheSupport, cacheScope);
            }
            if (store == null) {
                throw new IdentityException("Mapped IdentityStore not available: " + storeId);
            }
            for (String mapping : identityObjectTypeMappings) {
                this.identityStoreMappings.put(mapping, store);
                this.attributeStoreMappings.put(mapping, store);
            }
        }
    }

    @Override
    public Set<IdentityStore> getConfiguredIdentityStores() {
        return new HashSet<IdentityStore>(this.identityStoreMappings.values());
    }

    @Override
    public Set<AttributeStore> getConfiguredAttributeStores() {
        return new HashSet<AttributeStore>(this.attributeStoreMappings.values());
    }

    @Override
    public Map<String, IdentityStore> getIdentityStoreMappings() {
        return this.identityStoreMappings;
    }

    @Override
    public Map<String, AttributeStore> getAttributeStoreMappings() {
        return this.attributeStoreMappings;
    }

    @Override
    public IdentityStore getIdentityStore(IdentityObjectType identityObjectType) throws IdentityException {
        IdentityStore store = this.identityStoreMappings.get(identityObjectType.getName());
        if (store == null) {
            String option = this.configurationContext.getRepositoryConfigurationMetaData().getOptionSingleValue(ALLOW_NOT_DEFINED_IDENTITY_OBJECT_TYPES_OPTION);
            if (option != null && option.equalsIgnoreCase("true")) {
                return this.defaultIdentityStore;
            }
            throw new IdentityException("IdentityObjectType not mapped in the configuration: " + identityObjectType);
        }
        return store;
    }

    @Override
    public AttributeStore getAttributeStore(IdentityObjectType identityObjectType) throws IdentityException {
        AttributeStore store = this.attributeStoreMappings.get(identityObjectType.getName());
        if (store == null) {
            String option = this.configurationContext.getRepositoryConfigurationMetaData().getOptionSingleValue(ALLOW_NOT_DEFINED_IDENTITY_OBJECT_TYPES_OPTION);
            if (option != null && option.equalsIgnoreCase("true")) {
                return this.defaultIdentityStore;
            }
            throw new IdentityException("IdentityObjectType not mapped in the configuration: " + identityObjectType);
        }
        return store;
    }

    protected boolean hasIdentityObject(IdentityStoreInvocationContext ctx, IdentityStore is, IdentityObject io) throws IdentityException {
        try {
            if (is.findIdentityObject(ctx, io.getName(), io.getIdentityType()) != null) {
                return true;
            }
        }
        catch (IdentityException e) {
            // empty catch block
        }
        return false;
    }

    public boolean isAllowNotDefinedIdentityObjectTypes() {
        return this.allowNotDefinedIdentityObjectTypes;
    }
}

