/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.property;

import java.util.Properties;
import org.jboss.util.property.FieldBoundPropertyListener;
import org.jboss.util.property.MethodBoundPropertyListener;
import org.jboss.util.property.Property;
import org.jboss.util.property.PropertyException;
import org.jboss.util.property.PropertyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyContainer
extends PropertyMap {
    private static final long serialVersionUID = -3347198703863412326L;
    protected String groupname = "<unknown>";

    public PropertyContainer(Properties props) {
        super(props);
    }

    public PropertyContainer(String groupname) {
        this(Property.getGroup(groupname));
        this.groupname = groupname;
    }

    public PropertyContainer(Class<?> type) {
        this(type.getName());
    }

    protected void bindField(String name, String propertyName) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("name");
        }
        if (propertyName == null || propertyName.equals("")) {
            throw new IllegalArgumentException("propertyName");
        }
        this.addPropertyListener(new FieldBoundPropertyListener(this, name, propertyName));
    }

    protected void bindField(String name) {
        this.bindField(name, name);
    }

    protected void bindMethod(String name, String propertyName) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("name");
        }
        if (propertyName == null || propertyName.equals("")) {
            throw new IllegalArgumentException("propertyName");
        }
        this.addPropertyListener(new MethodBoundPropertyListener(this, propertyName, name));
    }

    protected void bindMethod(String name) {
        this.bindMethod(name, name);
    }

    private String makeName(String name) {
        return this.groupname + "." + name;
    }

    protected void throwException(String name) throws PropertyException {
        throw new PropertyException(this.makeName(name));
    }

    protected void throwException(String name, String msg) throws PropertyException {
        throw new PropertyException(this.makeName(name) + ": " + msg);
    }

    protected void throwException(String name, String msg, Throwable nested) throws PropertyException {
        throw new PropertyException(this.makeName(name) + ": " + msg, nested);
    }

    protected void throwException(String name, Throwable nested) throws PropertyException {
        throw new PropertyException(this.makeName(name), nested);
    }
}

