/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectTypeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.RelationshipMetaData;
import org.picketlink.idm.spi.model.IdentityObjectCredentialType;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.store.FeaturesMetaData;
import org.picketlink.idm.spi.store.IdentityObjectSearchCriteriaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeaturesMetaDataImpl
implements FeaturesMetaData,
Serializable {
    private Set<String> supportedTypeNames = new HashSet<String>();
    private final Set<IdentityObjectSearchCriteriaType> supportedSearchConstraintTypes;
    private final Map<String, Set<String>> supportedCredentials;
    private final boolean namedRelationshipsSupport;
    private final Set<String> readOnlyObjectTypes;
    private final boolean relationshipPropertiesSupport;
    private final Map<String, Map<String, Set<String>>> supportedRelationshipMappings = new HashMap<String, Map<String, Set<String>>>();
    private final Set<String> supportedRelationshipTypes = new HashSet<String>();

    public FeaturesMetaDataImpl(IdentityStoreConfigurationMetaData configurationMD, Set<IdentityObjectSearchCriteriaType> supportedCriteria, boolean relationshipPropertiesSupport, boolean namedRelationshipsSupport, Set<String> readOnlyObjectTypes) {
        this.relationshipPropertiesSupport = relationshipPropertiesSupport;
        this.namedRelationshipsSupport = namedRelationshipsSupport;
        this.readOnlyObjectTypes = readOnlyObjectTypes;
        HashMap<String, HashSet<String>> supportedCredentials = new HashMap<String, HashSet<String>>();
        for (IdentityObjectTypeMetaData typeMetaData : configurationMD.getSupportedIdentityTypes()) {
            this.supportedTypeNames.add(typeMetaData.getName());
            if (typeMetaData.getCredentials() == null) continue;
            HashSet<String> credentials = new HashSet<String>(typeMetaData.getCredentials());
            supportedCredentials.put(typeMetaData.getName(), credentials);
        }
        this.supportedTypeNames = Collections.unmodifiableSet(this.supportedTypeNames);
        this.supportedCredentials = Collections.unmodifiableMap(supportedCredentials);
        this.supportedSearchConstraintTypes = Collections.unmodifiableSet(supportedCriteria);
        for (String type : configurationMD.getSupportedRelationshipTypes()) {
            this.supportedRelationshipTypes.add(type);
        }
        for (IdentityObjectTypeMetaData identityObjectTypeMetaData : configurationMD.getSupportedIdentityTypes()) {
            String fromTypeName = identityObjectTypeMetaData.getName();
            if (identityObjectTypeMetaData.getRelationships() == null) continue;
            for (RelationshipMetaData relationshipMetaData : identityObjectTypeMetaData.getRelationships()) {
                String relationshipName = relationshipMetaData.getRelationshipTypeRef();
                String toTypeName = relationshipMetaData.getIdentityObjectTypeRef();
                Map<Object, Object> mappings = null;
                if (this.supportedRelationshipMappings.containsKey(relationshipName)) {
                    mappings = this.supportedRelationshipMappings.get(relationshipName);
                } else {
                    mappings = new HashMap();
                    this.supportedRelationshipMappings.put(relationshipName, mappings);
                }
                Set<String> toTypes = null;
                if (mappings.containsKey(fromTypeName)) {
                    toTypes = (Set)mappings.get(fromTypeName);
                } else {
                    toTypes = new HashSet();
                    mappings.put(fromTypeName, toTypes);
                }
                toTypes.add(toTypeName);
            }
        }
    }

    @Override
    public boolean isIdentityObjectAddRemoveSupported(IdentityObjectType objectType) {
        return !this.readOnlyObjectTypes.contains(objectType.getName());
    }

    @Override
    public boolean isRelationshipNameAddRemoveSupported() {
        return this.namedRelationshipsSupport;
    }

    @Override
    public boolean isNamedRelationshipsSupported() {
        return this.namedRelationshipsSupport;
    }

    @Override
    public boolean isRelationshipPropertiesSupported() {
        return this.relationshipPropertiesSupport;
    }

    @Override
    public boolean isSearchCriteriaTypeSupported(IdentityObjectType identityObjectType, IdentityObjectSearchCriteriaType storeSearchConstraint) {
        return this.supportedSearchConstraintTypes.contains((Object)storeSearchConstraint);
    }

    @Override
    public Set<String> getSupportedIdentityObjectTypes() {
        return this.supportedTypeNames;
    }

    @Override
    public boolean isIdentityObjectTypeSupported(IdentityObjectType identityObjectType) {
        return this.supportedTypeNames.contains(identityObjectType.getName());
    }

    @Override
    public boolean isRelationshipTypeSupported(IdentityObjectType fromType, IdentityObjectType toType, IdentityObjectRelationshipType relationshipType) throws IdentityException {
        Map<String, Set<String>> mappings = this.supportedRelationshipMappings.get(relationshipType.getName());
        return mappings != null && mappings.containsKey(fromType.getName()) && mappings.get(fromType.getName()).contains(toType.getName());
    }

    @Override
    public Set<String> getSupportedRelationshipTypes() {
        return Collections.unmodifiableSet(this.supportedRelationshipTypes);
    }

    @Override
    public boolean isCredentialSupported(IdentityObjectType identityObjectType, IdentityObjectCredentialType credentialType) {
        Set<String> types = this.supportedCredentials.get(identityObjectType.getName());
        return types != null && types.contains(credentialType.getName());
    }

    @Override
    public boolean isRoleNameSearchCriteriaTypeSupported(IdentityObjectSearchCriteriaType constraint) {
        return this.isNamedRelationshipsSupported() && this.isSearchCriteriaTypeSupported(null, constraint);
    }
}

