/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.MultiMap;
import org.hibernate.mapping.MetaAttribute;

public final class MetaAttributeHelper {
    private MetaAttributeHelper() {
    }

    public static String getMetaAsString(Collection meta, String seperator) {
        if (meta == null || meta.isEmpty()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        Iterator iter = meta.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(seperator);
        }
        return buf.toString();
    }

    public static String getMetaAsString(MetaAttribute meta, String seperator) {
        if (meta == null) {
            return null;
        }
        return MetaAttributeHelper.getMetaAsString(meta.getValues(), seperator);
    }

    static boolean getMetaAsBool(Collection c, boolean defaultValue) {
        if (c == null || c.isEmpty()) {
            return defaultValue;
        }
        return Boolean.valueOf(c.iterator().next().toString());
    }

    public static String getMetaAsString(MetaAttribute c) {
        return c == null ? "" : MetaAttributeHelper.getMetaAsString(c.getValues());
    }

    static String getMetaAsString(Collection c) {
        return MetaAttributeHelper.getMetaAsString(c, "");
    }

    public static void copyMultiMap(MultiMap destination, Map specific) {
        Iterator keyIterator = specific.keySet().iterator();
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            Collection c = (Collection)specific.get(key);
            Iterator valueIterator = c.iterator();
            while (valueIterator.hasNext()) {
                destination.put(key, valueIterator.next());
            }
        }
    }

    public static boolean getMetaAsBool(MetaAttribute metaAttribute, boolean defaultValue) {
        return MetaAttributeHelper.getMetaAsBool(metaAttribute == null ? null : metaAttribute.getValues(), defaultValue);
    }
}

