/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools {
    private static final Pattern DN_PATTERN = Pattern.compile("([^=,\\\\]*(\\\\.)?)+");
    private static Logger log = Logger.getLogger(Tools.class.getName());
    private static MBeanServer instance = null;

    public static <E> List<E> toList(Enumeration<E> e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<E> list = new ArrayList<E>();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list;
    }

    public static String wildcardToRegex(String wildcard) {
        StringBuffer s = new StringBuffer(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block4: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block4;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block4;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    public static String stripDnToName(String dn) {
        if (dn == null || dn.length() == 0) {
            throw new IllegalArgumentException("Cannot process empty dn");
        }
        Object name = null;
        String[] parts = dn.split(",");
        if ((parts = parts[0].split("=")).length != 2) {
            throw new IllegalArgumentException("Wrong dn format: " + dn);
        }
        return parts[1];
    }

    public static String getOptionSingleValue(String optionName, Map<String, List<String>> options) {
        if (options == null || options.size() == 0) {
            return null;
        }
        List<String> values = options.get(optionName);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public static final String escapeLDAPSearchFilter(String filter) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < filter.length(); ++i) {
            char curChar = filter.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString();
    }

    public static void logMethodIn(Logger log, Level level, String methodName, Object[] args) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("Method '").append(methodName).append("' called with arguments: ");
            if (args != null) {
                for (Object arg : args) {
                    if (arg != null && arg instanceof Object[]) {
                        sb.append(Arrays.toString((Object[])arg)).append("; ");
                        continue;
                    }
                    sb.append(arg).append("; ");
                }
            }
            log.log(level, sb.toString());
        }
        catch (Throwable t) {
            log.log(level, "Error in logging code block (not related to application code): ", t);
        }
    }

    public static void logMethodOut(Logger log, Level level, String methodName, Object result) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("Method '").append(methodName).append("' returning object: ");
            if (result != null && result instanceof Collection) {
                sb.append("Collection of size: ").append(((Collection)result).size());
            } else {
                if (result != null) {
                    sb.append("[").append(result.getClass().getCanonicalName()).append("]");
                }
                sb.append(result);
            }
            log.log(level, sb.toString());
        }
        catch (Throwable t) {
            log.log(level, "Error in logging code block (not related to application code): ", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServer locateJBoss() {
        Class<Tools> clazz = Tools.class;
        synchronized (Tools.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            for (MBeanServer server : MBeanServerFactory.findMBeanServer(null)) {
                if (!server.getDefaultDomain().equals("jboss")) continue;
                return server;
            }
            throw new IllegalStateException("No 'jboss' MBeanServer found!");
        }
    }

    public static boolean dnEndsWith(String dn1, String dn2) {
        String dn1Formatted = Tools.dnFormatWhitespaces(dn1);
        String dn2Formatted = Tools.dnFormatWhitespaces(dn2);
        return dn1Formatted.endsWith(dn2Formatted);
    }

    public static boolean dnEquals(String dn1, String dn2) {
        String dn1Formatted = Tools.dnFormatWhitespaces(dn1);
        String dn2Formatted = Tools.dnFormatWhitespaces(dn2);
        return dn1Formatted.equals(dn2Formatted);
    }

    public static String dnFormatWhitespaces(String inputDn) {
        String inputlc = inputDn.toLowerCase();
        StringBuilder result = new StringBuilder();
        int last = 0;
        Matcher m = DN_PATTERN.matcher(inputlc);
        while (m.find()) {
            if (m.group().length() == 0) continue;
            if (++last > 1) {
                result.append(last % 2 == 0 ? (char)'=' : ',');
            }
            result.append(m.group().trim());
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Input to format=\"" + inputDn + "\", Output from format=\"" + result.toString() + "\"");
        }
        return result.toString();
    }
}

