/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jmx;

import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.ExternalSessionFactoryConfig;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.jndi.JndiHelper;
import org.hibernate.jmx.HibernateServiceMBean;
import org.hibernate.jmx.SessionFactoryStub;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.jboss.logging.Logger;

@Deprecated
public class HibernateService
extends ExternalSessionFactoryConfig
implements HibernateServiceMBean {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)HibernateService.class.getName());
    private String boundName;
    private Properties properties = new Properties();

    @Override
    public void start() throws HibernateException {
        this.boundName = this.getJndiName();
        try {
            this.buildSessionFactory();
        }
        catch (HibernateException he) {
            LOG.unableToBuildSessionFactoryUsingMBeanClasspath(he.getMessage());
            LOG.debug("Error was", he);
            new SessionFactoryStub(this);
        }
    }

    @Override
    public void stop() {
        LOG.stoppingService();
        try {
            InitialContext context = JndiHelper.getInitialContext(this.buildProperties());
            ((SessionFactory)context.lookup(this.boundName)).close();
        }
        catch (Exception e) {
            LOG.unableToStopHibernateService(e);
        }
    }

    SessionFactory buildSessionFactory() throws HibernateException {
        LOG.startingServiceAtJndiName(this.boundName);
        LOG.serviceProperties(this.properties);
        return this.buildConfiguration().buildSessionFactory(new ServiceRegistryBuilder().applySettings(this.properties).buildServiceRegistry());
    }

    @Override
    protected Map getExtraProperties() {
        return this.properties;
    }

    @Override
    public String getTransactionStrategy() {
        return this.getProperty("hibernate.transaction.factory_class");
    }

    @Override
    public void setTransactionStrategy(String txnStrategy) {
        this.setProperty("hibernate.transaction.factory_class", txnStrategy);
    }

    @Override
    public String getUserTransactionName() {
        return this.getProperty("jta.UserTransaction");
    }

    @Override
    public void setUserTransactionName(String utName) {
        this.setProperty("jta.UserTransaction", utName);
    }

    @Override
    public String getJtaPlatformName() {
        return this.getProperty("hibernate.transaction.jta.platform");
    }

    @Override
    public void setJtaPlatformName(String name) {
        this.setProperty("hibernate.transaction.jta.platform", name);
    }

    @Override
    public String getPropertyList() {
        return this.buildProperties().toString();
    }

    @Override
    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    @Override
    public void setProperty(String property, String value) {
        this.properties.setProperty(property, value);
    }

    @Override
    public void dropSchema() {
        new SchemaExport(this.buildConfiguration()).drop(false, true);
    }

    @Override
    public void createSchema() {
        new SchemaExport(this.buildConfiguration()).create(false, true);
    }

    public String getName() {
        return this.getProperty("hibernate.session_factory_name");
    }

    @Override
    public String getDatasource() {
        return this.getProperty("hibernate.connection.datasource");
    }

    @Override
    public void setDatasource(String datasource) {
        this.setProperty("hibernate.connection.datasource", datasource);
    }

    @Override
    public String getJndiName() {
        return this.getProperty("hibernate.session_factory_name");
    }

    @Override
    public void setJndiName(String jndiName) {
        this.setProperty("hibernate.session_factory_name", jndiName);
    }

    @Override
    public String getUserName() {
        return this.getProperty("hibernate.connection.username");
    }

    @Override
    public void setUserName(String userName) {
        this.setProperty("hibernate.connection.username", userName);
    }

    @Override
    public String getPassword() {
        return this.getProperty("hibernate.connection.password");
    }

    @Override
    public void setPassword(String password) {
        this.setProperty("hibernate.connection.password", password);
    }

    @Override
    public void setFlushBeforeCompletionEnabled(String enabled) {
        this.setProperty("hibernate.transaction.flush_before_completion", enabled);
    }

    @Override
    public String getFlushBeforeCompletionEnabled() {
        return this.getProperty("hibernate.transaction.flush_before_completion");
    }

    @Override
    public void setAutoCloseSessionEnabled(String enabled) {
        this.setProperty("hibernate.transaction.auto_close_session", enabled);
    }

    @Override
    public String getAutoCloseSessionEnabled() {
        return this.getProperty("hibernate.transaction.auto_close_session");
    }

    public Properties getProperties() {
        return this.buildProperties();
    }
}

