/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.SuspectedException;
import org.jgroups.TimeoutException;
import org.jgroups.UnreachableException;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.blocks.GroupRequest;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.UnicastRequest;
import org.jgroups.blocks.mux.Muxer;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.NotifyingFuture;
import org.jgroups.util.NullFuture;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.StateTransferResult;

public class MessageDispatcher
implements RequestHandler,
ChannelListener {
    protected Channel channel = null;
    protected RequestCorrelator corr = null;
    protected MessageListener msg_listener = null;
    protected MembershipListener membership_listener = null;
    protected RequestHandler req_handler = null;
    protected ProtocolAdapter prot_adapter = null;
    protected volatile Collection<Address> members = new HashSet<Address>();
    protected Address local_addr = null;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected boolean hardware_multicast_supported = false;
    protected final AtomicInteger sync_unicasts = new AtomicInteger(0);
    protected final AtomicInteger async_unicasts = new AtomicInteger(0);
    protected final AtomicInteger sync_multicasts = new AtomicInteger(0);
    protected final AtomicInteger async_multicasts = new AtomicInteger(0);
    protected final AtomicInteger sync_anycasts = new AtomicInteger(0);
    protected final AtomicInteger async_anycasts = new AtomicInteger(0);
    protected final Set<ChannelListener> channel_listeners = new CopyOnWriteArraySet<ChannelListener>();
    protected final DiagnosticsHandler.ProbeHandler probe_handler = new MyProbeHandler();

    public MessageDispatcher() {
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2) {
        this.channel = channel;
        this.prot_adapter = new ProtocolAdapter();
        if (channel != null) {
            this.local_addr = channel.getAddress();
            channel.addChannelListener(this);
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            this.installUpHandler(this.prot_adapter, true);
        }
        this.start();
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, RequestHandler req_handler) {
        this(channel, l, l2);
        this.setRequestHandler(req_handler);
    }

    public UpHandler getProtocolAdapter() {
        return this.prot_adapter;
    }

    protected void setMembers(List<Address> new_mbrs) {
        if (new_mbrs != null) {
            this.members = new HashSet<Address>(new_mbrs);
        }
    }

    public void addChannelListener(ChannelListener l) {
        if (l != null) {
            this.channel_listeners.add(l);
        }
    }

    public void removeChannelListener(ChannelListener l) {
        if (l != null) {
            this.channel_listeners.remove(l);
        }
    }

    public void start() {
        if (this.corr == null) {
            this.corr = this.createRequestCorrelator(this.prot_adapter, this, this.local_addr);
        }
        this.correlatorStarted();
        this.corr.start();
        if (this.channel != null) {
            TP transport;
            List<Address> tmp_mbrs = this.channel.getView() != null ? this.channel.getView().getMembers() : null;
            this.setMembers(tmp_mbrs);
            if (this.channel instanceof JChannel) {
                transport = this.channel.getProtocolStack().getTransport();
                this.corr.registerProbeHandler(transport);
            }
            transport = this.channel.getProtocolStack().getTransport();
            this.hardware_multicast_supported = transport.supportsMulticasting();
            transport.registerProbeHandler(this.probe_handler);
        }
    }

    protected RequestCorrelator createRequestCorrelator(Protocol transport, RequestHandler handler, Address local_addr) {
        return new RequestCorrelator(transport, handler, local_addr);
    }

    protected void correlatorStarted() {
    }

    public void stop() {
        if (this.corr != null) {
            this.corr.stop();
        }
        if (this.channel instanceof JChannel) {
            TP transport = this.channel.getProtocolStack().getTransport();
            transport.unregisterProbeHandler(this.probe_handler);
            this.corr.unregisterProbeHandler(transport);
        }
    }

    public final void setMessageListener(MessageListener l) {
        this.msg_listener = l;
    }

    public MessageListener getMessageListener() {
        return this.msg_listener;
    }

    public final void setMembershipListener(MembershipListener l) {
        this.membership_listener = l;
    }

    public final void setRequestHandler(RequestHandler rh) {
        this.req_handler = rh;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel ch) {
        if (ch == null) {
            return;
        }
        this.channel = ch;
        this.local_addr = this.channel.getAddress();
        if (this.prot_adapter == null) {
            this.prot_adapter = new ProtocolAdapter();
        }
        this.installUpHandler(this.prot_adapter, false);
    }

    protected void installUpHandler(UpHandler handler, boolean canReplace) {
        UpHandler existing = this.channel.getUpHandler();
        if (existing == null) {
            this.channel.setUpHandler(handler);
        } else if (existing instanceof Muxer) {
            Muxer mux = (Muxer)((Object)existing);
            if (mux.getDefaultHandler() == null) {
                mux.setDefaultHandler(handler);
            } else if (canReplace) {
                this.log.warn("Channel Muxer already has a default up handler installed (" + mux.getDefaultHandler() + ") but now it is being overridden");
                mux.setDefaultHandler(handler);
            }
        } else if (canReplace) {
            this.log.warn("Channel already has an up handler installed (" + existing + ") but now it is being overridden");
            this.channel.setUpHandler(handler);
        }
    }

    public <T> RspList<T> castMessage(Collection<Address> dests, Message msg, RequestOptions options) throws Exception {
        GroupRequest<T> req = this.cast(dests, msg, options, true);
        return req != null ? req.getResults() : new RspList();
    }

    public <T> NotifyingFuture<RspList<T>> castMessageWithFuture(Collection<Address> dests, Message msg, RequestOptions options) throws Exception {
        GroupRequest<T> req = this.cast(dests, msg, options, false);
        return req != null ? req : new NullFuture(new RspList());
    }

    protected <T> GroupRequest<T> cast(Collection<Address> dests, Message msg, RequestOptions options, boolean block_for_results) throws Exception {
        Channel tmp;
        ArrayList<Object> real_dests;
        if (dests != null) {
            real_dests = new ArrayList();
            for (Address dest : dests) {
                if (!(dest instanceof SiteAddress) && !this.members.contains(dest) || real_dests.contains(dest)) continue;
                real_dests.add(dest);
            }
        } else {
            real_dests = new ArrayList<Address>(this.members);
        }
        if ((tmp = this.channel) != null && tmp.getDiscardOwnMessages()) {
            if (this.local_addr == null) {
                this.local_addr = tmp.getAddress();
            }
            if (this.local_addr != null) {
                real_dests.remove(this.local_addr);
            }
        }
        if (options != null && options.hasExclusionList()) {
            Collection<Address> exclusion_list = options.getExclusionList();
            real_dests.removeAll(exclusion_list);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("real_dests=" + real_dests);
        }
        if (real_dests.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("destination list is empty, won't send message");
            }
            return null;
        }
        if (options != null) {
            boolean async;
            boolean bl = async = options.getMode() == ResponseMode.GET_NONE;
            if (options.getAnycasting()) {
                if (async) {
                    this.async_anycasts.incrementAndGet();
                } else {
                    this.sync_anycasts.incrementAndGet();
                }
            } else if (async) {
                this.async_multicasts.incrementAndGet();
            } else {
                this.sync_multicasts.incrementAndGet();
            }
        }
        GroupRequest req = new GroupRequest(msg, this.corr, real_dests, options);
        if (options != null) {
            req.setResponseFilter(options.getRspFilter());
            req.setAnycasting(options.getAnycasting());
            msg.setFlag(options.getFlags());
            if (options.getScope() > 0) {
                msg.setScope(options.getScope());
            }
        }
        req.setBlockForResults(block_for_results);
        req.execute();
        return req;
    }

    public void done(long req_id) {
        this.corr.done(req_id);
    }

    public <T> T sendMessage(Message msg, RequestOptions opts) throws Exception {
        Address dest = msg.getDest();
        if (dest == null) {
            throw new IllegalArgumentException("message destination is null, cannot send message");
        }
        if (opts != null) {
            msg.setFlag(opts.getFlags());
            if (opts.getScope() > 0) {
                msg.setScope(opts.getScope());
            }
            if (opts.getMode() == ResponseMode.GET_NONE) {
                this.async_unicasts.incrementAndGet();
            } else {
                this.sync_unicasts.incrementAndGet();
            }
        }
        UnicastRequest req = new UnicastRequest(msg, this.corr, dest, opts);
        req.execute();
        if (opts != null && opts.getMode() == ResponseMode.GET_NONE) {
            return null;
        }
        Rsp rsp = req.getResult();
        if (rsp.wasSuspected()) {
            throw new SuspectedException(dest);
        }
        Throwable exception = rsp.getException();
        if (exception != null) {
            if (exception instanceof Error) {
                throw (Error)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof Exception) {
                throw (Exception)exception;
            }
            throw new RuntimeException(exception);
        }
        if (rsp.wasUnreachable()) {
            throw new UnreachableException(dest);
        }
        if (!rsp.wasReceived() && !req.responseReceived()) {
            throw new TimeoutException("timeout sending message to " + dest);
        }
        return rsp.getValue();
    }

    public <T> NotifyingFuture<T> sendMessageWithFuture(Message msg, RequestOptions options) throws Exception {
        Address dest = msg.getDest();
        if (dest == null) {
            throw new IllegalArgumentException("message destination is null, cannot send message");
        }
        if (options != null) {
            msg.setFlag(options.getFlags());
            if (options.getScope() > 0) {
                msg.setScope(options.getScope());
            }
            if (options.getMode() == ResponseMode.GET_NONE) {
                this.async_unicasts.incrementAndGet();
            } else {
                this.sync_unicasts.incrementAndGet();
            }
        }
        UnicastRequest req = new UnicastRequest(msg, this.corr, dest, options);
        req.setBlockForResults(false);
        req.execute();
        if (options != null && options.getMode() == ResponseMode.GET_NONE) {
            return new NullFuture<Object>(null);
        }
        return req;
    }

    @Override
    public Object handle(Message msg) throws Exception {
        if (this.req_handler != null) {
            return this.req_handler.handle(msg);
        }
        return null;
    }

    @Override
    public void channelConnected(Channel channel) {
        for (ChannelListener l : this.channel_listeners) {
            try {
                l.channelConnected(channel);
            }
            catch (Throwable t) {
                this.log.warn("notifying channel listener " + l + " failed", t);
            }
        }
    }

    @Override
    public void channelDisconnected(Channel channel) {
        this.stop();
        for (ChannelListener l : this.channel_listeners) {
            try {
                l.channelDisconnected(channel);
            }
            catch (Throwable t) {
                this.log.warn("notifying channel listener " + l + " failed", t);
            }
        }
    }

    @Override
    public void channelClosed(Channel channel) {
        this.stop();
        for (ChannelListener l : this.channel_listeners) {
            try {
                l.channelClosed(channel);
            }
            catch (Throwable t) {
                this.log.warn("notifying channel listener " + l + " failed", t);
            }
        }
    }

    protected Object handleUpEvent(Event evt) throws Exception {
        switch (evt.getType()) {
            case 1: {
                if (this.msg_listener == null) break;
                this.msg_listener.receive((Message)evt.getArg());
                break;
            }
            case 17: {
                byte[] tmp_state = null;
                if (this.msg_listener != null) {
                    ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
                    this.msg_listener.getState(output);
                    tmp_state = output.toByteArray();
                }
                return new StateTransferInfo(null, 0L, tmp_state);
            }
            case 20: {
                if (this.msg_listener == null) break;
                StateTransferResult result = (StateTransferResult)evt.getArg();
                ByteArrayInputStream input = new ByteArrayInputStream(result.getBuffer());
                this.msg_listener.setState(input);
                break;
            }
            case 72: {
                OutputStream os = (OutputStream)evt.getArg();
                if (this.msg_listener == null || os == null) break;
                this.msg_listener.getState(os);
                break;
            }
            case 71: {
                InputStream is = (InputStream)evt.getArg();
                if (this.msg_listener == null || is == null) break;
                this.msg_listener.setState(is);
                break;
            }
            case 6: {
                View v = (View)evt.getArg();
                List<Address> new_mbrs = v.getMembers();
                this.setMembers(new_mbrs);
                if (this.membership_listener == null) break;
                this.membership_listener.viewAccepted(v);
                break;
            }
            case 8: {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("setting local_addr (" + this.local_addr + ") to " + evt.getArg());
                }
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 9: {
                if (this.membership_listener == null) break;
                this.membership_listener.suspect((Address)evt.getArg());
                break;
            }
            case 10: {
                if (this.membership_listener == null) break;
                this.membership_listener.block();
                break;
            }
            case 75: {
                if (this.membership_listener == null) break;
                this.membership_listener.unblock();
            }
        }
        return null;
    }

    class ProtocolAdapter
    extends Protocol
    implements UpHandler {
        ProtocolAdapter() {
        }

        @Override
        public String getName() {
            return "MessageDispatcher";
        }

        @Override
        public Object up(Event evt) {
            if (MessageDispatcher.this.corr != null && !MessageDispatcher.this.corr.receive(evt)) {
                try {
                    return MessageDispatcher.this.handleUpEvent(evt);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            return null;
        }

        @Override
        public Object down(Event evt) {
            if (MessageDispatcher.this.channel != null) {
                if (evt.getType() == 1 && !MessageDispatcher.this.channel.isConnected() && !MessageDispatcher.this.channel.isConnecting()) {
                    throw new IllegalStateException("channel is not connected");
                }
                return MessageDispatcher.this.channel.down(evt);
            }
            return null;
        }
    }

    class MyProbeHandler
    implements DiagnosticsHandler.ProbeHandler {
        MyProbeHandler() {
        }

        @Override
        public Map<String, String> handleProbe(String ... keys) {
            HashMap<String, String> retval = new HashMap<String, String>();
            for (String key : keys) {
                if ("rpcs".equals(key)) {
                    String channel_name = MessageDispatcher.this.channel != null ? MessageDispatcher.this.channel.getClusterName() : "";
                    retval.put(channel_name + ": sync  unicast   RPCs", MessageDispatcher.this.sync_unicasts.toString());
                    retval.put(channel_name + ": sync  multicast RPCs", MessageDispatcher.this.sync_multicasts.toString());
                    retval.put(channel_name + ": async unicast   RPCs", MessageDispatcher.this.async_unicasts.toString());
                    retval.put(channel_name + ": async multicast RPCs", MessageDispatcher.this.async_multicasts.toString());
                    retval.put(channel_name + ": sync  anycast   RPCs", MessageDispatcher.this.sync_anycasts.toString());
                    retval.put(channel_name + ": async anycast   RPCs", MessageDispatcher.this.async_anycasts.toString());
                }
                if (!"rpcs-reset".equals(key)) continue;
                MessageDispatcher.this.sync_unicasts.set(0);
                MessageDispatcher.this.sync_multicasts.set(0);
                MessageDispatcher.this.async_unicasts.set(0);
                MessageDispatcher.this.async_multicasts.set(0);
                MessageDispatcher.this.sync_anycasts.set(0);
                MessageDispatcher.this.async_anycasts.set(0);
            }
            return retval;
        }

        @Override
        public String[] supportedKeys() {
            return new String[]{"rpcs", "rpcs-reset"};
        }
    }
}

