/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.topology.ClusterCacheStatus;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.topology.RebalancePolicy;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DefaultRebalancePolicy
implements RebalancePolicy {
    private static Log log = LogFactory.getLog(DefaultRebalancePolicy.class);
    private ClusterTopologyManager clusterTopologyManager;

    @Inject
    public void inject(ClusterTopologyManager clusterTopologyManager) {
        this.clusterTopologyManager = clusterTopologyManager;
    }

    @Override
    public void initCache(String cacheName, ClusterCacheStatus cacheStatus) throws Exception {
        log.tracef("Initializing rebalance policy for cache %s", cacheName);
    }

    @Override
    public void updateCacheStatus(String cacheName, ClusterCacheStatus cacheStatus) throws Exception {
        log.tracef("Cache %s status changed: joiners=%s, topology=%s", cacheName, cacheStatus.getJoiners(), cacheStatus.getCacheTopology());
        if (!cacheStatus.hasMembers()) {
            log.tracef("Not triggering rebalance for zero-members cache %s", cacheName);
            return;
        }
        if (!cacheStatus.hasJoiners() && this.isBalanced(cacheStatus.getCacheTopology().getCurrentCH())) {
            log.tracef("Not triggering rebalance for cache %s, no joiners and the current consistent hash is already balanced", cacheName);
            return;
        }
        if (cacheStatus.isRebalanceInProgress()) {
            log.tracef("Not triggering rebalance for cache %s, a rebalance is already in progress", cacheName);
            return;
        }
        log.tracef("Triggering rebalance for cache %s", cacheName);
        this.clusterTopologyManager.triggerRebalance(cacheName);
    }

    public boolean isBalanced(ConsistentHash ch) {
        int numSegments = ch.getNumSegments();
        for (int i = 0; i < numSegments; ++i) {
            int actualNumOwners = Math.min(ch.getMembers().size(), ch.getNumOwners());
            if (ch.locateOwnersForSegment(i).size() == actualNumOwners) continue;
            return false;
        }
        return true;
    }
}

