/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.idp;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.picketlink.identity.federation.bindings.tomcat.TomcatRoleGenerator;
import org.picketlink.identity.federation.bindings.tomcat.idp.SecurityActions;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.handler.config.Handlers;
import org.picketlink.identity.federation.core.impl.DelegatedAttributeManager;
import org.picketlink.identity.federation.core.interfaces.AttributeManager;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.interfaces.RoleGenerator;
import org.picketlink.identity.federation.core.interfaces.TrustKeyConfigurationException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.interfaces.TrustKeyProcessingException;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.exceptions.IssueInstantMissingException;
import org.picketlink.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.picketlink.identity.federation.core.saml.v2.factories.SAML2HandlerChainFactory;
import org.picketlink.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.util.HandlerUtil;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.core.IdentityServer;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;
import org.picketlink.identity.federation.web.util.IDPWebRequestUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.w3c.dom.Document;

public class IDPWebBrowserSSOValve
extends ValveBase
implements Lifecycle {
    private static Logger log = Logger.getLogger(IDPWebBrowserSSOValve.class);
    private boolean trace = log.isTraceEnabled();
    protected IDPType idpConfiguration = null;
    private RoleGenerator roleGenerator = new TomcatRoleGenerator();
    private long assertionValidity = 5000L;
    private String identityURL = null;
    private TrustKeyManager keyManager;
    private Boolean ignoreIncomingSignatures = false;
    private Boolean signOutgoingMessages = true;
    private transient DelegatedAttributeManager attribManager = new DelegatedAttributeManager();
    private List<String> attributeKeys = new ArrayList<String>();
    private transient SAML2HandlerChain chain = null;
    private Context context = null;
    private transient String samlHandlerChainClass = null;
    protected String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    private Lock chainLock = new ReentrantLock();
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private boolean started = false;

    public void setAttributeList(String attribList) {
        if (attribList != null && !"".equals(attribList)) {
            this.attributeKeys.clear();
            StringTokenizer st = new StringTokenizer(attribList, ",");
            while (st != null && st.hasMoreTokens()) {
                this.attributeKeys.add(st.nextToken());
            }
        }
    }

    public Boolean getIgnoreIncomingSignatures() {
        return this.ignoreIncomingSignatures;
    }

    public void setIgnoreIncomingSignatures(Boolean ignoreIncomingSignature) {
        this.ignoreIncomingSignatures = ignoreIncomingSignature;
    }

    public void setIgnoreAttributesGeneration(Boolean ignoreAttributes) {
        if (ignoreAttributes == Boolean.TRUE) {
            this.attribManager = null;
        }
    }

    public Boolean getSignOutgoingMessages() {
        return this.signOutgoingMessages;
    }

    public void setSignOutgoingMessages(Boolean signOutgoingMessages) {
        this.signOutgoingMessages = signOutgoingMessages;
    }

    public void setRoleGenerator(String rgName) {
        try {
            Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(rgName);
            this.roleGenerator = (RoleGenerator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setSamlHandlerChainClass(String samlHandlerChainClass) {
        this.samlHandlerChainClass = samlHandlerChainClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        block214: {
            Principal userPrincipal;
            String referer = request.getHeader("Referer");
            String relayState = request.getParameter("RelayState");
            if (StringUtil.isNotNull((String)relayState)) {
                relayState = RedirectBindingUtil.urlDecode((String)relayState);
            }
            String samlRequestMessage = request.getParameter("SAMLRequest");
            String samlResponseMessage = request.getParameter("SAMLResponse");
            String signature = request.getParameter("Signature");
            String sigAlg = request.getParameter("SigAlg");
            boolean containsSAMLRequestMessage = StringUtil.isNotNull((String)samlRequestMessage);
            boolean containsSAMLResponseMessage = StringUtil.isNotNull((String)samlResponseMessage);
            Session session = request.getSessionInternal();
            if (containsSAMLRequestMessage || containsSAMLResponseMessage) {
                if (this.trace) {
                    log.trace((Object)"Storing the SAMLRequest/SAMLResponse and RelayState in session");
                }
                if (StringUtil.isNotNull((String)samlRequestMessage)) {
                    session.setNote("SAMLRequest", (Object)samlRequestMessage);
                }
                if (StringUtil.isNotNull((String)samlResponseMessage)) {
                    session.setNote("SAMLResponse", (Object)samlResponseMessage);
                }
                if (StringUtil.isNotNull((String)relayState)) {
                    session.setNote("RelayState", (Object)relayState.trim());
                }
                if (StringUtil.isNotNull((String)signature)) {
                    session.setNote("Signature", (Object)signature.trim());
                }
                if (StringUtil.isNotNull((String)sigAlg)) {
                    session.setNote("sigAlg", (Object)sigAlg.trim());
                }
            }
            if ((userPrincipal = request.getPrincipal()) == null) {
                try {
                    this.getNext().invoke(request, response);
                }
                finally {
                    userPrincipal = request.getPrincipal();
                    referer = request.getHeader("Referer");
                    if (this.trace) {
                        log.trace((Object)("Referer in finally block=" + referer + ":user principal=" + userPrincipal));
                    }
                }
            }
            IDPWebRequestUtil webRequestUtil = new IDPWebRequestUtil((HttpServletRequest)request, this.idpConfiguration, this.keyManager);
            webRequestUtil.setAttributeManager((AttributeManager)this.attribManager);
            webRequestUtil.setAttributeKeys(this.attributeKeys);
            Document samlErrorResponse = null;
            if (response.getStatus() == 403) {
                try {
                    samlErrorResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                    holder.setResponseDoc(samlErrorResponse).setDestination(referer).setRelayState(relayState).setAreWeSendingRequest(false).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
                    holder.setPostBindingRequested(webRequestUtil.hasSAMLRequestInPostProfile());
                    if (this.signOutgoingMessages.booleanValue()) {
                        holder.setSupportSignature(true).setPrivateKey(this.keyManager.getSigningKey());
                        webRequestUtil.send(holder);
                    }
                    webRequestUtil.send(holder);
                }
                catch (GeneralSecurityException e) {
                    throw new ServletException((Throwable)e);
                }
                return;
            }
            if (userPrincipal != null) {
                samlRequestMessage = (String)session.getNote("SAMLRequest");
                samlResponseMessage = (String)session.getNote("SAMLResponse");
                relayState = (String)session.getNote("RelayState");
                signature = (String)session.getNote("Signature");
                sigAlg = (String)session.getNote("sigAlg");
                if (this.trace) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Retrieved saml messages and relay state from session");
                    builder.append("saml Request message=").append(samlRequestMessage);
                    builder.append("::").append("SAMLResponseMessage=");
                    builder.append(samlResponseMessage).append(":").append("relay state=").append(relayState);
                    builder.append("Signature=").append(signature).append("::sigAlg=").append(sigAlg);
                    log.trace((Object)builder.toString());
                }
                if (StringUtil.isNotNull((String)samlRequestMessage)) {
                    session.removeNote("SAMLRequest");
                }
                if (StringUtil.isNotNull((String)samlResponseMessage)) {
                    session.removeNote("SAMLResponse");
                }
                if (StringUtil.isNotNull((String)relayState)) {
                    session.removeNote("RelayState");
                }
                if (StringUtil.isNotNull((String)signature)) {
                    session.removeNote("Signature");
                }
                if (StringUtil.isNotNull((String)sigAlg)) {
                    session.removeNote("sigAlg");
                }
                boolean willSendRequest = false;
                SAMLDocumentHolder samlDocumentHolder = null;
                SAML2Object samlObject = null;
                Document samlResponse = null;
                String destination = null;
                Boolean requestedPostProfile = null;
                if (samlRequestMessage != null) {
                    block210: {
                        RequestAbstractType requestAbstractType = null;
                        samlDocumentHolder = webRequestUtil.getSAMLDocumentHolder(samlRequestMessage);
                        samlObject = samlDocumentHolder.getSamlObject();
                        boolean isPost = webRequestUtil.hasSAMLRequestInPostProfile();
                        boolean isValid = this.validate(request.getRemoteAddr(), request.getQueryString(), new SessionHolder(samlRequestMessage, signature, sigAlg), isPost);
                        if (!isValid) {
                            throw new GeneralSecurityException("Validation check failed");
                        }
                        String issuer = null;
                        IssuerInfoHolder idpIssuer = new IssuerInfoHolder(this.identityURL);
                        HTTPContext protocolContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
                        DefaultSAML2HandlerRequest saml2HandlerRequest = new DefaultSAML2HandlerRequest((ProtocolContext)protocolContext, idpIssuer.getIssuer(), samlDocumentHolder, SAML2Handler.HANDLER_TYPE.IDP);
                        saml2HandlerRequest.setRelayState(relayState);
                        HashMap<String, Object> requestOptions = new HashMap<String, Object>();
                        if (this.ignoreIncomingSignatures.booleanValue()) {
                            requestOptions.put("IGNORE_SIGNATURES", Boolean.TRUE);
                        }
                        requestOptions.put("ROLE_GENERATOR", this.roleGenerator);
                        requestOptions.put("ASSERTIONS_VALIDITY", this.assertionValidity);
                        requestOptions.put("CONFIGURATION", this.idpConfiguration);
                        if (this.keyManager != null) {
                            String remoteHost = request.getRemoteAddr();
                            if (this.trace) {
                                log.trace((Object)("Remote Host=" + remoteHost));
                            }
                            PublicKey validatingKey = CoreConfigUtil.getValidatingKey((TrustKeyManager)this.keyManager, (String)remoteHost);
                            requestOptions.put("SENDER_PUBLIC_KEY", validatingKey);
                        }
                        Map attribs = this.attribManager.getAttributes(userPrincipal, this.attributeKeys);
                        requestOptions.put("ATTRIBUTES", attribs);
                        saml2HandlerRequest.setOptions(requestOptions);
                        List roles = this.roleGenerator.generateRoles(userPrincipal);
                        session.getSession().setAttribute("jboss_identity.roles", (Object)roles);
                        DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
                        Set handlers = this.chain.handlers();
                        if (this.trace) {
                            log.trace((Object)("Handlers are=" + handlers));
                        }
                        if (samlObject instanceof RequestAbstractType) {
                            requestAbstractType = (RequestAbstractType)samlObject;
                            issuer = requestAbstractType.getIssuer().getValue();
                            webRequestUtil.isTrusted(issuer);
                            if (handlers != null) {
                                try {
                                    this.chainLock.lock();
                                    for (SAML2Handler handler : handlers) {
                                        handler.handleRequestType((SAML2HandlerRequest)saml2HandlerRequest, (SAML2HandlerResponse)saml2HandlerResponse);
                                        willSendRequest = saml2HandlerResponse.getSendRequest();
                                    }
                                    Object var36_64 = null;
                                    this.chainLock.unlock();
                                }
                                catch (Throwable throwable) {
                                    Object var36_65 = null;
                                    this.chainLock.unlock();
                                    throw throwable;
                                }
                            }
                        } else {
                            throw new RuntimeException("Unknown type:" + samlObject.getClass().getName());
                        }
                        samlResponse = saml2HandlerResponse.getResultingDocument();
                        relayState = saml2HandlerResponse.getRelayState();
                        destination = saml2HandlerResponse.getDestination();
                        requestedPostProfile = saml2HandlerResponse.isPostBindingForResponse();
                        Object var38_67 = null;
                        try {
                            boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                            if (postProfile) {
                                this.recycle(response);
                            }
                            IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                            holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
                            if (requestedPostProfile != null) {
                                holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                            } else {
                                holder.setPostBindingRequested(postProfile);
                            }
                            if (this.signOutgoingMessages.booleanValue()) {
                                holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                            }
                            webRequestUtil.send(holder);
                        }
                        catch (ParsingException e2) {
                            if (this.trace) {
                                log.trace((Object)"Parsing exception:", (Throwable)e2);
                            }
                            break block210;
                        }
                        catch (GeneralSecurityException e3) {
                            if (this.trace) {
                                log.trace((Object)"Security Exception:", (Throwable)e3);
                            }
                            break block210;
                        }
                        {
                            catch (IssuerNotTrustedException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var38_68 = null;
                                try {
                                    boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                                    if (postProfile) {
                                        this.recycle(response);
                                    }
                                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
                                    if (requestedPostProfile != null) {
                                        holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                                    } else {
                                        holder.setPostBindingRequested(postProfile);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                                    }
                                    webRequestUtil.send(holder);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e2);
                                    }
                                    break block210;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e3);
                                    }
                                    break block210;
                                }
                            }
                            catch (ParsingException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var38_69 = null;
                                try {
                                    boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                                    if (postProfile) {
                                        this.recycle(response);
                                    }
                                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
                                    if (requestedPostProfile != null) {
                                        holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                                    } else {
                                        holder.setPostBindingRequested(postProfile);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                                    }
                                    webRequestUtil.send(holder);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e2);
                                    }
                                    break block210;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e3);
                                    }
                                    break block210;
                                }
                            }
                            catch (ConfigurationException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var38_70 = null;
                                try {
                                    boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                                    if (postProfile) {
                                        this.recycle(response);
                                    }
                                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
                                    if (requestedPostProfile != null) {
                                        holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                                    } else {
                                        holder.setPostBindingRequested(postProfile);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                                    }
                                    webRequestUtil.send(holder);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e2);
                                    }
                                    break block210;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e3);
                                    }
                                    break block210;
                                }
                            }
                            catch (IssueInstantMissingException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var38_71 = null;
                                try {
                                    boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                                    if (postProfile) {
                                        this.recycle(response);
                                    }
                                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
                                    if (requestedPostProfile != null) {
                                        holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                                    } else {
                                        holder.setPostBindingRequested(postProfile);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                                    }
                                    webRequestUtil.send(holder);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e2);
                                    }
                                    break block210;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e3);
                                    }
                                    break block210;
                                }
                            }
                            catch (GeneralSecurityException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var38_72 = null;
                                try {
                                    boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                                    if (postProfile) {
                                        this.recycle(response);
                                    }
                                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
                                    if (requestedPostProfile != null) {
                                        holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                                    } else {
                                        holder.setPostBindingRequested(postProfile);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                                    }
                                    webRequestUtil.send(holder);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e2);
                                    }
                                    break block210;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e3);
                                    }
                                    break block210;
                                }
                            }
                            catch (Exception e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var38_73 = null;
                                try {
                                    boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                                    if (postProfile) {
                                        this.recycle(response);
                                    }
                                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
                                    if (requestedPostProfile != null) {
                                        holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                                    } else {
                                        holder.setPostBindingRequested(postProfile);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                                    }
                                    webRequestUtil.send(holder);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e2);
                                    }
                                    break block210;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e3);
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            block211: {
                                Object var38_74 = null;
                                try {
                                    boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                                    if (postProfile) {
                                        this.recycle(response);
                                    }
                                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
                                    if (requestedPostProfile != null) {
                                        holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                                    } else {
                                        holder.setPostBindingRequested(postProfile);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                                    }
                                    webRequestUtil.send(holder);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e2);
                                    }
                                }
                                catch (GeneralSecurityException e3) {
                                    if (!this.trace) break block211;
                                    log.trace((Object)"Security Exception:", (Throwable)e3);
                                }
                            }
                            throw throwable;
                        }
                    }
                    return;
                }
                if (StringUtil.isNotNull((String)samlResponseMessage)) {
                    block212: {
                        StatusResponseType statusResponseType = null;
                        samlDocumentHolder = webRequestUtil.getSAMLDocumentHolder(samlResponseMessage);
                        samlObject = samlDocumentHolder.getSamlObject();
                        boolean isPost = webRequestUtil.hasSAMLRequestInPostProfile();
                        boolean isValid = false;
                        String remoteAddress = request.getRemoteAddr();
                        if (isPost) {
                            SAML2Signature samlSignature = new SAML2Signature();
                            if (!this.ignoreIncomingSignatures.booleanValue() && this.signOutgoingMessages.booleanValue()) {
                                PublicKey publicKey = this.keyManager.getValidatingKey(remoteAddress);
                                isValid = samlSignature.validate(samlDocumentHolder.getSamlDocument(), publicKey);
                            } else {
                                isValid = true;
                            }
                        } else {
                            isValid = this.validate(remoteAddress, request.getQueryString(), new SessionHolder(samlResponseMessage, signature, sigAlg), isPost);
                        }
                        if (!isValid) {
                            throw new GeneralSecurityException("Validation check failed");
                        }
                        String issuer = null;
                        IssuerInfoHolder idpIssuer = new IssuerInfoHolder(this.identityURL);
                        HTTPContext protocolContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
                        DefaultSAML2HandlerRequest saml2HandlerRequest = new DefaultSAML2HandlerRequest((ProtocolContext)protocolContext, idpIssuer.getIssuer(), samlDocumentHolder, SAML2Handler.HANDLER_TYPE.IDP);
                        saml2HandlerRequest.setRelayState(relayState);
                        DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
                        Set handlers = this.chain.handlers();
                        if (samlObject instanceof StatusResponseType) {
                            statusResponseType = (StatusResponseType)samlObject;
                            issuer = statusResponseType.getIssuer().getValue();
                            webRequestUtil.isTrusted(issuer);
                            if (handlers != null) {
                                try {
                                    this.chainLock.lock();
                                    for (SAML2Handler handler : handlers) {
                                        handler.reset();
                                        handler.handleStatusResponseType((SAML2HandlerRequest)saml2HandlerRequest, (SAML2HandlerResponse)saml2HandlerResponse);
                                        willSendRequest = saml2HandlerResponse.getSendRequest();
                                    }
                                    Object var42_108 = null;
                                    this.chainLock.unlock();
                                }
                                catch (Throwable throwable) {
                                    Object var42_109 = null;
                                    this.chainLock.unlock();
                                    throw throwable;
                                }
                            }
                        } else {
                            throw new RuntimeException("Unknown type:" + samlObject.getClass().getName());
                        }
                        samlResponse = saml2HandlerResponse.getResultingDocument();
                        relayState = saml2HandlerResponse.getRelayState();
                        destination = saml2HandlerResponse.getDestination();
                        requestedPostProfile = saml2HandlerResponse.isPostBindingForResponse();
                        Object var44_111 = null;
                        try {
                            boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                            if (postProfile) {
                                this.recycle(response);
                            }
                            IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                            holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response).setPostBindingRequested(requestedPostProfile.booleanValue());
                            if (requestedPostProfile != null) {
                                holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                            } else {
                                holder.setPostBindingRequested(postProfile);
                            }
                            if (this.signOutgoingMessages.booleanValue()) {
                                holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                            }
                            webRequestUtil.send(holder);
                        }
                        catch (ParsingException e4) {
                            if (this.trace) {
                                log.trace((Object)"Parsing exception:", (Throwable)e4);
                            }
                            break block212;
                        }
                        catch (GeneralSecurityException e5) {
                            if (this.trace) {
                                log.trace((Object)"Security Exception:", (Throwable)e5);
                            }
                            break block212;
                        }
                        {
                            catch (IssuerNotTrustedException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var44_112 = null;
                                try {
                                    boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                                    if (postProfile) {
                                        this.recycle(response);
                                    }
                                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response).setPostBindingRequested(requestedPostProfile.booleanValue());
                                    if (requestedPostProfile != null) {
                                        holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                                    } else {
                                        holder.setPostBindingRequested(postProfile);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                                    }
                                    webRequestUtil.send(holder);
                                }
                                catch (ParsingException e4) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e4);
                                    }
                                    break block212;
                                }
                                catch (GeneralSecurityException e5) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e5);
                                    }
                                    break block212;
                                }
                            }
                            catch (ParsingException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var44_113 = null;
                                try {
                                    boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                                    if (postProfile) {
                                        this.recycle(response);
                                    }
                                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response).setPostBindingRequested(requestedPostProfile.booleanValue());
                                    if (requestedPostProfile != null) {
                                        holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                                    } else {
                                        holder.setPostBindingRequested(postProfile);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                                    }
                                    webRequestUtil.send(holder);
                                }
                                catch (ParsingException e4) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e4);
                                    }
                                    break block212;
                                }
                                catch (GeneralSecurityException e5) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e5);
                                    }
                                    break block212;
                                }
                            }
                            catch (ConfigurationException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var44_114 = null;
                                try {
                                    boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                                    if (postProfile) {
                                        this.recycle(response);
                                    }
                                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response).setPostBindingRequested(requestedPostProfile.booleanValue());
                                    if (requestedPostProfile != null) {
                                        holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                                    } else {
                                        holder.setPostBindingRequested(postProfile);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                                    }
                                    webRequestUtil.send(holder);
                                }
                                catch (ParsingException e4) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e4);
                                    }
                                    break block212;
                                }
                                catch (GeneralSecurityException e5) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e5);
                                    }
                                    break block212;
                                }
                            }
                            catch (IssueInstantMissingException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var44_115 = null;
                                try {
                                    boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                                    if (postProfile) {
                                        this.recycle(response);
                                    }
                                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response).setPostBindingRequested(requestedPostProfile.booleanValue());
                                    if (requestedPostProfile != null) {
                                        holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                                    } else {
                                        holder.setPostBindingRequested(postProfile);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                                    }
                                    webRequestUtil.send(holder);
                                }
                                catch (ParsingException e4) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e4);
                                    }
                                    break block212;
                                }
                                catch (GeneralSecurityException e5) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e5);
                                    }
                                    break block212;
                                }
                            }
                            catch (GeneralSecurityException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var44_116 = null;
                                try {
                                    boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                                    if (postProfile) {
                                        this.recycle(response);
                                    }
                                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response).setPostBindingRequested(requestedPostProfile.booleanValue());
                                    if (requestedPostProfile != null) {
                                        holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                                    } else {
                                        holder.setPostBindingRequested(postProfile);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                                    }
                                    webRequestUtil.send(holder);
                                }
                                catch (ParsingException e4) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e4);
                                    }
                                    break block212;
                                }
                                catch (GeneralSecurityException e5) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e5);
                                    }
                                    break block212;
                                }
                            }
                            catch (Exception e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var44_117 = null;
                                try {
                                    boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                                    if (postProfile) {
                                        this.recycle(response);
                                    }
                                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response).setPostBindingRequested(requestedPostProfile.booleanValue());
                                    if (requestedPostProfile != null) {
                                        holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                                    } else {
                                        holder.setPostBindingRequested(postProfile);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                                    }
                                    webRequestUtil.send(holder);
                                }
                                catch (ParsingException e4) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e4);
                                    }
                                    break block212;
                                }
                                catch (GeneralSecurityException e5) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e5);
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            block213: {
                                Object var44_118 = null;
                                try {
                                    boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                                    if (postProfile) {
                                        this.recycle(response);
                                    }
                                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response).setPostBindingRequested(requestedPostProfile.booleanValue());
                                    if (requestedPostProfile != null) {
                                        holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                                    } else {
                                        holder.setPostBindingRequested(postProfile);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                                    }
                                    webRequestUtil.send(holder);
                                }
                                catch (ParsingException e4) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e4);
                                    }
                                }
                                catch (GeneralSecurityException e5) {
                                    if (!this.trace) break block213;
                                    log.trace((Object)"Security Exception:", (Throwable)e5);
                                }
                            }
                            throw throwable;
                        }
                    }
                    return;
                }
                log.error((Object)"No SAML Request or Response Message");
                if (this.trace) {
                    log.trace((Object)("Referer=" + referer));
                }
                try {
                    this.sendErrorResponseToSP(referer, response, relayState, webRequestUtil);
                }
                catch (ConfigurationException e) {
                    if (!this.trace) break block214;
                    log.trace((Object)e);
                }
            }
        }
    }

    protected void sendErrorResponseToSP(String referrer, Response response, String relayState, IDPWebRequestUtil webRequestUtil) throws ServletException, IOException, ConfigurationException {
        if (this.trace) {
            log.trace((Object)("About to send error response to SP:" + referrer));
        }
        Document samlResponse = webRequestUtil.getErrorResponse(referrer, JBossSAMLURIConstants.STATUS_RESPONDER.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
        try {
            boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
            if (postProfile) {
                this.recycle(response);
            }
            IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
            holder.setResponseDoc(samlResponse).setDestination(referrer).setRelayState(relayState).setAreWeSendingRequest(false).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
            holder.setPostBindingRequested(postProfile);
            if (this.signOutgoingMessages.booleanValue()) {
                holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
            }
            webRequestUtil.send(holder);
        }
        catch (ParsingException e1) {
            throw new ServletException((Throwable)e1);
        }
        catch (GeneralSecurityException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected boolean validate(String remoteAddress, String queryString, SessionHolder holder, boolean isPost) throws IOException, GeneralSecurityException {
        if (!StringUtil.isNotNull((String)holder.samlRequest)) {
            return false;
        }
        if (!this.ignoreIncomingSignatures.booleanValue() && !isPost) {
            PublicKey validatingKey;
            String sig = holder.signature;
            if (!StringUtil.isNotNull((String)sig)) {
                log.error((Object)("Signature received from SP is null:" + remoteAddress));
                return false;
            }
            byte[] sigValue = RedirectBindingSignatureUtil.getSignatureValueFromSignedURL((String)queryString);
            if (sigValue == null) {
                return false;
            }
            try {
                validatingKey = this.keyManager.getValidatingKey(remoteAddress);
            }
            catch (TrustKeyConfigurationException e) {
                throw new GeneralSecurityException(e.getCause());
            }
            catch (TrustKeyProcessingException e) {
                throw new GeneralSecurityException(e.getCause());
            }
            return RedirectBindingSignatureUtil.validateSignature((String)queryString, (PublicKey)validatingKey, (byte[])sigValue);
        }
        return true;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        Handlers handlers = null;
        if (this.started) {
            throw new LifecycleException("IDPWebBrowserSSOValve already Started");
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (StringUtil.isNullOrEmpty((String)this.samlHandlerChainClass)) {
            this.chain = SAML2HandlerChainFactory.createChain();
        } else {
            try {
                this.chain = SAML2HandlerChainFactory.createChain((String)this.samlHandlerChainClass);
            }
            catch (ProcessingException e1) {
                throw new LifecycleException((Throwable)e1);
            }
        }
        String configFile = "/WEB-INF/picketlink-idfed.xml";
        this.context = (Context)this.getContainer();
        InputStream is = this.context.getServletContext().getResourceAsStream(configFile);
        if (is == null) {
            throw new RuntimeException(configFile + " missing");
        }
        try {
            this.idpConfiguration = ConfigurationUtil.getIDPConfiguration((InputStream)is);
            this.identityURL = this.idpConfiguration.getIdentityURL();
            if (this.trace) {
                log.trace((Object)("Identity Provider URL=" + this.identityURL));
            }
            this.assertionValidity = this.idpConfiguration.getAssertionValidity();
            this.canonicalizationMethod = this.idpConfiguration.getCanonicalizationMethod();
            log.info((Object)("IDPWebBrowserSSOValve:: Setting the CanonicalizationMethod on XMLSignatureUtil::" + this.canonicalizationMethod));
            XMLSignatureUtil.setCanonicalizationMethodType((String)this.canonicalizationMethod);
            String attributeManager = this.idpConfiguration.getAttributeManager();
            if (attributeManager != null && !"".equals(attributeManager)) {
                ClassLoader tcl = SecurityActions.getContextClassLoader();
                AttributeManager delegate = (AttributeManager)tcl.loadClass(attributeManager).newInstance();
                this.attribManager.setDelegate(delegate);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.signOutgoingMessages.booleanValue()) {
            KeyProviderType keyProvider = this.idpConfiguration.getKeyProvider();
            if (keyProvider == null) {
                throw new LifecycleException("Key Provider is null for context=" + this.context.getName());
            }
            try {
                this.keyManager = CoreConfigUtil.getTrustKeyManager((KeyProviderType)keyProvider);
                List authProperties = CoreConfigUtil.getKeyProviderProperties((KeyProviderType)keyProvider);
                this.keyManager.setAuthProperties(authProperties);
                this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
            }
            catch (Exception e) {
                log.error((Object)"Exception reading configuration:", (Throwable)e);
                throw new LifecycleException(e.getLocalizedMessage());
            }
            if (this.trace) {
                log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
            }
        }
        try {
            String handlerConfigFileName = "/WEB-INF/picketlink-handlers.xml";
            handlers = ConfigurationUtil.getHandlers((InputStream)this.context.getServletContext().getResourceAsStream(handlerConfigFileName));
            this.chain.addAll((Collection)HandlerUtil.getHandlers((Handlers)handlers));
            HashMap<String, Object> chainConfigOptions = new HashMap<String, Object>();
            chainConfigOptions.put("ROLE_GENERATOR", this.roleGenerator);
            chainConfigOptions.put("CONFIGURATION", this.idpConfiguration);
            chainConfigOptions.put("CANONICALIZATION_METHOD", this.canonicalizationMethod);
            if (this.keyManager != null) {
                chainConfigOptions.put("KEYPAIR", this.keyManager.getSigningKeyPair());
            }
            DefaultSAML2HandlerChainConfig handlerChainConfig = new DefaultSAML2HandlerChainConfig(chainConfigOptions);
            Set samlHandlers = this.chain.handlers();
            for (SAML2Handler handler : samlHandlers) {
                handler.initChainConfig((SAML2HandlerChainConfig)handlerChainConfig);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception dealing with handler configuration:", (Throwable)e);
            throw new LifecycleException(e.getLocalizedMessage());
        }
        String[] ak = new String[]{"mail", "cn", "commonname", "givenname", "surname", "employeeType", "employeeNumber", "facsimileTelephoneNumber"};
        this.attributeKeys.addAll(Arrays.asList(ak));
        IdentityServer identityServer = (IdentityServer)this.context.getServletContext().getAttribute("IDENTITY_SERVER");
        if (identityServer == null) {
            identityServer = new IdentityServer();
            this.context.getServletContext().setAttribute("IDENTITY_SERVER", (Object)identityServer);
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException("IDPWebBrowserSSOValve NotStarted");
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }

    private void recycle(Response response) {
        response.recycle();
    }

    protected static class SessionHolder {
        String samlRequest;
        String signature;
        String sigAlg;

        public SessionHolder(String req, String sig, String alg) {
            this.samlRequest = req;
            this.signature = sig;
            this.sigAlg = alg;
        }
    }
}

