/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.sp;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.config.SPType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.handler.config.Handlers;
import org.picketlink.identity.federation.core.saml.v2.factories.SAML2HandlerChainFactory;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.util.HandlerUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;

public class BaseFormAuthenticator
extends FormAuthenticator {
    private static Logger log = Logger.getLogger(BaseFormAuthenticator.class);
    private boolean trace = log.isTraceEnabled();
    protected SPType spConfiguration = null;
    protected String serviceURL = null;
    protected String identityURL = null;
    protected String configFile = "/WEB-INF/picketlink-idfed.xml";
    protected transient SAML2HandlerChain chain = null;
    protected transient String samlHandlerChainClass = null;
    protected Map<String, Object> chainConfigOptions = new HashMap<String, Object>();
    protected Lock chainLock = new ReentrantLock();
    protected String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setSamlHandlerChainClass(String samlHandlerChainClass) {
        this.samlHandlerChainClass = samlHandlerChainClass;
    }

    protected boolean validate(Request request) throws IOException, GeneralSecurityException {
        return request.getParameter("SAMLResponse") != null;
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        if (response instanceof Response) {
            Response catalinaResponse = (Response)response;
            return this.authenticate(request, catalinaResponse, config);
        }
        throw new RuntimeException("Response was not of type catalina response");
    }

    public void start() throws LifecycleException {
        super.start();
        this.processStart();
    }

    public void testStart() throws LifecycleException {
        this.processStart();
    }

    private void processStart() throws LifecycleException {
        Handlers handlers = null;
        ServletContext servletContext = this.context.getServletContext();
        InputStream is = servletContext.getResourceAsStream(this.configFile);
        if (is == null) {
            throw new RuntimeException(this.configFile + " missing");
        }
        if (StringUtil.isNullOrEmpty((String)this.samlHandlerChainClass)) {
            this.chain = SAML2HandlerChainFactory.createChain();
        } else {
            try {
                this.chain = SAML2HandlerChainFactory.createChain((String)this.samlHandlerChainClass);
            }
            catch (ProcessingException e1) {
                throw new LifecycleException((Throwable)e1);
            }
        }
        try {
            this.spConfiguration = ConfigurationUtil.getSPConfiguration((InputStream)is);
            this.identityURL = this.spConfiguration.getIdentityURL();
            this.serviceURL = this.spConfiguration.getServiceURL();
            this.canonicalizationMethod = this.spConfiguration.getCanonicalizationMethod();
            log.info((Object)("BaseFormAuthenticator:: Setting the CanonicalizationMethod on XMLSignatureUtil::" + this.canonicalizationMethod));
            XMLSignatureUtil.setCanonicalizationMethodType((String)this.canonicalizationMethod);
            if (this.trace) {
                log.trace((Object)("Identity Provider URL=" + this.identityURL));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            String handlerConfigFileName = "/WEB-INF/picketlink-handlers.xml";
            handlers = ConfigurationUtil.getHandlers((InputStream)servletContext.getResourceAsStream(handlerConfigFileName));
            this.chain.addAll((Collection)HandlerUtil.getHandlers((Handlers)handlers));
            this.populateChainConfig();
            this.initializeHandlerChain();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void initializeHandlerChain() throws ConfigurationException, ProcessingException {
        this.populateChainConfig();
        DefaultSAML2HandlerChainConfig handlerChainConfig = new DefaultSAML2HandlerChainConfig(this.chainConfigOptions);
        Set samlHandlers = this.chain.handlers();
        for (SAML2Handler handler : samlHandlers) {
            handler.initChainConfig((SAML2HandlerChainConfig)handlerChainConfig);
        }
    }

    protected void populateChainConfig() throws ConfigurationException, ProcessingException {
        this.chainConfigOptions.put("CONFIGURATION", this.spConfiguration);
        this.chainConfigOptions.put("CANONICALIZATION_METHOD", this.canonicalizationMethod);
        this.chainConfigOptions.put("ROLE_VALIDATOR_IGNORE", "false");
    }
}

