/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.XMLEncryptionUtil;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.wrappers.Lifetime;
import org.picketlink.identity.federation.ws.addressing.AttributedURIType;
import org.picketlink.identity.federation.ws.addressing.EndpointReferenceType;
import org.picketlink.identity.federation.ws.policy.AppliesTo;
import org.picketlink.identity.federation.ws.trust.BinarySecretType;
import org.picketlink.identity.federation.ws.trust.EntropyType;
import org.picketlink.identity.federation.ws.trust.RequestedReferenceType;
import org.picketlink.identity.federation.ws.wss.secext.KeyIdentifierType;
import org.picketlink.identity.federation.ws.wss.secext.SecurityTokenReferenceType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.picketlink.identity.xmlsec.w3.xmldsig.ObjectFactory;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509DataType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSTrustUtil {
    private static Logger logger = Logger.getLogger(WSTrustUtil.class);

    public static KeyIdentifierType createKeyIdentifier(String valueType, String value) {
        KeyIdentifierType keyIdentifier = new KeyIdentifierType();
        keyIdentifier.setValueType(valueType);
        keyIdentifier.setValue(value);
        return keyIdentifier;
    }

    public static RequestedReferenceType createRequestedReference(KeyIdentifierType keyIdentifier, Map<QName, String> attributes) {
        SecurityTokenReferenceType securityTokenReference = new SecurityTokenReferenceType();
        securityTokenReference.getAny().add(new org.picketlink.identity.federation.ws.wss.secext.ObjectFactory().createKeyIdentifier(keyIdentifier));
        securityTokenReference.getOtherAttributes().putAll(attributes);
        RequestedReferenceType reference = new RequestedReferenceType();
        reference.setSecurityTokenReference(securityTokenReference);
        return reference;
    }

    public static AppliesTo createAppliesTo(String endpointURI) {
        AttributedURIType attributedURI = new AttributedURIType();
        attributedURI.setValue(endpointURI);
        EndpointReferenceType reference = new EndpointReferenceType();
        reference.setAddress(attributedURI);
        AppliesTo appliesTo = new AppliesTo();
        appliesTo.getAny().add(new org.picketlink.identity.federation.ws.addressing.ObjectFactory().createEndpointReference(reference));
        return appliesTo;
    }

    public static String parseAppliesTo(AppliesTo appliesTo) {
        EndpointReferenceType reference = null;
        for (Object obj : appliesTo.getAny()) {
            JAXBElement element;
            if (obj instanceof EndpointReferenceType) {
                reference = (EndpointReferenceType)obj;
            } else if (obj instanceof JAXBElement && (element = (JAXBElement)obj).getName().getLocalPart().equalsIgnoreCase("EndpointReference")) {
                reference = (EndpointReferenceType)element.getValue();
            }
            if (reference == null || reference.getAddress() == null) continue;
            return reference.getAddress().getValue();
        }
        return null;
    }

    public static Lifetime createDefaultLifetime(long tokenTimeout) {
        GregorianCalendar created = new GregorianCalendar();
        GregorianCalendar expires = new GregorianCalendar();
        expires.setTimeInMillis(created.getTimeInMillis() + tokenTimeout);
        return new Lifetime(created, expires);
    }

    public static byte[] getBinarySecret(EntropyType entropy) {
        byte[] secret = null;
        for (Object obj : entropy.getAny()) {
            JAXBElement element = (JAXBElement)obj;
            if (!element.getDeclaredType().equals(BinarySecretType.class)) continue;
            BinarySecretType binarySecret = (BinarySecretType)element.getValue();
            secret = binarySecret.getValue();
            break;
        }
        return secret;
    }

    public static byte[] createRandomSecret(int size) {
        SecureRandom random = new SecureRandom();
        byte[] secret = new byte[size];
        random.nextBytes(secret);
        return secret;
    }

    public static byte[] P_SHA1(byte[] secret, byte[] seed, int requiredSize) throws NoSuchAlgorithmException, InvalidKeyException {
        int offset = 0;
        byte[] result = new byte[requiredSize];
        SecretKeySpec key = new SecretKeySpec(secret, "HMACSHA1");
        Mac mac = Mac.getInstance("HMACSHA1");
        byte[] A = seed;
        while (requiredSize > 0) {
            mac.init(key);
            mac.update(A);
            A = mac.doFinal();
            mac.reset();
            mac.init(key);
            mac.update(A);
            mac.update(seed);
            byte[] partialResult = mac.doFinal();
            int copySize = Math.min(requiredSize, partialResult.length);
            System.arraycopy(partialResult, 0, result, offset, copySize);
            offset += copySize;
            requiredSize -= copySize;
        }
        return result;
    }

    public static KeyInfoType createKeyInfo(byte[] secret, PublicKey encryptionKey, URI keyWrapAlgo) throws WSTrustException {
        KeyInfoType keyInfo = null;
        if (encryptionKey != null) {
            try {
                Document document = DocumentUtil.createDocument();
                EncryptedKey key = XMLEncryptionUtil.encryptKey(document, new SecretKeySpec(secret, "AES"), encryptionKey, secret.length * 8);
                Element encryptedKeyElement = XMLCipher.getInstance().martial(key);
                keyInfo = new KeyInfoType();
                keyInfo.getContent().add(encryptedKeyElement);
            }
            catch (Exception e) {
                throw new WSTrustException("Error creating KeyInfoType", e);
            }
        } else {
            logger.warn((Object)"Secret key could not be encrypted because the endpoint's PKC has not been specified");
        }
        return keyInfo;
    }

    public static KeyInfoType createKeyInfo(Certificate certificate) throws WSTrustException {
        KeyInfoType keyInfo = null;
        try {
            byte[] encodedCert = certificate.getEncoded();
            ObjectFactory factory = new ObjectFactory();
            X509DataType dataType = factory.createX509DataType();
            dataType.getX509IssuerSerialOrX509SKIOrX509SubjectName().add(factory.createX509DataTypeX509Certificate(encodedCert));
            keyInfo = new KeyInfoType();
            keyInfo.getContent().add(factory.createX509Data(dataType));
        }
        catch (Exception e) {
            throw new WSTrustException("Error creating KeyInfoType", e);
        }
        return keyInfo;
    }
}

