/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.config.SPType;
import org.picketlink.identity.federation.core.config.TrustType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.web.handlers.saml2.BaseSAML2Handler;

public class SAML2IssuerTrustHandler
extends BaseSAML2Handler {
    private static Logger log = Logger.getLogger(SAML2IssuerTrustHandler.class);
    private boolean trace = log.isTraceEnabled();
    private IDPTrustHandler idp = new IDPTrustHandler();
    private SPTrustHandler sp = new SPTrustHandler();

    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.handleRequestType(request, response, (IDPType)this.handlerChainConfig.getParameter("CONFIGURATION"));
        } else {
            this.sp.handleRequestType(request, response, (SPType)this.handlerChainConfig.getParameter("CONFIGURATION"));
        }
    }

    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.handleStatusResponseType(request, response, (IDPType)this.handlerChainConfig.getParameter("CONFIGURATION"));
        } else {
            this.sp.handleStatusResponseType(request, response, (SPType)this.handlerChainConfig.getParameter("CONFIGURATION"));
        }
    }

    private static String getDomain(String domainURL) throws IOException {
        URL url = new URL(domainURL);
        return url.getHost();
    }

    private class SPTrustHandler {
        private SPTrustHandler() {
        }

        public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response, SPType spConfiguration) throws ProcessingException {
            String issuer = request.getIssuer().getValue();
            this.trustIssuer(spConfiguration, issuer);
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response, SPType spConfiguration) throws ProcessingException {
            String issuer = request.getIssuer().getValue();
            this.trustIssuer(spConfiguration, issuer);
        }

        private void trustIssuer(SPType spConfiguration, String issuer) throws ProcessingException {
            block9: {
                if (spConfiguration == null) {
                    throw new IllegalStateException("SP Configuration is null");
                }
                try {
                    String issuerDomain = SAML2IssuerTrustHandler.getDomain(issuer);
                    TrustType spTrust = spConfiguration.getTrust();
                    if (spTrust != null) {
                        String domainsTrusted = spTrust.getDomains();
                        if (SAML2IssuerTrustHandler.this.trace) {
                            log.trace((Object)("Domains that SP trusts=" + domainsTrusted + " and issuer domain=" + issuerDomain));
                        }
                        if (domainsTrusted.indexOf(issuerDomain) < 0) {
                            StringTokenizer st = new StringTokenizer(domainsTrusted, ",");
                            while (st != null && st.hasMoreTokens()) {
                                String uriBit = st.nextToken();
                                if (SAML2IssuerTrustHandler.this.trace) {
                                    log.trace((Object)("Matching uri bit=" + uriBit));
                                }
                                if (issuerDomain.indexOf(uriBit) <= 0) continue;
                                if (SAML2IssuerTrustHandler.this.trace) {
                                    log.trace((Object)("Matched " + uriBit + " trust for " + issuerDomain));
                                }
                                return;
                            }
                            throw new IssuerNotTrustedException(issuer);
                        }
                        break block9;
                    }
                    throw new ConfigurationException("trust element missing");
                }
                catch (Exception e) {
                    throw new ProcessingException(new IssuerNotTrustedException(e.getLocalizedMessage(), e));
                }
            }
        }
    }

    private class IDPTrustHandler {
        private IDPTrustHandler() {
        }

        public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response, IDPType idpConfiguration) throws ProcessingException {
            String issuer = request.getIssuer().getValue();
            this.trustIssuer(idpConfiguration, issuer);
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response, IDPType idpConfiguration) throws ProcessingException {
            String issuer = request.getIssuer().getValue();
            this.trustIssuer(idpConfiguration, issuer);
        }

        private void trustIssuer(IDPType idpConfiguration, String issuer) throws ProcessingException {
            block9: {
                if (idpConfiguration == null) {
                    throw new IllegalStateException("IDP Configuration is null");
                }
                try {
                    String issuerDomain = SAML2IssuerTrustHandler.getDomain(issuer);
                    TrustType idpTrust = idpConfiguration.getTrust();
                    if (idpTrust != null) {
                        String domainsTrusted = idpTrust.getDomains();
                        if (SAML2IssuerTrustHandler.this.trace) {
                            log.trace((Object)("Domains that IDP trusts=" + domainsTrusted + " and issuer domain=" + issuerDomain));
                        }
                        if (domainsTrusted.indexOf(issuerDomain) < 0) {
                            StringTokenizer st = new StringTokenizer(domainsTrusted, ",");
                            while (st != null && st.hasMoreTokens()) {
                                String uriBit = st.nextToken();
                                if (SAML2IssuerTrustHandler.this.trace) {
                                    log.trace((Object)("Matching uri bit=" + uriBit));
                                }
                                if (issuerDomain.indexOf(uriBit) <= 0) continue;
                                if (SAML2IssuerTrustHandler.this.trace) {
                                    log.trace((Object)("Matched " + uriBit + " trust for " + issuerDomain));
                                }
                                return;
                            }
                            throw new IssuerNotTrustedException(issuer);
                        }
                        break block9;
                    }
                    throw new ConfigurationException("trust element missing");
                }
                catch (Exception e) {
                    throw new ProcessingException(new IssuerNotTrustedException(e.getLocalizedMessage(), e));
                }
            }
        }
    }
}

