/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.security.PublicKey;
import java.util.Map;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.web.handlers.saml2.BaseSAML2Handler;
import org.w3c.dom.Document;

public class SAML2SignatureValidationHandler
extends BaseSAML2Handler {
    private static Logger log = Logger.getLogger(SAML2SignatureValidationHandler.class);
    private boolean trace = log.isTraceEnabled();

    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        Map<String, Object> requestOptions = request.getOptions();
        Boolean ignoreSignatures = (Boolean)requestOptions.get("IGNORE_SIGNATURES");
        if (ignoreSignatures == Boolean.TRUE) {
            return;
        }
        Document signedDocument = request.getRequestDocument();
        if (this.trace) {
            log.trace((Object)("Will validate :" + DocumentUtil.asString(signedDocument)));
        }
        PublicKey publicKey = (PublicKey)request.getOptions().get("SENDER_PUBLIC_KEY");
        try {
            boolean isValid = this.validateSender(signedDocument, publicKey);
            if (!isValid) {
                throw new ProcessingException();
            }
        }
        catch (ProcessingException pe) {
            response.setError(100, "Signature Validation Failed");
            throw pe;
        }
    }

    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        Map<String, Object> requestOptions = request.getOptions();
        Boolean ignoreSignatures = (Boolean)requestOptions.get("IGNORE_SIGNATURES");
        if (ignoreSignatures == Boolean.TRUE) {
            return;
        }
        Document signedDocument = request.getRequestDocument();
        if (this.trace) {
            log.trace((Object)("Document for validation=" + DocumentUtil.asString(signedDocument)));
        }
        PublicKey publicKey = (PublicKey)request.getOptions().get("SENDER_PUBLIC_KEY");
        this.validateSender(signedDocument, publicKey);
    }

    private boolean validateSender(Document signedDocument, PublicKey publicKey) throws ProcessingException {
        try {
            return XMLSignatureUtil.validate(signedDocument, publicKey);
        }
        catch (Exception e) {
            log.error((Object)"Error validating signature:", (Throwable)e);
            throw new ProcessingException("Error validating signature.");
        }
    }
}

